package com.baijia.tianxiao.sal.organization.index.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.HagConf;
import com.baijia.tianxiao.sal.organization.dto.request.TxVisitorRequest;
import com.baijia.tianxiao.sal.organization.index.service.TxVisitorService;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.yunying.hag.common.BizConf;
import com.baijia.yunying.hag.service.HagService;

import lombok.extern.slf4j.Slf4j;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/3/7 Time: 下午3:34 To change this template use File | Settings |
 * File Templates.
 */
@Service
@Slf4j
public class TxVisitorServiceImpl implements TxVisitorService {
    private static String TRY_SMS = "亲爱的老师，您好！您的体验申请已经成功提交，我们很快会和您联系。请加天校运营经理微信：15311745604，随时为您解答任何问题。";
    private static String FREE_SMS = "亲爱的老师，您好！您的大众版天校账号申请已经成功提交，我们很快会和您联系。请加天校运营经理微信：15311745604，随时为您解答任何问题。";

    @Autowired
    private TxVisitorDao txVisitorDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired(required = false)
    private HagService hagService;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;

    @Override
    public void saveVisitor(TxVisitorRequest request) {
        if(null == request.getApplyType()){//兼容旧逻辑
            request.setApplyType(0);
        }

        OrgAccount orgAcc = orgAccountDao.getAccountByMobile(request.getMobile());
        log.info("the visitor mobile is bind with orgAccount =={}", orgAcc);
        if(null != orgAcc){
            OrgSubAccount subAcc = orgSubAccountDao.getByOrgId(orgAcc.getId());
            log.info("the visitor mobile is bind with OrgSubAccount =={}", subAcc);
            if(null != subAcc){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "此手机号码正在享受天校服务,请勿重新申请");
            }
        }
        
        log.info("save visitor request =={}", request);

        List<TxVisitor> exist = txVisitorDao.getByMobile(request.getMobile());
        if (CollectionUtils.isNotEmpty(exist) && exist.get(0).getApplyType()== 0 &&request.getApplyType()== 0) {//访问表存在该手机，并且存在类型与请求类型都是体验版
            log.info("I don't save exist visitor for try! request:{}", request);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "此手机号码已在体验版申请列表中，请耐心等候");
        }else if (CollectionUtils.isNotEmpty(exist) && exist.get(0).getApplyType()== 1 &&request.getApplyType()== 0) {//访问表存在该手机，存在大众版账号申请，请求体验版，不能降级
            log.info("I don't save exist visitor from free to try ! request:{}", request);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "此手机号码已在大众版申请列表中，无法再申请体验版");
        }else if (CollectionUtils.isNotEmpty(exist) && exist.get(0).getApplyType()== 1 &&request.getApplyType()== 1) {//访问表存在该手机，并且存在类型与请求类型都是大众版
            log.info("I don't save exist visitor for free! request:{}", request);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "此手机号码已在大众版申请列表中，请耐心等候");
        }else if (CollectionUtils.isNotEmpty(exist) && exist.get(0).getApplyType()== 0 &&request.getApplyType()== 1) {//访问表存在该手机，存在体验版账号申请，请求大众版，可以升级
            log.info("I will upgrade the visitor level! request:{}", request);
            //进行升级处理 更新tx_visitor status 1->0；applyType 0->1
            TxVisitor txVisitor = this.upgradeFromTryToFreeTXVister(request);
            SmsSendUtil.send(txVisitor.getMobile(), FREE_SMS, SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, true);
            log.info("upgrade the visitor level success =={}", txVisitor);
            return;
        }

        TxVisitor txVisitor = new TxVisitor();

        if (StringUtils.isEmpty(request.getOrgName()) || request.getOrgName().length() > 32) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setOrgName(request.getOrgName());

        if (StringUtils.isEmpty(request.getName()) || request.getName().length() > 10) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setName(request.getName());

        if (StringUtils.isEmpty(request.getMobile())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setMobile(request.getMobile());

        if (request.getProvinceId() == null || request.getCityId() == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setProvince(request.getProvince());
        txVisitor.setCity(request.getCity());
        txVisitor.setProvinceId(request.getProvinceId());
        txVisitor.setCityId(request.getCityId());

        if (!StringUtils.isEmpty(request.getRemark()) && request.getRemark().length() > 200) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setRemark(request.getRemark());
        
        if (request.getApplyType() == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setApplyType(request.getApplyType());

        txVisitor.setSource(request.getSource());
        txVisitor.setStatus(DataStatus.NORMAL.getValue());
        txVisitor.setCreateTime(new Date());
        txVisitor.setUpdateTime(new Date());
        txVisitor.setIsdel(DeleteStatus.NORMAL.getValue());
        txVisitorDao.save(txVisitor);
        if(request.getApplyType() == 0){
            SmsSendUtil.send(txVisitor.getMobile(), TRY_SMS, SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, true);
        }else if(request.getApplyType() == 1){
            SmsSendUtil.send(txVisitor.getMobile(), FREE_SMS, SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, true);
        }
        log.info("save visitor success =={}", txVisitor);
    }

    private TxVisitor upgradeFromTryToFreeTXVister(TxVisitorRequest request) {
        TxVisitor txVisitor = new TxVisitor();

        if (StringUtils.isEmpty(request.getOrgName()) || request.getOrgName().length() > 32) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setOrgName(request.getOrgName());//

        if (StringUtils.isEmpty(request.getName()) || request.getName().length() > 10) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setName(request.getName());//

        if (StringUtils.isEmpty(request.getMobile())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setMobile(request.getMobile());/**/

        if (request.getProvinceId() == null || request.getCityId() == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setProvince(request.getProvince());//
        txVisitor.setCity(request.getCity());//
        txVisitor.setProvinceId(request.getProvinceId());//
        txVisitor.setCityId(request.getCityId());//

        if (!StringUtils.isEmpty(request.getRemark()) && request.getRemark().length() > 200) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setRemark(request.getRemark());//
        
        if (request.getApplyType() == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setApplyType(request.getApplyType());//

        txVisitor.setSource(request.getSource());//
        txVisitor.setStatus(DataStatus.NORMAL.getValue());//
        txVisitor.setCreateTime(new Date());//
        txVisitor.setUpdateTime(new Date());//
        txVisitor.setIsdel(DeleteStatus.NORMAL.getValue());//
        this.txVisitorDao.updateByMobile(txVisitor);
        return txVisitor;
    }

    @Override
    public List<TxVisitor> getListByDate(Date startDate, Date endDate) {

        List<TxVisitor> list = txVisitorDao.listByTime(startDate, endDate);
        log.debug("get visitor startDate={},endDate={}, list =={}", startDate, endDate, list.size());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public Integer getActiveCount() {
        Integer count = txVisitorDao.getActiveCount();
        return count;
    }

    @Override
    public List<TxVisitor> getByMobile(String mobile) {
        if (StringUtils.isEmpty(mobile)) {
            return null;
        }
        List<TxVisitor> visitors = txVisitorDao.getByMobile(mobile);
        return visitors;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.sal.organization.index.service.TxVisitorService#isOrgAccountValid(java.lang.Integer)
     */

    @Override
    public boolean isOrgAccountValid(Integer orgId) {
        boolean result = false;
        if (orgId != null) {
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
            log.info("oorgAccountrgId:{}", orgAccount);
            if (orgAccount != null) {
                if (hagService.hasPermission(orgAccount.getNumber(), BizConf.DEFAULT_ENTITY_TYPE,
                    HagConf.HAG_RESOURCE_TIANXIAO_TRIAL_ACCOUNT)) {
                    result = true;
                }
            }
        }
        return result;

    }

    @Override
    public void updateVisitor(TxVisitor txVisitor) {
        txVisitorDao.saveOrUpdate(txVisitor);
    }
}