package com.baijia.tianxiao.sal.organization.finance.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.finance.dto.response.TxSuggestBankDto;
import com.baijia.tianxiao.sal.organization.finance.service.PaySmsService;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.pay.PayHttpRestUtil;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/11
 * Time: 下午5:30
 * To change this template use File | Settings | File Templates.
 */
@Service
@Slf4j
public class PaySmsServiceImpl implements PaySmsService {

    @Override
    public String paySmsCode(int voice, Long orgId) throws BussinessException, IOException {

        Map<String, String> result = null;
        Map<String, String> params = new HashMap<>();
        params.put("voice", voice + "");
        params.put("user_id", orgId + "");
        params.put("user_role", UserRole.ORGANIZATION.getRole() + "");

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/sms/verifyMobile", params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            try {
                result = JacksonUtil.str2Obj(jsondata.toString(), HashMap.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        return result.get("code");
    }

    @Override
    public String checkCode(int smsCode, Long orgId) throws BussinessException, IOException {
        Map<String, String> result = null;
        Map<String, String> params = new HashMap<>();
        params.put("sms_code", smsCode + "");
        params.put("user_id", orgId + "");
        params.put("user_role", UserRole.ORGANIZATION.getRole() + "");

        Object data = PayHttpRestUtil.rest(PayHttpRestUtil.PAY_SERVICE + "/sms/checkMobile", params);
        if (isNotNullJsonNode(data)) {
            JSONObject jsondata = JSONObject.fromObject(data);
            try {
                result = JacksonUtil.str2Obj(jsondata.toString(), HashMap.class);
            } catch (Exception e) {
                log.warn("e", e);
            }
        }
        return result.get("code");
    }


    private static boolean isNotNullJsonNode(Object node) {
        if (node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]")) {
            return true;
        }
        return false;
    }
}
