package com.baijia.tianxiao.sal.organization.todo.constant;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * @title TodoErrorCode
 * @desc 今日待办错误编码
 * @author shanyu
 * @date 2016年02月26日
 * @version 1.0
 */
public enum TodoErrorCode implements UniverseErrorCode {

    UNKNOW(1, "未知类型错误"),
    PARAM_ERROR(1001, "请求参数错误"),
    ORG_NOT_EXIST(1002, "机构不存在"),
    STUDENT_NOT_EXIST(1003, "学员不存在或已被删除"),
    BACKLOG_NOT_EXIST(1004, "待办事项不存在或已被删除"),
    STUDENT_NOT_IN_ORG(1005, "学员不属于该机构"),
    BACKLOG_HAS_FINISH(1006, "待办事项已是完成状态"),
    BACKLOG_HAS_UNFINISH(1007, "待办事项已是未完成状态"),
    GET_BACKLOG_DETAIL_FAILED(1008, "获取待办事项详情失败"),
    CAN_NOT_EDIT_EXPIRED_BACKLOG(1009, "不能编辑已过期的待办事项"),
    CAN_NOT_EDIT_FINISH_BACKLOG(1010, "不能编辑已完成的待办事项"),
    CAN_NOT_EDIT_SYSTEM_BACKLOG_WITH_STUDENT(1011, "不能编辑系统待办事项的关联学员"),
    ;

    private int code;
    private String message;

    TodoErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    @Override
    public Subsystem getSystem() {
        return Subsystem.TODO;
    }

    @Override
    public Platform getPlatform() {
        return Platform.PC;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public UniverseErrorCode fromCode(int code) {
        for (TodoErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return TodoErrorCode.UNKNOW;
    }
}
