
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service;

import com.baijia.tianxiao.dal.org.po.TXAccount;

import java.util.List;

/**
 * @author caoliang
 * @version 1.0
 * @title TXCampusAccountService
 * @desc TODO
 * @date 2016年5月10日
 */

public interface TXAccountService {
    /**
     * 机构是否可以使用天校
     * @param orgId
     * @return
     */
    boolean orgAccessValid(Integer orgId);
    
    TXAccount getByOrgId(Integer orgId,String...props);
    
    @Deprecated
    TXAccount getByOrgIdIgnoreStatus(Integer orgId, String... props);

    TXAccount getByIdAndOrgId(Integer id, Integer orgId);

    TXAccount getByOrgNumber(Integer orgNumber);

    /**
     * 根据当前帐号orgId查询txAccount
     * 当前帐号有可能是子校区帐号，如果是子校区,需要根据父校区orgId来查询txAccount
     *
     * @param orgId
     * @return
     */
    TXAccount getTXAccountByOrgId(Integer orgId,String...props);

    /**
     * 根据机构ID获取主账号的设置的短信网关,默认6
     *
     * @param orgId
     * @return
     */
    Integer getTxAccountSmsGate(Integer orgId);

    void saveTXAccount(TXAccount txAccount);

    TXAccount getByMobile(String mobile);

    TXAccount getById(Long id);

    List<Long> getAllTxAccountOrgId();


}

    