
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.OrgPayPasswordDao;
import com.baijia.tianxiao.dal.org.po.OrgPayPassword;
import com.baijia.tianxiao.sal.organization.api.OrgPayPasswordService;

import lombok.extern.slf4j.Slf4j;

/**
 * @title OrgPayPasswordServiceImpl
 * @desc TODO 
 * @author caoliang
 * @date 2016年4月26日
 * @version 1.0
 */
    
@Service
@Slf4j
public class OrgPayPasswordServiceImpl implements OrgPayPasswordService {

    @Autowired
    private OrgPayPasswordDao orgPayPasswordDao;

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.organization.api.OrgPayPasswordService#getOrgPayPwdByOrgId(java.lang.Integer)
     */
        
    @Override
    public OrgPayPassword getOrgPayPwdByOrgId(Integer orgId) {
        OrgPayPassword opp = orgPayPasswordDao.getPayPwdByOrgId(orgId);
        return opp;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.organization.api.OrgPayPasswordService#addOrgPayPwd(com.baijia.tianxiao.dal.org.po.OrgPayPassword)
     */
        
    @Override
    public void addOrgPayPwd(OrgPayPassword opp) {
        orgPayPasswordDao.save(opp);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.organization.api.OrgPayPasswordService#updateOrgPayPwd(com.baijia.tianxiao.dal.org.po.OrgPayPassword)
     */
        
    @Override
    public void updateOrgPayPwd(OrgPayPassword opp) {
        orgPayPasswordDao.update(opp);
    }
}

    