/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.constant;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;

import java.util.Set;

import lombok.Getter;

/**
 * @author hongyan
 * @version 1.0
 * @title TXPermissionConst
 * @desc 重构的constant, 只用于方便查询.当有新权限增加时, rd需在这里增加枚举值
 * @date 2016年8月6日
 */
public enum TXPermissionConst {
    CAMPUS_MANAGEMENT(1, "校区管理"),
    
    CONSULT_CLUE(4, "线索管理"),
    
    STUDENT_MANAGEMENT(5, "学员管理"),

    CAMPUS_SETTING(100, "校区设置"),

    ACCOUNT_SETTING(101, "账号设置"),

    FINANCE_MANAGEMENT(102, "资金管理"),

    RULE_SETTING(103, "设置规则"),

    SEE_ALL_CONSULT_RECORD(104, "查看机构所有咨询记录"),

    PERSONAL_CONSULT_MANAGEMENT(105, "处理分配给自己的咨询"),

    SEE_ALL_CLUES(106, "查看机构所有线索信息"),

    DELETE_CLUES(107, "删除线索"),

    DISTRIBUTE_CLUES(108, "分配线索"),

    EXPORT_CLUES(109, "导出线索"),

    ACTIVATE_INVALID_CLUES(110, "激活无效线索"),

    PERSONAL_CLUES_MANAGEMENT(111, "管理分配给自己的线索"),

    SEE_ALL_ORG_STUDENTS(112, "查看机构所有学员信息"),

    DELETE_STUDENTS(113, "删除学员"),

    EXPORT_STUDENTS(114, "导出学员"),

    PERSONAL_STUDENTS_MANAGEMENT(115, "管理分配给自己的学员"),

    ADD_NEW_CLASSES(116, "新增班级"),

    ADD_NEW_TEACHERS(117, "新增老师"),

    ADD_NEW_CLASSROOMS(118, "新增教室"),

    DISTRIBUTE_CLASSMANAGER(119, "分配班主任"), // SHOW_ENTER_CLASS_ARWANGEMENT

    SHOW_ENTER_CLASS_ARRANGEMENT(120, "是否显示排课入口"),

    IF_SIGNUP(121, "是否可签到"),

    IF_COLLECT_MONEY(122, "是否可收款"),

    ADD_MARKETING_ACTIVITY(123, "新增营销活动"),

    IF_CLASS_ARRANGE(124, "是否可以排课"),

    SHOW_ENTER_SIGNUP(125, "是否显示签到入口"),

    // SHOW_ENTER_FINANCE(126, "是否显示资金入口"),

    // SHOW_TEACHER_PARTLY_FUNCTION(127, "是否显示老师部分功能"),

    SHOW_ENTER_CLASS_SCHEDULE(128, "是否显示课表入口"),

    IF_MANAGE_CLASS_SCHEDULE(129, "是否可以管理课表"),

    DASHBOARD(130, "仪表盘"),

    PIC_OF_ENROLL_FUNNEL(131, "招生漏斗图"),

    REPORT_OF_CONSULT_SOURCE(132, "咨询来源分析报表"),

    WECHAT_FANS_TREND(133, "微信粉丝增减趋势"),

    TO_BE_DONE_TODAY(134, "今日待办"),

    MESSAGE(135, "消息"),

    NOTIFY(136, "通知"),

    COLLEAGUE_CONTACTS(137, "同事通讯录"),

    CLUES_MANAGEMENT(138, "线索管理"),

    ENROLL_FUNNEL(139, "招生漏斗"),

    REMIND_OF_WORK(140, "工作提醒"),

    CLASS_ARRANGEMENT(141, "排课"),

    CLASS_SCHEDULE(142, "课表"),

    APPRAISE(143, "评价"),

    CLASS_CAN_BE_ARRANGE_PIC(144, "可排课班级首图"),

    WECHAT_HOUSEKEEPER(145, "微信管家"),

    ZHUANJIESHAO(146, "转介绍"),

    QUANWANGBAOWEN(147, "全网爆文"),

    SAOYISAO(148, "扫一扫"),

    PHONE_400(149, "400电话"),

    GSXTUIGUANG(150, "跟谁学推广"),

    FUZESHOUTU(151, "我负责的班级首图"),

    TOUPIAO(152, "微信投票"),

    CHOUJIANG(153, "微信抽奖"),

    QUNFAXIAOXI(154, "群发消息"),

    QUNFADUANXIN(155, "群发短信"),

    WEIHUODONG(156, "微活动"),

    HUODONGBAOMING(157, "活动报名"),

    WEIGUANWANG(159, "微官网"),

    SHEBANRUKOU(160, "是否显示设班入口"),

    VZHIBO(161, "微直播"),

    KEXIAO_SUPPLEMENT(162, "补充课消信息"),

    KEXIAO_REPORT(163, "课消报表"),

    ADD_LESSON_KEBIAO(164, "是否可在课表中添加课节"),

    WX_EDIT_STUDENTS(170, "网校编辑学员"),

    WX_FORBID_STUDENTS(171, "网校禁用学员"),

    WX_ADD_NEW_COURSE(172, "网校新增课程"),

    WX_DELETE_COURSE(173, "网校删除课程"),

    WX_MANAGE_COURSE(174, "网校管理课程"),

    WX_CLASS_SCHEDULE(175, "网校排课课表"),

    WX_TEACHER_LIST(176, "网校老师列表"),

    WX_LIVE_CLASSROOM(177, "网校直播教室"),

    WX_DECORATE(178, "网校装修"),

    WX_START_SERVICE(179, "网校开通服务"),

    WX_VIDEO_FACTORY(180, "网校视频库"),

    WX_LIVE_PLAYBACK(181, "网校直播回放"),

    WX_NEWS_MANAGEMENT(182, "网校新闻管理"),

    WX_HOME_PAGE_DATA(184, "网校首页数据"),

    ASSIGNMENT(185, "作业管理"),

    ASSIGNMENT_MENU(186, "作业管理入口"),

    EXAM(187, "考试管理"),

    EXAM_MENU(188, "考试管理入口"), GRADE(189, "成绩管理"), GRADE_MENU(190, "成绩管理入口"),

    SIGN_TRANS_QUIT_DATA_ACCESS(191, "查看报转退数据"),

    REMAINNING_FEE(192, "查看剩余学费"),

    SINGLE_KEXIAO_LESSON_FEE(193, "查看单节课消金额"),

    STUDENT_ACCOUNT(194, "查看学员账户"),

    ALL_CLASSES(195, "设班-查看所有班级"),

    LIJIA_KEXIAO(196, "立加课消报表"),

    TIMESCARD_MANAGEMENT(197, "次卡管理"),

    TIMESCARD_BUY(198, "购买次卡"),

    TIMESCARD_DELAY(199, "操作延期"),

    TIMESCARD_QRSIGN_LIST(200, "查看扫码签到列表"),

    TIMESCARD_QRSIGN_SUPPLIMENT(201, "补充扫码签到信息"),

    TIMESCARD_INFO(202, "查看合同次卡信息"),

    ;

    @Getter
    private long pCode;
    @Getter
    private String pName;

    TXPermissionConst(Integer pCode, String pName) {
        this.pCode = pCode.longValue();
        this.pName = pName;
    }

    /* ===================================以下保存特殊逻辑使用的常量集合==================================== */

    /**
     * @desc 重构的权限更改一对多map, 将只保存冗余的对应关系, 自身对应被剔除.对应关系被改为code.
     * @author hongyan
     * @date 2016年8月6日
     * @version 1.0
     */
    public static final Multimap<Long, Long> ONE_MULTY_CODE_MAP = ArrayListMultimap.create();
    public static final Multimap<Long, Long> ONE_MULTY_CODE_LOST_MAP = ArrayListMultimap.create();
    static {
        ONE_MULTY_CODE_MAP.put(SHOW_ENTER_CLASS_ARRANGEMENT.getPCode(), IF_CLASS_ARRANGE.getPCode());// 124
        ONE_MULTY_CODE_MAP.put(SHOW_ENTER_CLASS_ARRANGEMENT.getPCode(), ADD_LESSON_KEBIAO.getPCode());// 164
        ONE_MULTY_CODE_MAP.put(IF_SIGNUP.getPCode(), SHOW_ENTER_SIGNUP.getPCode());// 125
        // 应pc权限需要, 当有校区设置, 帐号设置, 二者其一时, 要勾选校区管理.
        ONE_MULTY_CODE_MAP.put(CAMPUS_SETTING.getPCode(), CAMPUS_MANAGEMENT.getPCode());// 100
        ONE_MULTY_CODE_MAP.put(ACCOUNT_SETTING.getPCode(), CAMPUS_MANAGEMENT.getPCode());// 101
        // 次卡权限没有 都没有
        ONE_MULTY_CODE_LOST_MAP.put(TIMESCARD_MANAGEMENT.getPCode(), TIMESCARD_BUY.getPCode());
        ONE_MULTY_CODE_LOST_MAP.put(TIMESCARD_MANAGEMENT.getPCode(), TIMESCARD_DELAY.getPCode());
        ONE_MULTY_CODE_LOST_MAP.put(TIMESCARD_MANAGEMENT.getPCode(), TIMESCARD_QRSIGN_LIST.getPCode());
        ONE_MULTY_CODE_LOST_MAP.put(TIMESCARD_MANAGEMENT.getPCode(), TIMESCARD_QRSIGN_SUPPLIMENT.getPCode());
        ONE_MULTY_CODE_LOST_MAP.put(TIMESCARD_MANAGEMENT.getPCode(), TIMESCARD_INFO.getPCode());
    }

    /**
     * @desc 合同次卡权限集合
     * @author hongyan
     */
    public static final Set<Long> TIMESCARD_PERMISSION_SET = Sets.newHashSet();
    static {
        TIMESCARD_PERMISSION_SET.add(TIMESCARD_BUY.getPCode());
        TIMESCARD_PERMISSION_SET.add(TIMESCARD_DELAY.getPCode());
        TIMESCARD_PERMISSION_SET.add(TIMESCARD_QRSIGN_LIST.getPCode());
        TIMESCARD_PERMISSION_SET.add(TIMESCARD_QRSIGN_SUPPLIMENT.getPCode());
        TIMESCARD_PERMISSION_SET.add(TIMESCARD_INFO.getPCode());
    }

    /**
     * @desc 网校权限集合, 包含了所有网校权限
     * @author hongyan
     */
    public static final Set<Long> WANGXIAO_PERMISSION_SET = Sets.newHashSet();
    static {
        WANGXIAO_PERMISSION_SET.add(FINANCE_MANAGEMENT.getPCode());// 102
        WANGXIAO_PERMISSION_SET.add(IF_COLLECT_MONEY.getPCode());// 122
        WANGXIAO_PERMISSION_SET.add(WX_EDIT_STUDENTS.getPCode());// 170
        WANGXIAO_PERMISSION_SET.add(WX_FORBID_STUDENTS.getPCode());// 171
        WANGXIAO_PERMISSION_SET.add(WX_ADD_NEW_COURSE.getPCode());// 172
        WANGXIAO_PERMISSION_SET.add(WX_DELETE_COURSE.getPCode());// 173
        WANGXIAO_PERMISSION_SET.add(WX_MANAGE_COURSE.getPCode());// 174
        WANGXIAO_PERMISSION_SET.add(WX_CLASS_SCHEDULE.getPCode());// 175
        WANGXIAO_PERMISSION_SET.add(WX_TEACHER_LIST.getPCode());// 176
        WANGXIAO_PERMISSION_SET.add(WX_LIVE_CLASSROOM.getPCode());// 177
        WANGXIAO_PERMISSION_SET.add(WX_DECORATE.getPCode());// 178
        WANGXIAO_PERMISSION_SET.add(WX_START_SERVICE.getPCode());// 179
        WANGXIAO_PERMISSION_SET.add(WX_VIDEO_FACTORY.getPCode());// 180
        WANGXIAO_PERMISSION_SET.add(WX_LIVE_PLAYBACK.getPCode());// 181
        WANGXIAO_PERMISSION_SET.add(WX_NEWS_MANAGEMENT.getPCode());// 182
        WANGXIAO_PERMISSION_SET.add(WX_HOME_PAGE_DATA.getPCode());// 184
    }
    
    public static final Set<Long> WANGXIAO_NO_PERMISSION_SET = Sets.newHashSet();
    static {
        WANGXIAO_NO_PERMISSION_SET.add(CONSULT_CLUE.getPCode());// 4
        WANGXIAO_NO_PERMISSION_SET.add(STUDENT_MANAGEMENT.getPCode());// 5
        WANGXIAO_NO_PERMISSION_SET.add(FINANCE_MANAGEMENT.getPCode());// 102
        WANGXIAO_NO_PERMISSION_SET.add(RULE_SETTING.getPCode());// 103
        WANGXIAO_NO_PERMISSION_SET.add(SHOW_ENTER_CLASS_ARRANGEMENT.getPCode());// 120
        WANGXIAO_NO_PERMISSION_SET.add(IF_COLLECT_MONEY.getPCode());// 122
        WANGXIAO_NO_PERMISSION_SET.add(KEXIAO_SUPPLEMENT.getPCode());// 162
        WANGXIAO_NO_PERMISSION_SET.add(KEXIAO_REPORT.getPCode());// 163
        WANGXIAO_NO_PERMISSION_SET.add(ALL_CLASSES.getPCode());// 195
    }

    /**
     * 总校区主管,额外可编辑权限.
     */
    public static final Set<Long> MAIN_CAMPUS_MANAGER_ADDITIONAL_PERMISSION_SET = Sets.newHashSet();
    static {
        MAIN_CAMPUS_MANAGER_ADDITIONAL_PERMISSION_SET.add(CAMPUS_SETTING.getPCode());
        MAIN_CAMPUS_MANAGER_ADDITIONAL_PERMISSION_SET.add(ACCOUNT_SETTING.getPCode());
    }

    /**
     * @desc 通用版权限集合, 包含了所有通用版权限
     * @author hongyan
     */
    public static final Set<Long> NORMAL_PERMISSION_SET = Sets.newHashSet();
    static {
        NORMAL_PERMISSION_SET.add(FINANCE_MANAGEMENT.getPCode());// 102
        NORMAL_PERMISSION_SET.add(RULE_SETTING.getPCode());// 103

        NORMAL_PERMISSION_SET.add(SEE_ALL_CONSULT_RECORD.getPCode());// 104
        NORMAL_PERMISSION_SET.add(PERSONAL_CONSULT_MANAGEMENT.getPCode());// 105

        NORMAL_PERMISSION_SET.add(SEE_ALL_CLUES.getPCode());// 106
        NORMAL_PERMISSION_SET.add(DELETE_CLUES.getPCode());// 107
        NORMAL_PERMISSION_SET.add(DISTRIBUTE_CLUES.getPCode());// 108
        NORMAL_PERMISSION_SET.add(EXPORT_CLUES.getPCode());// 109
        NORMAL_PERMISSION_SET.add(ACTIVATE_INVALID_CLUES.getPCode());// 110
        NORMAL_PERMISSION_SET.add(PERSONAL_CLUES_MANAGEMENT.getPCode());// 111

        NORMAL_PERMISSION_SET.add(SEE_ALL_ORG_STUDENTS.getPCode());// 112
        NORMAL_PERMISSION_SET.add(DELETE_STUDENTS.getPCode());// 113
        NORMAL_PERMISSION_SET.add(EXPORT_STUDENTS.getPCode());// 114
        NORMAL_PERMISSION_SET.add(PERSONAL_STUDENTS_MANAGEMENT.getPCode());// 115
        NORMAL_PERMISSION_SET.add(SIGN_TRANS_QUIT_DATA_ACCESS.getPCode());// 191
        NORMAL_PERMISSION_SET.add(REMAINNING_FEE.getPCode());// 192
        NORMAL_PERMISSION_SET.add(SINGLE_KEXIAO_LESSON_FEE.getPCode());// 193
        NORMAL_PERMISSION_SET.add(STUDENT_ACCOUNT.getPCode());// 194

        NORMAL_PERMISSION_SET.add(ALL_CLASSES.getPCode());// 195
        NORMAL_PERMISSION_SET.add(ADD_NEW_CLASSES.getPCode());// 116
        NORMAL_PERMISSION_SET.add(ADD_NEW_TEACHERS.getPCode());// 117
        NORMAL_PERMISSION_SET.add(ADD_NEW_CLASSROOMS.getPCode());// 118
        NORMAL_PERMISSION_SET.add(DISTRIBUTE_CLASSMANAGER.getPCode());// 119
        NORMAL_PERMISSION_SET.add(IF_SIGNUP.getPCode());// 121
        NORMAL_PERMISSION_SET.add(SHOW_ENTER_CLASS_ARRANGEMENT.getPCode());// 120

        NORMAL_PERMISSION_SET.add(IF_COLLECT_MONEY.getPCode());// 122
        NORMAL_PERMISSION_SET.add(KEXIAO_SUPPLEMENT.getPCode());// 162
        NORMAL_PERMISSION_SET.add(KEXIAO_REPORT.getPCode());// 163

        NORMAL_PERMISSION_SET.add(ADD_MARKETING_ACTIVITY.getPCode());// 123

        NORMAL_PERMISSION_SET.add(ASSIGNMENT_MENU.getPCode());// 186
        NORMAL_PERMISSION_SET.add(EXAM_MENU.getPCode());// 188
        NORMAL_PERMISSION_SET.add(GRADE_MENU.getPCode());// 190
        NORMAL_PERMISSION_SET.add(LIJIA_KEXIAO.getPCode());// 196
    }

    /**
     * @desc 权限保存控制表
     * @author hongyan
     */
    public static final Set<Long> PERMISSION_SAVE_CONTROL_SET = Sets.newHashSet();

    static {
        // 通用版权限集合
        PERMISSION_SAVE_CONTROL_SET.addAll(NORMAL_PERMISSION_SET);
        // 一对多权限集合
        PERMISSION_SAVE_CONTROL_SET.addAll(ONE_MULTY_CODE_MAP.values());
        // 网校权限集合
        PERMISSION_SAVE_CONTROL_SET.addAll(WANGXIAO_PERMISSION_SET);
        // 合同次卡权限集合
        PERMISSION_SAVE_CONTROL_SET.addAll(TIMESCARD_PERMISSION_SET);
    }

    public static void main(String[] args) {
        System.out.println(PERMISSION_SAVE_CONTROL_SET);
    }
}
