package com.baijia.tianxiao.sal.organization.constant;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;

/**
 * Created by wengshengli on 2017/3/24.
 */
public enum ClientType {

    HW(1, "作业系统", "tx201703221528", "baijiahulian", 185l),

    EXAM(2, "考试系统", "tx201703221528", "baijiahulian", 187l),

    GRADE(3, "成绩系统", "tx201704221528", "baijiahulian_grade", 189l),

    SCORE(4, "积分系统", "", "", 0l),

    CALL_SERVICE(5, "双呼", "", "", 0l),

    LIJIA_KEXIAO(6, "立加课消报表", "", "", 196l),

    TIMESCARD(7, "次卡管理", "", "", 0L),

    ;
    @Getter
    private int code;
    @Getter
    private String name;
    @Getter
    private String appId;
    @Getter
    private String secertKey;
    @Getter
    private Long permissionCode;

    private static Map<Integer, ClientType> codeMap = Maps.newHashMap();

    static {
        for (ClientType clientType : ClientType.values()) {
            codeMap.put(clientType.getCode(), clientType);
        }
    }

    ClientType(int code, String name, String appId, String secertKey, Long permissionCode) {
        this.code = code;
        this.name = name;
        this.appId = appId;
        this.secertKey = secertKey;
        this.permissionCode = permissionCode;
    }

    public static ClientType getByCode(Integer code) {
        return codeMap.get(code);
    }


}
