package com.baijia.tianxiao.sal.organization.constant;


import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/3/5
 * Time: 下午3:26
 * To change this template use File | Settings | File Templates.
 */
public enum AreaLevel {
    COUNTRY(0, 0xFF00000000L),
    PROVINCE(1, 0xFFFF000000L),
    CITY(2, 0xFFFFFC0000L),
    COUNTY(3, 0xFFFFFFFC00L),
    REGION(4, 0xFFFFFFFFFFL),
    TRANSPORTATION(5, 0xFFFFFFFFFFL);
    private int level;
    private long mask;
    static Map<Integer, AreaLevel> map = Maps.newHashMap();

    static {
        map.put(AreaLevel.COUNTRY.getLevel(), AreaLevel.COUNTRY);
        map.put(AreaLevel.PROVINCE.getLevel(), AreaLevel.PROVINCE);
        map.put(AreaLevel.CITY.getLevel(), AreaLevel.CITY);
        map.put(AreaLevel.COUNTY.getLevel(), AreaLevel.COUNTY);
        map.put(AreaLevel.REGION.getLevel(), AreaLevel.REGION);
        map.put(AreaLevel.TRANSPORTATION.getLevel(), AreaLevel.TRANSPORTATION);
    }

    private AreaLevel(int level, long mask) {
        this.level = level;
        this.mask = mask;
    }

    public static AreaLevel getByLevel(int level) {
        return map.get(level);
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public long getMask() {
        return mask;
    }

    public void setMask(long mask) {
        this.mask = mask;
    }
}