package com.baijia.tianxiao.sal.organization.todo.dto;

import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.dal.todo.constant.BacklogStatus;
import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.Data;

/**
 * @title BacklogDto
 * @desc 待办事项传输对象
 * @author wangsixia
 * @date 2016年02月26日
 * @version 1.0
 */
@Data
public class BacklogDto extends BaseDto {

    private static final long serialVersionUID = 2556753917804894365L;

    private Long backlogId;
    
    private String content;
    
    private Long endTime;
    
    // RemindType;
    private int remindType;
    
    private int isSys;
    
    // TaskStatus
    private int finish;
    
    private String finishString;
    
    private RelatedStudent relatedStudent;
    
    private Integer cascadeId; // 子账号ID ,从TianxiaoMContext中获取，服务层添加
    
    private Integer backlogType;
    private Integer status;
    private BacklogAccountDto creator;
    private List<BacklogAccountDto> participants;
    private Integer isCreator;
    private List<String> operations;
    
    public Integer getStatus(){
    	if(this.endTime==null){
    		return BacklogStatus.UNKNOWN.getValue();
    	}
    	
    	if(this.endTime > DateUtil.getCurrentDate().getTime()){
    		return BacklogStatus.UNEXPIRED.getValue();
    	}else{
    		return BacklogStatus.EXPIRED.getValue();
    	}
    }
    

}
