package com.baijia.tianxiao.sal.organization.todo.constant;

/**
 * @title RemindType
 * @desc 提醒时间类型,diff单位为ms
 * @author wangsixia
 * @date 2016年02月25日
 * @version 1.0
 */
public enum RemindType {
    NO_REMIND(0,"不提醒", -1),
    ON_TIME(1,"准时", 0),
    FIVE_MIN_AHEAD(2,"提前5分钟", 300000),
    TEN_MIN_AHEAD(3,"提前10分钟", 600000),
    THIRTY_MIN_AHEAD(4,"提前30分钟", 1800000),
    ONE_HOUR_AHEAD(5,"提前1小时", 3600000),
    TWO_HOUR_AHEAD(6,"提前2小时", 7200000),
    ONE_DAY_AHEAD(7,"提前1天", 86400000),
    TWO_DAY_AHEAD(8,"提前2天", 172800000);
    
    int value;
    String note;
    long diff;
    
    private RemindType(int value, String note, long diff){
        this.value = value;
        this.note = note;
        this.diff = diff;
    }
    
    public int getValue(){
        return this.value;
    }
    
    public String getNote(){
        return this.note;
    }
    
    public long getDiff() {
        return this.diff;
    }
    
    public static RemindType getByDiff(long diff) {
        RemindType remindType = ON_TIME;
        for(RemindType type : values()) {
            if(type.getDiff() == Math.abs(diff)) {
                remindType = type;
                break;
            }
        }
        return remindType;
    }
    
    public static RemindType getByValue(int value) {
        RemindType remindType = null;
        for(RemindType type : RemindType.values()) {
            if(type.getValue() == value){
                remindType = type;
                break;
            }
        }
        return remindType;
    }
    
    public static long getDiffByValue(int value) {
        long diff = ON_TIME.getDiff();
        for(RemindType type : values()) {
            if(type.getValue() == value) {
                diff = type.getDiff();
                break;
            }
        }
        return diff;
    }
}

