package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.sal.organization.constant.AreaLevel;
import com.baijia.tianxiao.sal.organization.org.dto.AreaDto;
import com.baijia.tianxiao.sal.organization.org.service.AreaService;
import com.google.common.collect.Lists;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/3/5
 *
 * Time: 下午2:22
 * To change this template use File | Settings | File Templates.
 */
@Service
public class AreaServiceImpl implements AreaService {

    @Autowired
    private AreaDao areaDao;

    @Override
    public List<AreaDto> getByPid(long id) {
        Area area = areaDao.getById(id);
        if (area == null) {
            return Collections.EMPTY_LIST;
        }
        List<Area> areas = areaDao.getBylevel(id, AreaLevel.getByLevel(area.getLevel()).getMask(), area.getLevel() + 1);
        if (areas.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return buildArea(areas);
    }

    private List<AreaDto> buildArea(List<Area> areas) {
        List<AreaDto> result = Lists.newArrayList();
        for (Area area : areas) {
            AreaDto one = new AreaDto();
            one.setId(area.getId());
            one.setName(area.getName());
            result.add(one);
        }
        return result;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.organization.org.service.AreaService#getByCityBName(java.lang.String)
     */
        
    @Override
    public List<AreaDto> getByCityBName(String cityName) {
        List<Area> list = areaDao.getAreaByBname(cityName, AreaLevel.CITY.getLevel());
        return buildArea(list);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.organization.org.service.AreaService#getByProvinceBName(java.lang.String)
     */
        
    @Override
    public List<AreaDto> getByProvinceBName(String provinceName) {
        List<Area> list = areaDao.getAreaByBname(provinceName, AreaLevel.PROVINCE.getLevel());
        return buildArea(list);
    }
}
