/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.org.service;

import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.sal.organization.index.dto.OrgPhotoDto;

import java.util.List;
import java.util.Map;

/**
 * @author cxm
 * @version 1.0
 * @title OrgPhotoService
 * @desc TODO
 * @date 2015年10月27日
 */
public interface OrgPhotoService {

    /**
     * 根据机构ID和图片类型获取图片的url
     *
     * @param orgId
     * @param imgType
     * @return
     */
    String getPhotoUrlByOrgIdAndCategory(Long orgId, OrgImgType imgType);

    Map<String, Object> getPhotoByOrgIdAndCategory(Long orgId, OrgImgType imgType);

    int saveOrUpdateOrgPhoto(Long orgId, OrgImgType imgType, int logoId);

    List<OrgPhotoDto> listAllPhotoByType(Long orgId, OrgImgType imgType);

    void batchDeleteByIds(String ids);

}
