
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service;

import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfomationDto;

import java.util.List;
import java.util.Map;

/**
 * @title OrgInfoService
 * @desc TODO
 * @author zhangbing
 * @date 2016年1月6日
 * @version 1.0
 */

public interface OrgInfoService {

    /**
     * 获取机构基本信息：头像、简称、400分机
     * 
     * @param orgId
     * @return
     */
    OrgInfoSimpleDto getOrgInfo(Long orgId) throws BussinessException, Exception;

    /**
     *
     * @param orgId
     * @returnM获取简化版机构信息
     * @throws BussinessException
     * @throws Exception
     */
    OrgInfoSimpleDto getMOrgInfo(Long orgId);

    boolean updateTeacherSigninStatus(Long orgId, Integer signinStatus);

    Integer findSigninStatus(Integer orgId);
    
    Map<Integer, OrgInfo> getOrgInfoMap(List<Integer> orgIds);

    public String getLogo(int orgId);
    
    public OrgInfo getOrgInfoByOrgId(Integer orgId);

    /**
     * 用于app刷新机构,子账号基础信息的接口
     * 
     * @param orgId 机构的orgId,非空
     * @param cascadeId 子账号id,可空,空值返回的内容不包含子账号信息
     * @param imgServerLink 外部传过来的图片服务器连接,用于组装机构,子账号头像link
     * @param homepageLink 外部传过来的机构主页连接,形式类似 http://m.tianxiao100.com/i/number ,方法内部用orgNumber替换number.
     * @return 基础信息
     * @author hongyan
     */
    OrgInfomationDto getOrgInfoForRefresh(Integer orgId, Integer cascadeId, String imgServerLink,
        String homepageLink);

    /**
     * 优选老师业务,需要对自定义文本字段做特殊控制(文本长度上限设为500)
     * @param orgId
     * @return
     */
    boolean isOptimal(Long orgId);
}
