package com.baijia.tianxiao.sal.organization.index.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.sal.organization.index.dto.TxVisitorDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.index.constant.TxVisitorStatus;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.HagConf;
import com.baijia.tianxiao.sal.organization.dto.request.TxVisitorRequest;
import com.baijia.tianxiao.sal.organization.index.service.TxVisitorService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.yunying.hag.common.BizConf;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.base.Function;

import lombok.extern.slf4j.Slf4j;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/3/7 Time: 下午3:34 To change this template use File | Settings |
 * File Templates.
 */
@Service
@Slf4j
public class TxVisitorServiceImpl implements TxVisitorService {
    public static String defaultServerPhone = "4000910910";
    // private static String TRY_SMS = "亲爱的老师，您好！您的体验申请已经成功提交，我们很快会和您联系。请加天校运营经理微信：15311745604，随时为您解答任何问题。";
    @Deprecated
    private static String TRY_OPEN_TEMPLATE = "您已开通天校体验，用户名%s，密码%s，%s天有效。App下载%s";
    @Deprecated
    private static String FREE_SMS1 = "您的天校大众版帐号申请已提交，我们很快会和您联系。详询客服" + defaultServerPhone;
    private static int DEFAULT_VISITOR_DAY = 7;// 默认体验账号过期时间

    private static final String DEFAULT_TRY_PWD = "abc123";
    private static final String DEFAULT_FREE_PWD = "a123456";
    private static final String PROD_MANAGER_MOBILE = "15311745604";

    @Autowired
    private TxVisitorDao txVisitorDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountService txAccountService;

    @Autowired(required = false)
    private HagService hagService;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;

    @Override
    public void saveVisitor(TxVisitorRequest request) {
        if (null == request.getApplyType()) {// 兼容旧逻辑
            request.setApplyType(0);
        }

        OrgAccount orgAcc = orgAccountDao.getAccountByMobile(request.getMobile());
        log.info("the visitor mobile is bind with orgAccount =={}", orgAcc);
        if (null != orgAcc) {
            OrgSubAccount subAcc = orgSubAccountDao.getByOrgId(orgAcc.getId());
            log.info("the visitor mobile is bind with OrgSubAccount =={}", subAcc);
            if (null != subAcc && subAcc.getStatus().intValue() == DataStatus.NORMAL.getValue()) {
                TXAccount txAccount =
                        txAccountService.getTXAccountByOrgId(subAcc.getPid() == 0 ? subAcc.getOrgId() : subAcc.getPid());
                if (txAccount != null) {
                    TXAccountType txAccountType = TXAccountType.getTXAccountTypeByCode(txAccount.getVipLevel());
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR,
                            "尊敬的" + (txAccountType == null ? "" : txAccountType.getLabel()) + "用户,请您直接登录天校,无需申请体验");
                }
            }
        }

        log.info("save visitor request =={}", request);
        TxVisitor txVisitor = null;// 账号已存在需要重新开通,只更新就行了
        List<TxVisitor> exist = txVisitorDao.getByMobile(request.getMobile());
        if (CollectionUtils.isNotEmpty(exist) && exist.get(0).getApplyType() == 0 && request.getApplyType() == 0) {// 访问表存在该手机，并且存在类型与请求类型都是体验版
            txVisitor = exist.get(0);
            if (txVisitor.getStartTime() != null) {
                if (txVisitor.getStatus() == TxVisitorStatus.ACTIVE.getCode()
                        && DateUtil.getDateDiff(txVisitor.getStartTime(), new Date()) < DEFAULT_VISITOR_DAY) {
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "您已开通天校体验账号，请直接登录");
                }
            }
        } else if (CollectionUtils.isNotEmpty(exist) && exist.get(0).getApplyType() == 1
                && request.getApplyType() == 0) {// 访问表存在该手机，存在大众版账号申请，请求体验版，不能降级
            log.info("I don't save exist visitor from free to try ! request:{}", request);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "此手机号码已在大众版申请列表中，无法再申请体验版");
        } else if (CollectionUtils.isNotEmpty(exist) && exist.get(0).getApplyType() == 1
                && request.getApplyType() == 1) {// 访问表存在该手机，并且存在类型与请求类型都是大众版
            log.info("I don't save exist visitor for free! request:{}", request);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "此手机号码已在大众版申请列表中，请耐心等候");
        } else if (CollectionUtils.isNotEmpty(exist) && exist.get(0).getApplyType() == 0
                && request.getApplyType() == 1) {// 访问表存在该手机，存在体验版账号申请，请求大众版，可以升级
            log.info("I will upgrade the visitor level! request:{}", request);
            // 进行升级处理 更新tx_visitor status 1->0；applyType 0->1
            txVisitor = this.upgradeFromTryToFreeTXVister(request);
            SmsSendUtil.sendSms(txVisitor.getMobile(), SmsContentHelper.createDaZhongBanKaiTongSmsMsg(),
                    SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, true, null);
            log.info("upgrade the visitor level success =={}", txVisitor);
            return;
        }

        if (txVisitor == null) {
            txVisitor = new TxVisitor();

            if (StringUtils.isEmpty(request.getOrgName()) || request.getOrgName().length() > 32) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "机构名称错误");
            }
            txVisitor.setOrgName(request.getOrgName());

            if (StringUtils.isEmpty(request.getName()) || request.getName().length() > 10) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "联系人姓名错误");
            }
            txVisitor.setName(request.getName());

            if (StringUtils.isEmpty(request.getMobile())) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "手机号错误");
            }
            txVisitor.setMobile(request.getMobile());

            if (request.getProvinceId() == null || request.getCityId() == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "选择城市错误");
            }
            txVisitor.setProvince(request.getProvince());
            txVisitor.setCity(request.getCity());
            txVisitor.setProvinceId(request.getProvinceId());
            txVisitor.setCityId(request.getCityId());

            if (!StringUtils.isEmpty(request.getRemark()) && request.getRemark().length() > 200) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "备注错误");
            }
            txVisitor.setRemark(request.getRemark());

            if (request.getApplyType() == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "申请类型错误");
            }
            txVisitor.setApplyType(request.getApplyType());

            txVisitor.setSource(request.getSource());
            txVisitor.setStatus(DataStatus.NORMAL.getValue());
            txVisitor.setCreateTime(new Date());
            txVisitor.setUpdateTime(new Date());
            txVisitor.setIsdel(DeleteStatus.NORMAL.getValue());
            if (request.getApplyType() == 0) {
                txVisitor.setPassword(PasswordUtil.createHash(DEFAULT_TRY_PWD));
                txVisitor.setStartTime(new Date());
                txVisitor.setRemainDay(DEFAULT_VISITOR_DAY - 1);
                txVisitor.setStatus(TxVisitorStatus.ACTIVE.getCode());
            }
            txVisitorDao.save(txVisitor);
            log.info("save visitor success =={}", txVisitor);
        } else {
            txVisitor.setExtendCount(txVisitor.getExtendCount() + 1);
            txVisitor.setStatus(TxVisitorStatus.ACTIVE.getCode());
            txVisitor.setRemainDay(DEFAULT_VISITOR_DAY - 1);
            txVisitor.setSendMail(0);// 重新发邮件
            txVisitor.setRemark(StringUtils.isEmpty(request.getRemark()) ? txVisitor.getRemark() : request.getRemark());
            txVisitor.setStartTime(new Date());
            txVisitor.setUpdateTime(new Date());
            txVisitorDao.update(txVisitor, "status", "extendCount", "remark", "startTime", "updateTime", "remainDay",
                    "sendMail");
            log.info("update visitor success =={}", txVisitor);
        }

        if (request.getApplyType() == 0) {
            // String url = PropertiesReader.getValue("tianxiao", "message.url");
            // String openMsg = String.format(TRY_OPEN_TEMPLATE, txVisitor.getMobile(), DEFAULT_TRY_PWD,
            // DEFAULT_VISITOR_DAY, ShortUrlUtil.getShortUrl(url), PROD_MANAGER_MOBILE);
            String openMsg = SmsContentHelper.createTryExpTianxiaoTemplateSmsMsg(txVisitor.getMobile(), DEFAULT_TRY_PWD,
                    DEFAULT_VISITOR_DAY);
            SmsSendUtil.sendSms(txVisitor.getMobile(), openMsg, SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null,
                    true, null);
        } else if (request.getApplyType() == 1) {
            SmsSendUtil.sendSms(txVisitor.getMobile(), SmsContentHelper.createDaZhongBanKaiTongSmsMsg(),
                    SmsMessageType.TIANXIAO_NOTIFY.getCode(), null, null, true, null);
        }
        log.info("save visitor success =={}", txVisitor);
    }

    private TxVisitor upgradeFromTryToFreeTXVister(TxVisitorRequest request) {
        TxVisitor txVisitor = new TxVisitor();

        if (StringUtils.isEmpty(request.getOrgName()) || request.getOrgName().length() > 32) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setOrgName(request.getOrgName());//

        if (StringUtils.isEmpty(request.getName()) || request.getName().length() > 10) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setName(request.getName());//

        if (StringUtils.isEmpty(request.getMobile())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setMobile(request.getMobile());/**/

        if (request.getProvinceId() == null || request.getCityId() == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setProvince(request.getProvince());//
        txVisitor.setCity(request.getCity());//
        txVisitor.setProvinceId(request.getProvinceId());//
        txVisitor.setCityId(request.getCityId());//

        if (!StringUtils.isEmpty(request.getRemark()) && request.getRemark().length() > 200) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setRemark(request.getRemark());//

        if (request.getApplyType() == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setApplyType(request.getApplyType());//

        txVisitor.setSource(request.getSource());//
        txVisitor.setStatus(DataStatus.NORMAL.getValue());//
        txVisitor.setCreateTime(new Date());//
        txVisitor.setUpdateTime(new Date());//
        txVisitor.setIsdel(DeleteStatus.NORMAL.getValue());//
        this.txVisitorDao.updateByMobile(txVisitor);
        return txVisitor;
    }

    @Override
    public List<TxVisitor> getListByDate(Date startDate, Date endDate) {

        List<TxVisitor> list = txVisitorDao.listByTime(startDate, endDate);
        log.debug("get visitor startDate={},endDate={}, list =={}", startDate, endDate, list.size());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<TxVisitor> getBeforeAndUpdateMail(Date thisDate) {

        List<TxVisitor> list = txVisitorDao.listBeforeTime(thisDate);
        log.info("get visitor thisDate={} list =={}", thisDate, list.size());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Integer, TxVisitor> visitorMap = CollectorUtil.collectMap(list, new Function<TxVisitor, Integer>() {
            @Override
            public Integer apply(TxVisitor u) {
                return u.getId();
            }
        });
        txVisitorDao.changeSendMail(visitorMap.keySet());

        return list;
    }

    @Override
    public Integer getActiveCount() {
        Integer count = txVisitorDao.getActiveCount();
        return count;
    }

    @Override
    public List<TxVisitor> getByMobile(String mobile) {
        if (StringUtils.isEmpty(mobile)) {
            return null;
        }
        List<TxVisitor> visitors = txVisitorDao.getByMobile(mobile);
        return visitors;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.sal.organization.index.service.TxVisitorService#isOrgAccountValid(java.lang.Integer)
     */

    @Override
    public boolean isOrgAccountValid(Integer orgId) {
        boolean result = false;
        if (orgId != null) {
            OrgAccount orgAccount = orgAccountDao.getAccountById(orgId);
            log.info("oorgAccountrgId:{}", orgAccount);
            if (orgAccount != null) {
                if (hagService.hasPermission(orgAccount.getNumber(), BizConf.DEFAULT_ENTITY_TYPE,
                        HagConf.HAG_RESOURCE_TIANXIAO_TRIAL_ACCOUNT)) {
                    result = true;
                }
            }
        }
        return result;

    }

    @Override
    public void updateVisitor(TxVisitor txVisitor) {
        txVisitorDao.saveOrUpdate(txVisitor);
    }

    @Override
    public void modifyPassword(String mobile, String encryptPwd) {
        txVisitorDao.modifyPassword(mobile, encryptPwd);
    }

    @Override
    public List<TxVisitor> getReleaseAccount(int remainDay) {

        Date endDate = DateUtil.getDiffDateTime(new Date(), (-DEFAULT_VISITOR_DAY + remainDay));
        Date startDate = DateUtil.getDiffHourTime(endDate, -1);// 1小时前

        return txVisitorDao.releaseAccount(DateUtil.getStartOfHour(startDate), DateUtil.getStartOfHour(endDate));
    }

    @Override
    public List<TxVisitorDto> buildVisitorList(List<TxVisitor> list) {
        List<String> mobiles = BaseUtils.getListFilter(list, "mobile");
        List<OrgAccount> orgAccountList = orgAccountDao.getAccountByMobiles(mobiles);
        Map<String, OrgAccount> orgAccountMap = BaseUtils.listToMap(orgAccountList, "mobile");
        Map<Long, TXAccount> txAccountMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orgAccountList)) {
            List<Long> orgIds = BaseUtils.getListFilter(orgAccountList, "id");
            List<OrgSubAccount> subAccounts = orgSubAccountDao.getOrgSubAccountByOrgIds(orgIds, null);
            if (CollectionUtils.isNotEmpty(subAccounts)) {
                List<Long> txOrgIds = Lists.newArrayList();
                for (OrgSubAccount orgSubAccount : subAccounts) {
                    if (orgSubAccount.getPid() != null && orgSubAccount.getPid() > 0) {
                        txOrgIds.add(orgSubAccount.getPid().longValue());
                    } else {
                        txOrgIds.add(orgSubAccount.getId().longValue());
                    }
                }
                if (CollectionUtils.isNotEmpty(txOrgIds)) {
                    txAccountMap = txAccountDao.getAccountTypeMap(txOrgIds);
                }
            }
        }
        List<TxVisitorDto> result = Lists.newArrayList();
        for (TxVisitor txVisitor : list) {
            TxVisitorDto txVisitorDto = TxVisitorDto.buildByPo(txVisitor);
            OrgAccount tempOrgAccount = orgAccountMap.get(txVisitor.getMobile());
            if (tempOrgAccount != null) {
                TXAccount tempTxAccount = txAccountMap.get(tempOrgAccount.getId());
                if (tempTxAccount != null) {
                    TXAccountType txAccountType = TXAccountType.getTXAccountTypeByCode(tempTxAccount.getVipLevel());
                    if (txAccountType != null) {
                        txVisitorDto.setSystemTips(DateUtil.getStrByDate(tempTxAccount.getStartTime()) + "已开通天校" + txAccountType.getLabel());
                    }
                }
            }
            result.add(txVisitorDto);
        }
        return result;
    }
}