/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.todo.service.impl;

import com.baijia.tianxiao.constant.BackLogType;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.OrderBy;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCrontabTaskDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCrontabTaskLog;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.todo.constant.BacklogOperation;
import com.baijia.tianxiao.dal.todo.constant.BacklogStatus;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogOperationLogDao;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogParticipantDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.todo.po.TxBacklogOperationLog;
import com.baijia.tianxiao.dal.todo.po.TxbacklogParticipant;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.todo.constant.GroupType;
import com.baijia.tianxiao.sal.organization.todo.constant.RelatedStudentType;
import com.baijia.tianxiao.sal.organization.todo.constant.RemindType;
import com.baijia.tianxiao.sal.organization.todo.constant.TaskStatus;
import com.baijia.tianxiao.sal.organization.todo.constant.TodoErrorCode;
import com.baijia.tianxiao.sal.organization.todo.constant.param.HomepageParamExpired;
import com.baijia.tianxiao.sal.organization.todo.constant.param.HomepageParamUnexpired;
import com.baijia.tianxiao.sal.organization.todo.dto.BackLogHomePageDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BackLogHomePageListDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BacklogAccountDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BacklogDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BacklogHomepageSearchDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BacklogListResponseDto;
import com.baijia.tianxiao.sal.organization.todo.dto.RelatedStudent;
import com.baijia.tianxiao.sal.organization.todo.dto.SaveBacklogDto;
import com.baijia.tianxiao.sal.organization.todo.service.TxBacklogService;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.push.dto.PushConfig;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.utils.NativeUrlUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TxBacklogServiceImpl
implements TxBacklogService {
    private static final Logger log = LoggerFactory.getLogger(TxBacklogServiceImpl.class);
    private static final String BACKLOG_ACTION = "backlog_info";
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgCrontabTaskDao orgCrontabTaskDao;
    @Autowired
    private TxBacklogParticipantDao txBacklogParticipantDao;
    @Autowired
    private TxBacklogOperationLogDao txBacklogOperationLogDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private ConsultMessageService messageService;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
    private OrgStudentApiService studentApiService;
    @Autowired
    private AccountApiService accountApiService;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long saveOrUpdateBacklog(Long orgId, Long cascadeId, SaveBacklogDto saveBacklogDto) throws CloneNotSupportedException {
        Long userId;
        List participantsInDB;
        List<TxbacklogParticipant> participantsNew;
        Long backlogId = saveBacklogDto.getBacklogId();
        if (backlogId == null || backlogId <= 0L) {
            log.info("addBacklog------saveBacklogDto={}", (Object)saveBacklogDto);
            TxBacklog txBacklog = new TxBacklog();
            this.backlogDto2Po(saveBacklogDto, txBacklog, orgId, cascadeId);
            this.txBacklogDao.save((Object)txBacklog, new String[0]);
            List<TxbacklogParticipant> participants = this.getParticipants(orgId, cascadeId, txBacklog.getId(), saveBacklogDto.getParticipants(), true);
            this.txBacklogParticipantDao.saveAll(participants, false, new String[0]);
            if (txBacklog.getType().intValue() == BackLogType.FOLLOW_UP.getValue()) {
                if (txBacklog.getStudentId() != null && txBacklog.getStudentId() > 0L) {
                    OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)txBacklog.getStudentId(), new String[0]);
                    this.txStudentCommentAPIService.saveByBacklogAdd(student.getUserId(), txBacklog, participants);
                } else if (txBacklog.getConsultUserId() != null && txBacklog.getConsultUserId() > 0L) {
                    this.txStudentCommentAPIService.saveByBacklogAdd(null, txBacklog, participants);
                }
            }
            return txBacklog.getId();
        }
        log.info("updateBacklog------saveBacklogDto={}", (Object)saveBacklogDto);
        TxBacklog txBacklogInDB = this.txBacklogDao.getBacklogByIdAndOrgId(backlogId, orgId, new String[0]);
        TxBacklog txBacklogNew = txBacklogInDB.clone();
        if (null != txBacklogInDB) {
            this.verifyParamAndStatus(txBacklogNew, saveBacklogDto, cascadeId);
            this.syncStudentInfo(txBacklogNew, saveBacklogDto, orgId);
            this.backlogDto2Po(saveBacklogDto, txBacklogNew, orgId, cascadeId);
            this.txBacklogDao.update((Object)txBacklogNew, Boolean.valueOf(true), new String[0]);
            participantsNew = this.getParticipants(orgId, cascadeId, txBacklogNew.getId(), saveBacklogDto.getParticipants(), true);
            participantsInDB = this.txBacklogParticipantDao.listByBackLogId(backlogId, null);
            ArrayList<TxbacklogParticipant> participantsAdd = new ArrayList<TxbacklogParticipant>();
            ArrayList<Long> participantIdsDel = new ArrayList<Long>();
            boolean find = false;
            for (TxbacklogParticipant objNew : participantsNew) {
                find = false;
                for (TxbacklogParticipant objOld : participantsInDB) {
                    if (objNew.getCascadeId().longValue() != objOld.getCascadeId().longValue()) continue;
                    find = true;
                }
                if (find) continue;
                participantsAdd.add(objNew);
            }
            for (TxbacklogParticipant objOld : participantsInDB) {
                find = false;
                for (TxbacklogParticipant objNew : participantsNew) {
                    if (objNew.getCascadeId().longValue() != objOld.getCascadeId().longValue()) continue;
                    find = true;
                }
                if (find) continue;
                participantIdsDel.add(objOld.getId());
            }
            if (CollectionUtils.isNotEmpty(participantIdsDel)) {
                this.txBacklogParticipantDao.physicallyDelByIds(participantIdsDel);
            }
            if (CollectionUtils.isNotEmpty(participantsAdd)) {
                this.txBacklogParticipantDao.saveAll(participantsAdd, false, new String[0]);
            }
            userId = null;
            if (txBacklogNew.getStudentId() != null && txBacklogNew.getStudentId() > 0L) {
                OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)txBacklogNew.getStudentId(), new String[0]);
                userId = student.getUserId();
            }
        } else {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
        }
        this.txStudentCommentAPIService.saveByBacklogUpdate(userId, txBacklogInDB, txBacklogNew, participantsInDB, participantsNew);
        return txBacklogNew.getId();
    }

    List<TxbacklogParticipant> getParticipants(Long orgId, Long cascadeId, Long txBacklogId, String participantsStr, boolean addDefault) {
        HashSet<Long> participantCascadeIds = new HashSet<Long>();
        if (addDefault) {
            participantCascadeIds.add(cascadeId);
        }
        if (StringUtils.isNotBlank((CharSequence)participantsStr)) {
            for (String obj : participantsStr.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)obj)) continue;
                participantCascadeIds.add(Long.parseLong(obj));
            }
        }
        ArrayList<TxbacklogParticipant> participants = new ArrayList<TxbacklogParticipant>();
        TxbacklogParticipant txbacklogParticipan = null;
        for (Long participantCascadeId : participantCascadeIds) {
            txbacklogParticipan = new TxbacklogParticipant(txBacklogId, orgId, participantCascadeId);
            participants.add(txbacklogParticipan);
        }
        return participants;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void delBacklog(Long orgId, Long cascadeId, Long backlogId) {
        Date now = new Date();
        TxBacklog txBacklog = (TxBacklog)this.txBacklogDao.getById((Serializable)backlogId, new String[0]);
        List participants = this.txBacklogParticipantDao.listByBackLogId(backlogId);
        log.info("delBacklog---------backlogId={},orgId={},txBacklog={}", new Object[]{backlogId, orgId, txBacklog});
        if (null == txBacklog || DeleteStatus.NORMAL.getValue() != txBacklog.getDelStatus()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
        if (null == txBacklog.getOrgId() || txBacklog.getOrgId().longValue() != orgId.longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_IN_ORG);
        this.txBacklogParticipantDao.delBy(orgId, cascadeId, backlogId);
        boolean realDel = false;
        boolean addComment = false;
        if (txBacklog.getEndTime().getTime() > now.getTime() && txBacklog.getCascadeId().intValue() == cascadeId.intValue()) {
            realDel = true;
            addComment = true;
        }
        if (participants.size() == 1 && ((TxbacklogParticipant)participants.get(0)).getCascadeId().intValue() == cascadeId.intValue()) {
            realDel = true;
        }
        if (realDel) {
            txBacklog.setDelStatus(DeleteStatus.DELETED.getValue());
            txBacklog.setUpdateTime(now);
            this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[]{"delStatus", "updateTime"});
        }
        if (!addComment || txBacklog.getType().intValue() != BackLogType.FOLLOW_UP.getValue()) return;
        if (txBacklog.getStudentId() != null && txBacklog.getStudentId() > 0L) {
            OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)txBacklog.getStudentId(), new String[0]);
            this.txStudentCommentAPIService.saveByBacklogDel(student.getUserId(), txBacklog, participants);
            return;
        } else {
            if (txBacklog.getConsultUserId() == null || txBacklog.getConsultUserId() <= 0L) return;
            this.txStudentCommentAPIService.saveByBacklogDel(null, txBacklog, participants);
        }
    }

    @Override
    @DataAuthority(resourceTypes={RequestSourceDesc.BACK_LOG_LIST})
    public BacklogListResponseDto getBacklogList(Long orgId, Long cascadeId, int groupType, PageDto page) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Preconditions.checkArgument((groupType >= 0 && groupType <= 3 ? 1 : 0) != 0, (Object)"groupType is illegal");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.ORG_NOT_EXIST);
        }
        BacklogListResponseDto responseDto = new BacklogListResponseDto();
        ArrayList backlogListDto = Lists.newArrayList();
        List list = Lists.newArrayList();
        responseDto.setGroupType(groupType);
        responseDto.setList(backlogListDto);
        boolean canAccess = RequestSourceDesc.BACK_LOG_LIST.canAccess("getBacklogList", this.getClass(), Long.class, Integer.TYPE, PageDto.class);
        if (canAccess) {
            cascadeId = null;
        }
        list = this.txBacklogDao.getBacklogListByGroup(orgId, cascadeId == null ? null : Integer.valueOf(cascadeId.intValue()), Integer.valueOf(groupType), page, new String[0]);
        log.info("getBacklogList-------orgId={},groupType={},page={},list={}", new Object[]{orgId, GroupType.getNoteWithValue(groupType), page, list});
        ArrayList<Long> consultUserIds = new ArrayList<Long>();
        ArrayList<Long> studentIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (TxBacklog po : list) {
                BacklogDto dto = new BacklogDto();
                this.backlogPo2Dto(po, dto);
                if (po.getStudentId() != null && po.getStudentId() > 0L) {
                    studentIds.add(po.getStudentId());
                } else {
                    consultUserIds.add(po.getConsultUserId());
                }
                backlogListDto.add(dto);
            }
            Map<Long, RelatedStudent> studentMap = this.buildStudents(studentIds, orgId);
            Map<Long, RelatedStudent> consultUserMap = this.buildConsultUsers(consultUserIds, orgId);
            for (BacklogDto dto : backlogListDto) {
                RelatedStudent relatedStudent = null;
                if (dto.getRelatedStudent() == null) {
                    log.warn("RelatedStudent is null!");
                    continue;
                }
                relatedStudent = dto.getRelatedStudent().getType() == RelatedStudentType.STUDENT.getValue() ? studentMap.get(dto.getRelatedStudent().getStudentId()) : consultUserMap.get(dto.getRelatedStudent().getStudentId());
                if (relatedStudent != null) {
                    dto.setRelatedStudent(relatedStudent);
                    continue;
                }
                log.warn("[Backlog] student is not exist.{}", (Object)dto.getRelatedStudent());
            }
        }
        return responseDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void setBacklogStatus(Long orgId, Long cascadeId, Long backlogId, int finish) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Preconditions.checkArgument((backlogId != null && backlogId > 0L ? 1 : 0) != 0, (Object)"backlogId is illegal");
        TxBacklog txBacklog = this.txBacklogDao.getBacklogByIdAndOrgId(backlogId, orgId, new String[0]);
        log.info("setBacklogStatus------txBacklog={}", (Object)txBacklog);
        if (null != txBacklog) {
            TxbacklogParticipant participant = this.txBacklogParticipantDao.getBy(orgId, cascadeId, txBacklog.getId());
            List participants = this.txBacklogParticipantDao.listByBackLogId(txBacklog.getId());
            if (participants.size() <= 1 && cascadeId.longValue() == txBacklog.getCascadeId().longValue()) {
                txBacklog.setFinish(Integer.valueOf(finish));
                this.txBacklogDao.update((Object)txBacklog, new String[0]);
            }
            if (participant != null && finish != participant.getFinish()) {
                participant.setFinish(Integer.valueOf(finish));
                participant.setUpdateTime(new Date());
                this.txBacklogParticipantDao.update((Object)participant, new String[0]);
                TxBacklogOperationLog operationLog = TxBacklogOperationLog.buildByFinish((Long)backlogId, (Long)orgId, (Long)cascadeId, (int)finish);
                this.txBacklogOperationLogDao.save((Object)operationLog, new String[0]);
            }
        } else {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
        }
    }

    private void backlogPo2Dto(TxBacklog po, BacklogDto dto) {
        dto.setIsSys(po.getIsSys());
        dto.setBacklogId(po.getId());
        dto.setContent(StringUtils.isNotBlank((CharSequence)po.getContent()) ? po.getContent() : "");
        dto.setFinish(po.getFinish());
        dto.setFinishString(TaskStatus.getNoteByValue(po.getFinish()));
        dto.setRelatedStudent(this.buildStudent(po.getConsultUserId(), po.getStudentId()));
        dto.setBacklogType(po.getType());
        if (null != po.getEndTime()) {
            dto.setEndTime(po.getEndTime().getTime());
            if (null != po.getRemindTime()) {
                dto.setRemindType(RemindType.getByDiff(po.getRemindTime().getTime() - po.getEndTime().getTime()).getValue());
            } else {
                dto.setRemindType(RemindType.NO_REMIND.getValue());
            }
        } else {
            dto.setEndTime(System.currentTimeMillis());
            dto.setRemindType(RemindType.NO_REMIND.getValue());
        }
    }

    private RelatedStudent buildStudent(Long consultUserId, Long studentId) {
        RelatedStudent relatedStudent = null;
        if (null != studentId && studentId > 0L) {
            relatedStudent = new RelatedStudent();
            relatedStudent.setType(RelatedStudentType.STUDENT.getValue());
            relatedStudent.setStudentId(studentId);
        } else if (null != consultUserId && consultUserId > 0L) {
            relatedStudent = new RelatedStudent();
            relatedStudent.setType(0);
            relatedStudent.setStudentId(consultUserId);
        }
        log.info("buildStudent------relatedStudent={}", relatedStudent);
        return relatedStudent;
    }

    private Map<Long, RelatedStudent> buildStudents(Collection<Long> studentIds, Long orgId) {
        HashMap<Long, RelatedStudent> retMap = new HashMap<Long, RelatedStudent>();
        if (null != studentIds && studentIds.size() > 0) {
            List students = this.orgStudentDao.getStudentByIds(orgId, studentIds, new String[0]);
            Map map = CollectionHelper.toIdMap((Collection)students);
            Map avatarMap = this.studentApiService.batchGetStudentAvatarUrl((Collection)students);
            Set keySet = map.keySet();
            for (Long id : keySet) {
                String avatar = (String)avatarMap.get(id);
                map.get(id);
                RelatedStudent relatedStudent = new RelatedStudent();
                relatedStudent.setType(RelatedStudentType.STUDENT.getValue());
                relatedStudent.setStudentId(id);
                relatedStudent.setName(((OrgStudent)map.get(id)).getName());
                relatedStudent.setAvatar(avatar);
                retMap.put(((OrgStudent)map.get(id)).getId(), relatedStudent);
            }
        }
        return retMap;
    }

    private Map<Long, RelatedStudent> buildConsultUsers(Collection<Long> consultUserIds, Long orgId) {
        List consultUsers;
        HashMap<Long, RelatedStudent> retMap = new HashMap<Long, RelatedStudent>();
        if (null != consultUserIds && consultUserIds.size() > 0 && null != (consultUsers = this.txConsultUserDao.batchTxConsultUserByIds(consultUserIds, null, null))) {
            this.consulterAPIService.batchSetConsultAvatarUrl((Collection)consultUsers);
            for (TxConsultUser user : consultUsers) {
                RelatedStudent relatedStudent = new RelatedStudent();
                relatedStudent.setType(0);
                relatedStudent.setStudentId(user.getId());
                relatedStudent.setName(user.getName());
                relatedStudent.setAvatar(user.getPortrait());
                retMap.put(user.getId(), relatedStudent);
            }
        }
        return retMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void backlogDto2Po(SaveBacklogDto dto, TxBacklog po, Long orgId, Long cascadeId) {
        Date now = new Date();
        po.setStudentId(Long.valueOf(0L));
        po.setConsultUserId(Long.valueOf(0L));
        po.setOrgId(orgId);
        po.setContent(StringUtils.isNotEmpty((CharSequence)dto.getContent()) ? dto.getContent() : "");
        po.setEndTime(new Date(dto.getEndTime()));
        po.setCreateTime(null == po.getCreateTime() ? now : po.getCreateTime());
        po.setUpdateTime(now);
        if (dto.getBacklogType() == null) {
            if (po.getType() == null) {
                po.setType(Integer.valueOf(BackLogType.NORMAL.getValue()));
            }
        } else {
            po.setType(dto.getBacklogType());
        }
        if (po.getCascadeId() == null) {
            if (dto.getCreatorCascadeId() != null) {
                po.setCascadeId(Integer.valueOf(dto.getCreatorCascadeId().intValue()));
            } else {
                po.setCascadeId(Integer.valueOf(cascadeId.intValue()));
            }
        }
        if (dto.getRemindType() >= RemindType.ON_TIME.getValue() && dto.getRemindType() <= RemindType.TWO_DAY_AHEAD.getValue()) {
            po.setRemindTime(new Date(dto.getEndTime() - RemindType.getDiffByValue(dto.getRemindType())));
        } else {
            po.setRemindTime(null);
        }
        if (null == dto.getType() || null == dto.getStudentId()) return;
        if (RelatedStudentType.CONSULT.getValue() == dto.getType().intValue()) {
            Long consultUserId = dto.getStudentId();
            TxConsultUser consultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)consultUserId, new String[]{"id", "orgId", "delStatus", "studentId"});
            if (null == consultUser || DeleteStatus.NORMAL.getValue() != consultUser.getDelStatus().intValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_EXIST);
            if (orgId.longValue() != consultUser.getOrgId().longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_IN_ORG);
            po.setConsultUserId(consultUserId);
            return;
        } else {
            if (RelatedStudentType.STUDENT.getValue() != dto.getType().intValue()) return;
            Long studentId = dto.getStudentId();
            OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[]{"org_id", "delStatus"});
            if (null == student || DeleteStatus.NORMAL.getValue() != student.getDelStatus().intValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_EXIST);
            if (orgId.longValue() != student.getOrgId().longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_IN_ORG);
            po.setStudentId(studentId);
            List list = this.txConsultUserDao.lookByStudentId(orgId, studentId, new String[]{"id", "studentId"});
            if (!CollectionUtils.isNotEmpty((Collection)list)) return;
            po.setConsultUserId(((TxConsultUser)list.get(0)).getId());
        }
    }

    private void verifyParamAndStatus(TxBacklog txBacklog, SaveBacklogDto saveBacklogDto, Long cascadeId) {
        Date now = new Date();
        if (txBacklog.getStatus() == BacklogStatus.EXPIRED.getValue()) {
            throw new PermissionException("\u5f85\u529e\u4e8b\u9879\u5df2\u8fc7\u671f\uff0c\u7981\u6b62\u4fee\u6539\u3002");
        }
        if (txBacklog.getCascadeId().intValue() != cascadeId.intValue()) {
            throw new PermissionException("\u4ec5\u521b\u5efa\u4eba\u53ef\u4ee5\u4fee\u6539\u5f85\u529e\u4e8b\u9879\u3002");
        }
        if (txBacklog.getEndTime().before(DateUtil.getCurrentDate())) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.CAN_NOT_EDIT_EXPIRED_BACKLOG);
        }
        if (BizConf.TRUE.intValue() == txBacklog.getFinish().intValue()) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.CAN_NOT_EDIT_FINISH_BACKLOG);
        }
        if (BizConf.TRUE.intValue() == txBacklog.getIsSys() && saveBacklogDto.getType() != null && saveBacklogDto.getStudentId() != null && (0 == saveBacklogDto.getType() ? null != txBacklog.getConsultUserId() && txBacklog.getConsultUserId().longValue() != saveBacklogDto.getStudentId().longValue() : null != txBacklog.getStudentId() && txBacklog.getStudentId().longValue() != saveBacklogDto.getStudentId().longValue())) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.CAN_NOT_EDIT_SYSTEM_BACKLOG_WITH_STUDENT);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void syncStudentInfo(TxBacklog txBacklog, SaveBacklogDto saveBacklogDto, Long orgId) {
        if (BizConf.TRUE.intValue() != txBacklog.getIsSys() || saveBacklogDto.getEndTime().longValue() == txBacklog.getEndTime().getTime() || saveBacklogDto.getType() == null) return;
        if (RelatedStudentType.CONSULT.getValue() == saveBacklogDto.getType().intValue()) {
            if (saveBacklogDto.getStudentId().longValue() != txBacklog.getConsultUserId().longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
            TxConsultUser consulterUser = this.consultUserDao.getOrgConsultUser(orgId, txBacklog.getConsultUserId());
            if (null == consulterUser) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_EXIST);
            consulterUser.setNextRemindTime(new Date(saveBacklogDto.getEndTime()));
            consulterUser.setUpdateTime(new Date());
            this.txConsultUserDao.update((Object)consulterUser, new String[]{"nextRemindTime", "updateTime"});
            return;
        } else {
            if (RelatedStudentType.STUDENT.getValue() != saveBacklogDto.getType().intValue()) return;
            if (saveBacklogDto.getStudentId().longValue() != txBacklog.getStudentId().longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
            OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)txBacklog.getStudentId(), new String[0]);
            if (null == orgStudent || orgStudent.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_EXIST);
            orgStudent.setNextRemindTime(new Date(saveBacklogDto.getEndTime()));
            orgStudent.setUpdateTime(new Date());
            this.orgStudentDao.update((Object)orgStudent, new String[]{"nextRemindTime", "updateTime"});
        }
    }

    @Override
    public void remind(Date startTime, Date endTime, OrgCrontabTaskLog taskLog, boolean isNew) {
        List result = this.txBacklogDao.getBacklogListByRemindTime(startTime, endTime);
        if (result != null && !result.isEmpty()) {
            this.prepared(result, taskLog, isNew);
        } else {
            taskLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            if (isNew) {
                this.orgCrontabTaskDao.save((Object)taskLog, new String[0]);
            } else {
                this.orgCrontabTaskDao.update((Object)taskLog, new String[]{"executeTime", "updateTime"});
            }
        }
    }

    private void prepared(List<TxBacklog> result, OrgCrontabTaskLog taskLog, boolean isNew) {
        for (TxBacklog backlog : result) {
            List participants = this.txBacklogParticipantDao.listByBackLogId(backlog.getId(), null);
            if (CollectionUtils.isNotEmpty((Collection)participants)) {
                for (TxbacklogParticipant obj : participants) {
                    if (Flag.getBoolean((Integer)obj.getDelStatus()) || Flag.getBoolean((Integer)obj.getFinish())) continue;
                    this.pushBacklog(backlog.getId(), backlog.getContent(), obj.getOrgId(), obj.getCascadeId());
                }
                continue;
            }
            this.pushBacklog(backlog.getId(), backlog.getContent(), backlog.getOrgId(), backlog.getCascadeId().longValue());
        }
        taskLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        taskLog.setValue(result.get(result.size() - 1).getId().longValue());
        if (isNew) {
            this.orgCrontabTaskDao.save((Object)taskLog, new String[0]);
        } else {
            this.orgCrontabTaskDao.update((Object)taskLog, new String[]{"executeTime", "updateTime", "value"});
        }
    }

    private void pushBacklog(Long backlogId, String backlogContent, Long orgId, Long cascadeId) {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("bid", backlogId);
        log.info("[Notice] Todo notice");
        try {
            String content = NoticeType.TO_DO.getContent() + ":" + backlogContent;
            this.messageService.sendNotice(orgId, Integer.valueOf(cascadeId.intValue()), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.TO_DO, (String)ActionUtil.getAction((String)BACKLOG_ACTION, param), (String)content));
        }
        catch (Exception e) {
            log.error("[Notice] exception ", (Throwable)e);
        }
    }

    private PushConfig getPushConfig(TxBacklog backlog) {
        PushConfig config = new PushConfig();
        config.setTip("\u60a8\u6709\u4e00\u4e2a\u5f85\u529e\u4e8b\u9879\u9700\u8981\u5904\u7406");
        String url = NativeUrlUtil.getUrl((String)BACKLOG_ACTION);
        url = NativeUrlUtil.addParam((String)url, (String)"bid", (Object)backlog.getId());
        config.setJumpUrl(url);
        return config;
    }

    @Override
    public BacklogDto getBacklogDetail(Long orgId, Long cascadeId, Long bid) throws BussinessException {
        TxBacklog backlog = (TxBacklog)this.txBacklogDao.getById((Serializable)bid, new String[0]);
        TxbacklogParticipant participant = this.txBacklogParticipantDao.getBy(orgId, cascadeId, bid);
        BacklogDto dto = null;
        if (backlog != null && backlog.getOrgId().longValue() == orgId.longValue()) {
            if (participant == null) {
                throw new PermissionException("\u65e0\u6743\u8bbf\u95ee\uff0c\u60a8\u4e0d\u5728\u8be5\u5f85\u529e\u7684\u53c2\u4e0e\u4eba\u5217\u8868\u4e2d\u3002");
            }
            dto = new BacklogDto();
            this.backlogPo2Dto(backlog, dto);
            RelatedStudent relatedStudent = null;
            if (dto.getRelatedStudent() != null) {
                if (dto.getRelatedStudent().getType() == RelatedStudentType.STUDENT.getValue()) {
                    Map<Long, RelatedStudent> studentMap = this.buildStudents(Arrays.asList(dto.getRelatedStudent().getStudentId()), orgId);
                    relatedStudent = studentMap.get(dto.getRelatedStudent().getStudentId());
                } else {
                    Map<Long, RelatedStudent> consultUserMap = this.buildConsultUsers(Arrays.asList(dto.getRelatedStudent().getStudentId()), orgId);
                    relatedStudent = consultUserMap.get(dto.getRelatedStudent().getStudentId());
                }
                dto.setRelatedStudent(relatedStudent);
            }
            String creatorName = this.accountApiService.getAccountName(backlog.getOrgId(), Long.valueOf(backlog.getCascadeId().longValue()));
            BacklogAccountDto creator = new BacklogAccountDto(creatorName, backlog.getCascadeId().longValue());
            dto.setCreator(creator);
            if (creator.getCascadeId().longValue() == cascadeId.longValue()) {
                dto.setIsCreator(Flag.TRUE.getInt());
            }
            List participants = this.txBacklogParticipantDao.listByBackLogId(backlog.getId(), null);
            ArrayList<BacklogAccountDto> participantDtos = new ArrayList<BacklogAccountDto>();
            BacklogAccountDto participantDto = null;
            String participantName = null;
            for (TxbacklogParticipant obj : participants) {
                participantName = this.accountApiService.getAccountName(obj.getOrgId(), Long.valueOf(obj.getCascadeId()));
                participantDto = new BacklogAccountDto(participantName, (long)obj.getCascadeId());
                participantDtos.add(participantDto);
            }
            dto.setParticipants(participantDtos);
            List operationLogs = this.txBacklogOperationLogDao.listByBackLogId(backlog.getId());
            ArrayList<String> operationStrList = new ArrayList<String>();
            dto.setOperations(operationStrList);
            if (CollectionUtils.isNotEmpty((Collection)operationLogs)) {
                String fmt = "%s \u4e8e%s\u5c06\u4e8b\u9879\u6807\u8bb0\u4e3a [%s]";
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                String accountName = null;
                BacklogOperation opeationEnum = null;
                for (TxBacklogOperationLog operationLog : operationLogs) {
                    accountName = this.accountApiService.getAccountName(operationLog.getOrgId(), operationLog.getCascadeId());
                    opeationEnum = BacklogOperation.getByValue((int)operationLog.getOperation());
                    if (BacklogOperation.UPDATE_TO_FINISH == opeationEnum) {
                        operationStrList.add(String.format(fmt, accountName, sdf.format(operationLog.getCreateTime()), "\u5b8c\u6210"));
                        continue;
                    }
                    if (BacklogOperation.UPDATE_TO_UNFINISH != opeationEnum) continue;
                    operationStrList.add(String.format(fmt, accountName, sdf.format(operationLog.getCreateTime()), "\u672a\u5b8c\u6210"));
                }
            }
        } else {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
        }
        dto.setFinish(participant.getFinish());
        return dto;
    }

    @Override
    public void batchFinishExpired(Long orgId, Long cascadeId) {
        List participants;
        Date expiredTime = DateUtil.getCurrentDate();
        List backlogIds = this.txBacklogDao.listExpiredBacklogId(orgId, expiredTime);
        if (CollectionUtils.isNotEmpty((Collection)backlogIds) && CollectionUtils.isNotEmpty((Collection)(participants = this.txBacklogParticipantDao.listBy(orgId, cascadeId, backlogIds, Boolean.valueOf(false))))) {
            Flag finishFlag = Flag.TRUE;
            ArrayList<Long> participantIds = new ArrayList<Long>();
            ArrayList<TxBacklogOperationLog> operationLogs = new ArrayList<TxBacklogOperationLog>();
            for (TxbacklogParticipant participant : participants) {
                participantIds.add(participant.getId());
                operationLogs.add(TxBacklogOperationLog.buildByFinish((Long)participant.getBacklogId(), (Long)orgId, (Long)cascadeId, (int)finishFlag.getInt()));
            }
            this.txBacklogParticipantDao.batchChangeFinish(participantIds, finishFlag.getBoolean());
            this.txBacklogOperationLogDao.saveAll(operationLogs, false, new String[0]);
        }
    }

    @Override
    public void batchDelExpired(Long orgId, Long cascadeId) {
        Date expiredTime = DateUtil.getCurrentDate();
        List backlogIds = this.txBacklogDao.listExpiredBacklogId(orgId, expiredTime);
        if (CollectionUtils.isNotEmpty((Collection)backlogIds)) {
            this.txBacklogParticipantDao.delBy(orgId, cascadeId, backlogIds);
        }
    }

    @Override
    public BackLogHomePageDto getBackLogHomePageDto(Long orgId, Long cascadeId, HomepageParamUnexpired unexpired, HomepageParamExpired expired, Integer expiredListPageNum, Integer expiredListPageSize, Integer searchFinish, Integer searchStatus) {
        BackLogHomePageDto result = new BackLogHomePageDto();
        ArrayList<BackLogHomePageListDto> unexpiredList = new ArrayList<BackLogHomePageListDto>();
        ArrayList<BackLogHomePageListDto> expiredList = new ArrayList<BackLogHomePageListDto>();
        result.setUnexpired(unexpiredList);
        result.setExpired(expiredList);
        List participants = this.txBacklogParticipantDao.listBy(orgId, cascadeId);
        if (CollectionUtils.isNotEmpty((Collection)participants)) {
            HashMap<Long, TxbacklogParticipant> keyBacklogIdValueParticipantMap = new HashMap<Long, TxbacklogParticipant>();
            ArrayList<Long> backlogIdsAll = new ArrayList<Long>();
            ArrayList<Long> backlogIdsFinish = new ArrayList<Long>();
            ArrayList<Long> backlogIdsUnFinish = new ArrayList<Long>();
            Long backlogId = null;
            for (TxbacklogParticipant obj : participants) {
                backlogId = obj.getBacklogId();
                if (obj.getFinish().intValue() == Flag.TRUE.getInt()) {
                    backlogIdsFinish.add(backlogId);
                } else {
                    backlogIdsUnFinish.add(backlogId);
                }
                backlogIdsAll.add(backlogId);
                keyBacklogIdValueParticipantMap.put(backlogId, obj);
            }
            Date today = DateUtil.getCurrentDate();
            Date tomorrow = DateUtil.getDiffDateTime((Date)today, (int)1);
            List unExpiredTxBacklogs = null;
            List expiredTxBacklogs = null;
            List backlogIds = null;
            BacklogHomepageSearchDto searchParams = new BacklogHomepageSearchDto();
            switch (unexpired) {
                case NULL: {
                    break;
                }
                case TODAY: {
                    searchParams.setEndTimeRange(today, tomorrow);
                    break;
                }
                case TODAY_AND_FUTURE: {
                    searchParams.setEndTimeRange(today, null);
                }
            }
            searchParams.resetBySearch(searchStatus, searchFinish);
            backlogIds = (List)searchParams.chooseListByFinish(backlogIdsAll, backlogIdsFinish, backlogIdsUnFinish);
            unExpiredTxBacklogs = this.txBacklogDao.list(backlogIds, null, null, searchParams.getMinEndTime(), searchParams.getMaxEndTime(), OrderBy.ASC);
            searchParams = new BacklogHomepageSearchDto();
            switch (expired) {
                case NULL: {
                    break;
                }
                case UNFINISH_AND_EXPIRED: {
                    searchParams.setFinish(Flag.FALSE.getInt());
                    searchParams.setEndTimeRange(null, today);
                    break;
                }
                case ALL_EXPIRED: {
                    searchParams.setEndTimeRange(null, today);
                }
            }
            searchParams.resetBySearch(searchStatus, searchFinish);
            backlogIds = (List)searchParams.chooseListByFinish(backlogIdsAll, backlogIdsFinish, backlogIdsUnFinish);
            expiredTxBacklogs = this.txBacklogDao.list(backlogIds, expiredListPageNum, expiredListPageSize, searchParams.getMinEndTime(), searchParams.getMaxEndTime(), OrderBy.DESC);
            HashMap<Long, String> studentNameMap = new HashMap();
            Map<Long, String> consultUserNameMap = new HashMap<Long, String>();
            if (CollectionUtils.isNotEmpty((Collection)unExpiredTxBacklogs)) {
                for (TxBacklog obj : unExpiredTxBacklogs) {
                    if (obj.getStudentId() != null && obj.getStudentId() > 0L) {
                        studentNameMap.put(obj.getStudentId(), null);
                        continue;
                    }
                    if (obj.getConsultUserId() == null || obj.getConsultUserId() <= 0L) continue;
                    consultUserNameMap.put(obj.getConsultUserId(), null);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)expiredTxBacklogs)) {
                for (TxBacklog obj : expiredTxBacklogs) {
                    if (obj.getStudentId() != null && obj.getStudentId() > 0L) {
                        studentNameMap.put(obj.getStudentId(), null);
                        continue;
                    }
                    if (obj.getConsultUserId() == null || obj.getConsultUserId() <= 0L) continue;
                    consultUserNameMap.put(obj.getConsultUserId(), null);
                }
            }
            if (studentNameMap.size() > 0) {
                studentNameMap = this.orgStudentDao.mapIdVsName(studentNameMap.keySet());
            }
            if (consultUserNameMap.size() > 0) {
                consultUserNameMap = this.txConsultUserDao.mapIdVsName(consultUserNameMap.keySet());
            }
            this.fillBackLogHomePageListDto(unexpiredList, unExpiredTxBacklogs, studentNameMap, consultUserNameMap, keyBacklogIdValueParticipantMap);
            this.fillBackLogHomePageListDto(expiredList, expiredTxBacklogs, studentNameMap, consultUserNameMap, keyBacklogIdValueParticipantMap);
            if (CollectionUtils.isNotEmpty((Collection)expiredTxBacklogs)) {
                result.setExpiredListPageNum(expiredListPageNum);
            }
        }
        return result;
    }

    void fillBackLogHomePageListDto(List<BackLogHomePageListDto> resultData, List<TxBacklog> sourceData, Map<Long, String> studentNameMap, Map<Long, String> consultUserNameMap, Map<Long, TxbacklogParticipant> keyBacklogIdValueParticipantMap) {
        BackLogHomePageListDto listDto = null;
        Long studentId = null;
        Long consultUserId = null;
        TxbacklogParticipant participant = null;
        if (CollectionUtils.isNotEmpty(sourceData)) {
            for (TxBacklog obj : sourceData) {
                listDto = new BackLogHomePageListDto();
                listDto.setBacklogId(obj.getId());
                listDto.setBacklogType(obj.getType());
                listDto.setContent(obj.getContent());
                listDto.setEndTime(obj.getEndTime().getTime());
                participant = keyBacklogIdValueParticipantMap.get(obj.getId());
                if (participant == null) {
                    log.error("participant is null TxBacklog:{}", (Object)obj);
                    continue;
                }
                listDto.setFinish(participant.getFinish());
                studentId = obj.getStudentId();
                consultUserId = obj.getConsultUserId();
                if (studentId != null && studentId > 0L) {
                    listDto.setRelatedStudent(new RelatedStudent(RelatedStudentType.STUDENT.getValue(), studentId, MapUtils.getString(studentNameMap, (Object)studentId, (String)"\u67e5\u8be2\u5931\u8d25")));
                } else if (consultUserId != null && consultUserId > 0L) {
                    listDto.setRelatedStudent(new RelatedStudent(RelatedStudentType.CONSULT.getValue(), consultUserId, MapUtils.getString(consultUserNameMap, (Object)consultUserId, (String)"\u67e5\u8be2\u5931\u8d25")));
                }
                resultData.add(listDto);
            }
        }
    }
}

