/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgTemplateCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgTemplateCourse;
import com.baijia.tianxiao.sal.organization.org.dto.TemplateCourseDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgTemplateCourseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgTemplateCourseServiceImpl
implements OrgTemplateCourseService {
    private static final Logger log = LoggerFactory.getLogger(OrgTemplateCourseServiceImpl.class);
    @Resource
    private OrgTemplateCourseDao orgTemplateCourseDao;

    @Override
    public void batchEdit(int orgId, int templateId, Map<Integer, List<TemplateCourseDto>> templateCourseDtoMap) {
        log.debug("orgid={},templateId={},templateCourse={}", new Object[]{orgId, templateId, templateCourseDtoMap});
        ArrayList<Integer> modules = new ArrayList<Integer>(templateCourseDtoMap.keySet());
        if (!modules.isEmpty()) {
            this.orgTemplateCourseDao.delByModule(orgId, templateId, modules);
            log.debug("delete old module course success..");
            ArrayList result = Lists.newArrayList();
            Date now = new Date();
            for (Integer module : modules) {
                List<TemplateCourseDto> templateCourseDtos = templateCourseDtoMap.get(module);
                for (int i = 0; i < templateCourseDtos.size(); ++i) {
                    TemplateCourseDto dto = templateCourseDtos.get(i);
                    OrgTemplateCourse one = new OrgTemplateCourse();
                    one.setOrgId(Integer.valueOf(orgId));
                    one.setTemplateId(Integer.valueOf(templateId));
                    one.setCourseId(dto.getCourseId());
                    one.setCourseType(dto.getCourseType());
                    one.setDisplayOrder(Integer.valueOf(i));
                    one.setCreateTime(now);
                    one.setUpdateTime(now);
                    one.setModuleType(module);
                    one.setIsDel(Integer.valueOf(DataStatus.NORMAL.getValue()));
                    result.add(one);
                }
            }
            this.orgTemplateCourseDao.saveAll((List)result, new String[0]);
            log.debug("save new module couse success..");
        }
    }

    @Override
    public List<OrgTemplateCourse> getByOrgIdTemplate(int orgId, Integer templateId, int module) {
        List list;
        if (templateId == null) {
            log.error("templateId is  null");
        }
        if ((list = this.orgTemplateCourseDao.getByModule(orgId, templateId.intValue(), module)) == null || list.isEmpty()) {
            list = Lists.newArrayList();
        }
        return list;
    }
}

