/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.token;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.validation.ValidateTokenUtil;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncAccountVersion {
    private static final Logger log = LoggerFactory.getLogger(SyncAccountVersion.class);
    private static final int BATCH = 1000;
    private InnerSync innerSync;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @PostConstruct
    public void postConstruct() {
        this.innerSync = new InnerSync();
        this.innerSync.setDaemon(true);
        this.innerSync.start();
    }

    @PreDestroy
    public void preDestroy() {
        this.innerSync.interrupt();
    }

    class InnerSync
    extends Thread {
        InnerSync() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    HashMap accountVersionMap = Maps.newHashMap();
                    this.fillOrgSubAccount(accountVersionMap);
                    this.fillTXCascadeAccount(accountVersionMap);
                    ValidateTokenUtil.accountVersionMap = accountVersionMap;
                }
            }
            catch (Throwable t) {
                log.warn("InnerSync error!", t);
                return;
            }
        }

        private void fillOrgSubAccount(Map<String, Integer> accountVersionMap) {
            log.info("InnerSync start orgSubAccounts ...");
            List orgSubAccounts = null;
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(Integer.valueOf(1000));
            pageDto.setPageNum(Integer.valueOf(1));
            int total = 0;
            do {
                if (CollectionUtils.isNotEmpty((Collection)(orgSubAccounts = SyncAccountVersion.this.orgSubAccountDao.getAllByPageDto(pageDto)))) {
                    for (OrgSubAccount orgSubAccount : orgSubAccounts) {
                        accountVersionMap.put("orgid_prefix_" + orgSubAccount.getOrgId(), orgSubAccount.getAccountVersion());
                    }
                }
                total += orgSubAccounts.size();
                pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            } while (orgSubAccounts.size() == 1000);
            log.info("InnerSync load orgSubAccounts finish! load size:{}", (Object)total);
            log.info("InnerSync load orgSubAccounts finish accountVersionMap :{}", accountVersionMap);
        }

        private void fillTXCascadeAccount(Map<String, Integer> accountVersionMap) {
            List txCascadeAccounts = null;
            log.debug("InnerSync start txCascadeAccounts ...");
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(Integer.valueOf(1000));
            pageDto.setPageNum(Integer.valueOf(1));
            int total = 0;
            do {
                if (CollectionUtils.isNotEmpty((Collection)(txCascadeAccounts = SyncAccountVersion.this.txCascadeAccountDao.getAllByPageDto(pageDto)))) {
                    for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
                        accountVersionMap.put("cascade_prefix_" + txCascadeAccount.getId(), txCascadeAccount.getAccountVersion());
                    }
                }
                total += txCascadeAccounts.size();
                pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            } while (txCascadeAccounts.size() == 1000);
            log.info("InnerSync load txCascadeAccounts finish! load size:{}", (Object)total);
        }
    }
}

