/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfomationDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTxtMsgService;
import com.baijia.tianxiao.sal.organization.org.service.impl.TxAccountPermissionServiceImpl;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgInfoServiceImpl
implements OrgInfoService {
    private static final Logger log = LoggerFactory.getLogger(OrgInfoServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgTxtMsgService orgTxtMsgService;
    @Autowired
    private TX400PhoneDao tx400PhoneDao;
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired(required=false)
    private HagService hagService;
    @Autowired
    private TXCascadeCredentialDao tXCascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao tXCascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    private static final String DEFAULT_ROLE_AVATAR = "https://imgs.genshuixue.com/21644918_xqjeiipb.png";
    private static final String DEFAULT_ORG_AVATAR = "http://www.genshuixue.com/asset/img/org/logo.jpg";

    @Override
    public OrgInfoSimpleDto getOrgInfo(Long orgId) throws BussinessException, Exception {
        OrgInfoSimpleDto result = null;
        try {
            Preconditions.checkNotNull((Object)orgId, (Object)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            Preconditions.checkNotNull((Object)orgInfo, (Object)"\u975e\u6cd5\u8bf7\u6c42");
            OrgAccount account = this.orgAccountDao.getAccountById(orgInfo.getOrgId().intValue(), new String[0]);
            Preconditions.checkNotNull((Object)account, (Object)"\u975e\u6cd5\u8bf7\u6c42");
            result = this.copyFrom(orgInfo);
            result.setMobile(account.getMobile());
            OrgTxtMsg introduce = this.orgTxtMsgService.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.SUMMARY.getValue());
            result.setIntroduce(introduce == null ? "" : introduce.getValue());
            result.setOrgNumber(account.getNumber().longValue());
            result.setTeacherSignin(orgInfo.getTeacherSignin());
            List branchsList = this.orgBranchsDao.listBranchsByOrgId(orgId.intValue());
            if (branchsList != null && branchsList.size() > 0) {
                OrgBranchs branchs = (OrgBranchs)branchsList.get(0);
                StringBuilder sb = new StringBuilder();
                sb.append(branchs.getProvince()).append(branchs.getCounty());
                sb.append(branchs.getDistrict()).append(branchs.getAddress());
                sb.append(branchs.getBranchName());
                result.setAddress(sb.toString());
            } else {
                result.setAddress("");
            }
            try {
                String mhost = PropertiesReader.getValue((String)"wxm", (String)"m.server");
                result.setMurl(mhost + "/i/" + result.getOrgNumber());
                String lhost = PropertiesReader.getValue((String)"wxm", (String)"m.server");
                result.setLocationUrl(lhost + "/branch/" + result.getOrgNumber());
            }
            catch (Exception e) {
                log.warn("[OrgInfo] Exception", (Object)e.getMessage());
            }
        }
        catch (BussinessException e) {
            log.error("[OrgInfo] BussinessException", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("[OrgInfo] Exception", (Throwable)e);
            throw e;
        }
        return result;
    }

    @Override
    public OrgInfoSimpleDto getMOrgInfo(Long orgId) throws BussinessException, Exception {
        OrgInfoSimpleDto result = null;
        try {
            Preconditions.checkNotNull((Object)orgId, (Object)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            Preconditions.checkNotNull((Object)orgInfo, (Object)"\u975e\u6cd5\u8bf7\u6c42");
            OrgAccount account = this.orgAccountDao.getAccountById(orgInfo.getOrgId().intValue(), new String[0]);
            Preconditions.checkNotNull((Object)account, (Object)"\u975e\u6cd5\u8bf7\u6c42");
            result = this.copyFrom(orgInfo);
            result.setMobile(account.getMobile());
            result.setOrgNumber(account.getNumber().longValue());
            result.setTeacherSignin(orgInfo.getTeacherSignin());
        }
        catch (BussinessException e) {
            log.error("[OrgInfo] BussinessException", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("[OrgInfo] Exception", (Throwable)e);
            throw e;
        }
        return result;
    }

    private OrgInfoSimpleDto copyFrom(OrgInfo orgInfo) {
        OrgInfoSimpleDto result = new OrgInfoSimpleDto();
        result.setShortName(orgInfo.getShortName());
        TX400Phone tx400Phone = this.tx400PhoneDao.getByOrgId(orgInfo.getOrgId());
        if (tx400Phone != null) {
            result.setTelephone(tx400Phone.getPhone400());
        } else {
            result.setTelephone("4000122166");
            result.setExtension(orgInfo.getExtension());
        }
        result.setLogo(this.getLogo(orgInfo.getOrgId()));
        result.setOrgId(orgInfo.getOrgId());
        result.setMarkingStatus(orgInfo.getMarketingStatus());
        result.setName(orgInfo.getName());
        result.setContacts(orgInfo.getContacts());
        return result;
    }

    @Override
    public String getLogo(int orgId) {
        String logo = OrgImgType.ORG_LOGO.getDefaultUrl();
        try {
            OrgStorage storage;
            OrgPhoto photo;
            Integer storageId;
            List photos = this.orgPhotoDao.getByOrgIdAndCategory(orgId, OrgImgType.ORG_LOGO.getValue());
            if (photos != null && !photos.isEmpty() && (storageId = (photo = (OrgPhoto)photos.get(0)).getOrgStorageId()) != null && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)Long.valueOf(storageId.longValue()), new String[0])) != null) {
                logo = this.constructUrl(storage);
            }
        }
        catch (Exception e) {
            log.error("get org logo failed, e:{}", (Throwable)e);
        }
        return logo;
    }

    public String constructUrl(OrgStorage storage) {
        String imgServer = PropertiesReader.getValue((String)"upload", (String)"img.server");
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = MIMEType.values()[storage.getMimeType() - 1].getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }

    @Override
    public boolean updateTeacherSigninStatus(Long orgId, Integer signinStatus) {
        return this.orgInfoDao.updateTeacherSigninByOrgId(orgId, signinStatus);
    }

    @Override
    public Integer findSigninStatus(Integer orgId) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[]{"teacherSignin"});
        return orgInfo.getTeacherSignin();
    }

    @Override
    public Map<Integer, OrgInfo> getOrgInfoMap(List<Integer> orgIds) {
        HashMap data = Maps.newHashMap();
        List orgInfos = this.orgInfoDao.getOrgInfos(orgIds, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)orgInfos)) {
            for (OrgInfo orgInfo : orgInfos) {
                data.put(orgInfo.getOrgId(), orgInfo);
            }
        }
        return data;
    }

    @Override
    public OrgInfo getOrgInfoByOrgId(Integer orgId) {
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        return orgInfo;
    }

    @Override
    public OrgInfomationDto getOrgInfoForRefresh(Integer orgId, Integer cascadeId, String imgServerLink, String homepageLink) {
        try {
            Preconditions.checkNotNull((Object)orgId, (Object)"\u673a\u6784orgId\u4e0d\u80fd\u4e3a\u7a7a");
            OrgAccount orgAcc = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
            Preconditions.checkNotNull((Object)orgAcc, (Object)("\u8be5orgId:" + orgId + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684orgAccount!"));
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
            Preconditions.checkNotNull((Object)orgInfo, (Object)("\u8be5orgId:" + orgId + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684orgInfo!"));
            OrgTxtMsg orgTxtMsg = this.orgTxtMsgService.getOrgTxtByIdAndType(orgId, AuditColumType.PHONE.getValue());
            OrgInfomationDto result = new OrgInfomationDto();
            result.setOrgId(orgId);
            result.setOrgNumber(orgAcc.getNumber());
            result.setShortName(orgInfo.getShortName());
            result.setOrgName(orgInfo.getName());
            result.setMobile(orgAcc.getMobile());
            result.setHotLine(null == orgTxtMsg ? null : orgTxtMsg.getValue());
            result.setOrgAvatar(this.getAvatarLink(orgAcc, imgServerLink));
            result.setHomePage(homepageLink.replace("number", orgAcc.getNumber().toString()));
            result.setDataAccountType(null != TxAccountPermissionServiceImpl.trailOrgAccount && orgAcc.getNumber().equals(TxAccountPermissionServiceImpl.trailOrgAccount.getNumber()) ? 1 : 0);
            result.setHasTianxiaoRole(BooleanUtils.toInteger((boolean)this.hagService.hasPermission((Object)orgAcc.getNumber(), 0, "jigou_tianxiao_orgNumber", new Object[0])));
            result.setAuditStatus(orgInfo.getAuditStatus());
            String initOrgName = "";
            String orgSlogan = "";
            String orgLogo = "";
            Integer infoFillStatus = 0;
            Integer hasMasterRole = 0;
            Integer accountStatus = 0;
            TXCascadeCredential txc = null;
            log.info("getOrgInfoForRefresh: ==== 7");
            if (null != cascadeId) {
                TXCascadeAccount tca = (TXCascadeAccount)this.tXCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
                Preconditions.checkNotNull((Object)tca, (Object)("\u8be5cascadeId:" + cascadeId + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684TXCascadeAccount!"));
                txc = (TXCascadeCredential)this.tXCascadeCredentialDao.getById((Serializable)tca.getCredentialId(), new String[0]);
                Preconditions.checkNotNull((Object)txc, (Object)("\u8be5cascadeId:" + cascadeId + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684TXCascadeCredential!"));
                result.setCascadeId(cascadeId);
                result.setCascadeRoleType(tca.getAccountType());
                result.setCascadeAvatar(StringUtils.isEmpty((CharSequence)txc.getAvatar()) ? DEFAULT_ROLE_AVATAR : txc.getAvatar());
                result.setNickName(txc.getName());
            }
            log.info("getOrgInfoForRefresh: ==== 9");
            OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgId(orgId, new String[0]);
            Integer orgId_ = orgId;
            if (orgSubAccount != null) {
                if (orgSubAccount.getPid() != 0) {
                    orgId_ = orgSubAccount.getPid();
                } else if (cascadeId == null) {
                    hasMasterRole = 1;
                }
            }
            log.info("getOrgInfoForRefresh: ==== 10");
            TXAccount txAccount = this.txAccountDao.getByOrgId(orgId_, TXAccountStatus.VALID.getCode());
            if (txAccount != null) {
                initOrgName = txAccount.getInitOrgName();
                initOrgName = GenericsUtils.isNullOrEmpty((Object)initOrgName) ? orgInfo.getName() : initOrgName;
                orgSlogan = txAccount.getOrgSlogan();
                orgLogo = txAccount.getOrgLogo();
                Integer infoFillStatus_ = txAccount.getInfoFillStatus();
                if (infoFillStatus_ != 0) {
                    infoFillStatus = 1;
                }
            }
            initOrgName = GenericsUtils.isNullOrEmpty((Object)initOrgName) ? orgInfo.getShortName() : initOrgName;
            result.setOrgLogo(orgLogo);
            result.setInitOrgName(initOrgName);
            result.setOrgSlogan(orgSlogan);
            result.setInfoFillStatus(infoFillStatus);
            result.setHasMasterRole(hasMasterRole);
            result.setAccountStatus(accountStatus);
            log.info("getOrgInfoForRefresh:{}", (Object)result);
            return result;
        }
        catch (NullPointerException npe) {
            log.error(" error is :{} ", (Throwable)npe);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, npe.getMessage());
        }
    }

    private String getAvatarLink(OrgAccount orgAcc, String imgServerLink) {
        List orgPhotoList = this.orgPhotoDao.getByOrgIdAndCategory(orgAcc.getId().intValue(), 1);
        if (CollectionUtils.isNotEmpty((Collection)orgPhotoList)) {
            Integer storageId = ((OrgPhoto)orgPhotoList.get(0)).getOrgStorageId();
            OrgStorage orgStorage = this.orgStorageDao.getById(storageId.intValue());
            return null == orgStorage ? DEFAULT_ORG_AVATAR : orgStorage.getUrl(imgServerLink);
        }
        return DEFAULT_ORG_AVATAR;
    }
}

