
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.todo.service;

import com.baijia.tianxiao.sal.organization.todo.constant.param.HomepageParamExpired;
import com.baijia.tianxiao.sal.organization.todo.constant.param.HomepageParamUnexpired;
import com.baijia.tianxiao.sal.organization.todo.dto.BackLogHomePageDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BackLogHomePageListDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BacklogDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BacklogListResponseDto;
import com.baijia.tianxiao.sal.organization.todo.dto.SaveBacklogDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Date;
import java.util.List;

import org.springframework.web.bind.annotation.RequestParam;

import com.baijia.tianxiao.dal.org.po.OrgCrontabTaskLog;
import com.baijia.tianxiao.exception.BussinessException;


/**
 * @title TxBacklogService
 * @desc TODO 
 * @author zhangbing
 * @date 2016年2月25日
 * @version 1.0
 */
public interface TxBacklogService {
    
	/**
     * 新增/修改待办事项
     * @param orgId 机构id
     * @param backlogDto 待办事项详情
     */
    public Long saveOrUpdateBacklog(Long orgId, Long cascadeId, SaveBacklogDto saveBacklogDto) throws CloneNotSupportedException;
    
    
    /**
     * 删除待办事项
     * @param orgId 机构id
     * @param backlogId 待办事项id
     */
    public void delBacklog(Long orgId, Long cascadeId, Long backlogId);
    
    
    /**
     * 获取待办事项列表
     * @param orgId 机构id
     * @param groupType 分组类型:GroupType
     * @param page 分页
     */
    public BacklogListResponseDto getBacklogList(Long orgId, Long cascadeId, int groupType, PageDto page);
    
    
    
    
    
    /**
     * 设置任务完成状态
     * @param orgId 机构id
     * @param backlogId 待办事项id
     * @param finish 是否完成:0未完成;1已完成
     */
    public void setBacklogStatus(Long orgId, Long cascadeId, Long backlogId, int finish);
    
    /**
     * 定时提醒
     * @param startTime
     * @param endTime
     * @param log
     */
    public void remind(Date startTime, Date endTime, OrgCrontabTaskLog log, boolean isNew);

    /**
     * 获取待办事项详情
     * @param orgId
     * @param bid
     * @return
     */
    public BacklogDto getBacklogDetail(Long orgId, Long cascadeId, Long bid) throws BussinessException;
    
    
    public void batchFinishExpired(Long orgId, Long cascadeId);
    
    public void batchDelExpired(Long orgId, Long cascadeId);
    
    public BackLogHomePageDto getBackLogHomePageDto(Long orgId, Long cascadeId,
    												HomepageParamUnexpired unexpired, 
    												HomepageParamExpired expired,
    												Integer expiredListPageNum,
    									    		Integer expiredListPageSize,
    									    		Integer finish,
    										    	Integer status);
    
    
    
}

    