/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.sal.organization.constant.CascadeSearchSource;
import com.baijia.tianxiao.sal.organization.constant.TXCommonRuleValue;
import com.baijia.tianxiao.sal.organization.org.dto.AccountSelectionDto;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialSelectionDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.organization.todo.dto.HeadTeacherRespDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.Collator;
import java.util.*;

/**
 * @author gaodan
 * @createdate 2016年5月18日
 * @desc
 */
@Service
@Slf4j
public class TxCascadeCredentialServiceImpl implements TxCascadeCredentialService {
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao orgTxCascadeCredentialDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgInfoService orgInfoService;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Override
    public Map<Long, String> getByTxCasCadeIds(Long orgId) {
        Map<Long, String> cascadeMap = Maps.newHashMap();

        /**
         * 主机构
         */
        OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId.intValue());
        cascadeMap.put(0l, orginfo.getContacts());

        List<TXCascadeAccount> txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
        log.debug("getByTxCasCadeIds orgId = {},cascadeMap={}", orgId, cascadeMap);
        if (GenericsUtils.isNullOrEmpty(txCascadeAccounts)) {
            return cascadeMap;
        }

        Map<Integer, TXCascadeAccount> cascadeIdsMap =
            CollectorUtil.collectMap(txCascadeAccounts, new Function<TXCascadeAccount, Integer>() {
                @Override
                public Integer apply(TXCascadeAccount txCascadeAccount) {
                    return txCascadeAccount.getId();
                }
            });

        Map<Long, String> cascadeMapResult =
            orgTxCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIdsMap.keySet());
        cascadeMapResult.put(0l, orginfo.getContacts());

        log.debug("getByTxCasCadeIds orgId = {},cascadeMapResult={}", orgId, cascadeMapResult);
        return cascadeMapResult;
    }

    @Override
    public TxCascadeCredentialDto getByTxCasCade(Long orgId, Integer cascadeId) {

        TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getByIdAndOrgId(cascadeId, orgId.intValue());
        if (txCascadeAccount == null) {
            return null;
        }
        TXCascadeCredential txCascadeCredential = orgTxCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
        TxCascadeCredentialDto result = buildToTxCascadeCredentialDto(txCascadeCredential);
        result.setUserType(txCascadeAccount.getAccountType());
        return result;
    }

    @Override
    public boolean isShowMobile(Long orgId, Integer cascadeId) {
        if (cascadeId == null || cascadeId == 0) {
            return true;
        }
        TxCascadeCredentialDto txCascadeCredentialDto = this.getByTxCasCade(orgId, cascadeId);
        boolean result = false;
        if (txCascadeCredentialDto != null
            && (txCascadeCredentialDto.getUserType() == CampusAccountType.MASTER_PRINCIPAL.getCode()
                || txCascadeCredentialDto.getUserType() == CampusAccountType.SLAVE_PRINCIPAL.getCode())) {
            result = true;
        }

        TXCommonRule commonRule = txCommonRuleService.getByOrgId(orgId.intValue());
        if (commonRule.getStudentMobileRule() == TXCommonRuleValue.STUDENT_MOBILE_DISPLAY.getCode()) {
            result = true;
        }

        log.debug("isShowMobile==orgId={},cascadeId={},isShowMobile ={}", orgId, cascadeId, result);
        return result;
    }

    @Override
    public List<TxCascadeCredentialDto> getTxCascadeCredentialList(Long orgId) {
        List<TxCascadeCredentialDto> result = Lists.newArrayList();
        OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId.intValue());
        if (orginfo != null) {
            TxCascadeCredentialDto dto = new TxCascadeCredentialDto();
            dto.setCascadeId(0);
            dto.setName(orginfo.getContacts());
            dto.setUserType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            dto.setCredentialId(0);
            result.add(dto);
        }

        List<TXCascadeAccount> txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
        log.debug("getTxCascadeCredentialList orgId = {},accounts={}", orgId, txCascadeAccounts);
        if (GenericsUtils.isNullOrEmpty(txCascadeAccounts)) {
            return result;
        }

        Map<Integer, TXCascadeAccount> credentialIdsMap =
            CollectorUtil.collectMap(txCascadeAccounts, new Function<TXCascadeAccount, Integer>() {
                @Override
                public Integer apply(TXCascadeAccount txCascadeAccount) {
                    return txCascadeAccount.getCredentialId();
                }
            });

        // 获取每个员工详情
        log.debug("getTxCascadeCredentialList credentialIdsMap={}", credentialIdsMap.keySet());
        List<TXCascadeCredential> txCascadeCredentials =
            this.orgTxCascadeCredentialDao.getTxCascadCredentialListByCredentialIds(credentialIdsMap.keySet());

        for (TXCascadeCredential txCascadeCredential : txCascadeCredentials) {
            TxCascadeCredentialDto dto = buildToTxCascadeCredentialDto(txCascadeCredential);
            TXCascadeAccount txCascadeAccount = credentialIdsMap.get(txCascadeCredential.getId().intValue());
            if (txCascadeAccount != null) {
                dto.setCascadeId(txCascadeAccount.getId());
            } else {
                dto.setCascadeId(0);
            }
            dto.setUserType(txCascadeAccount.getAccountType());
            result.add(dto);
        }

        log.debug("getTxCascadeCredentialList result={}", result);
        return result;
    }

    @Override
    public List<TxCascadeCredentialDto> getTxCascadeCredentialList(Long orgId, Integer cascadeId) {

        List<TXCascadeAccount> txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);

        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue());
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue());
        Integer orgNumber = orgAccount.getNumber();

        List<TxCascadeCredentialDto> txCascadeCredentialDtos = new ArrayList<>();

        if (GenericsUtils.notNullAndEmpty(txCascadeAccounts)) {
            List<Integer> credentialIds = new ArrayList<>();
            Map<Integer, TXCascadeAccount> txCascadeAccountMap = new HashMap<>();
            for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
                // 需要去除当前机构子帐号，
                if (!txCascadeAccount.getId().equals(cascadeId)) {
                    credentialIds.add(txCascadeAccount.getCredentialId());
                    txCascadeAccountMap.put(txCascadeAccount.getCredentialId(), txCascadeAccount);
                }
            }

            // 获取每个员工详情
            if (GenericsUtils.notNullAndEmpty(credentialIds)) {
                List<TXCascadeCredential> txCascadeCredentials =
                    this.orgTxCascadeCredentialDao.getTxCascadCredentialListByCredentialIds(credentialIds);

                for (TXCascadeCredential txCascadCredential : txCascadeCredentials) {
                    String name = txCascadCredential.getName();
                    String mobile = txCascadCredential.getMobile();
                    String str = getInitial(name, mobile);

                    TXCascadeAccount txCascadeAccount = txCascadeAccountMap.get(txCascadCredential.getId());
                    TxCascadeCredentialDto txCascadeCredentialDto =
                        TxCascadeCredentialDto.getInstance(txCascadCredential, txCascadeAccount);
                    txCascadeCredentialDto.setInitial(str.toUpperCase());
                    txCascadeCredentialDtos.add(txCascadeCredentialDto);
                }
            }

        }

        // 如果cascadeId不为空，需要获取改机构详情 员工可以与主账号进行聊天
        if (GenericsUtils.notNullAndEmpty(cascadeId)) {
            // 设置该机构身份
            Integer orgType = null;
            OrgSubAccount orgSubAccount = this.orgSubAccountDao.getMasterByOrgId(orgId.intValue());
            if (GenericsUtils.notNullAndEmpty(orgSubAccount)) {
                orgType = MsgUserRole.HEADER.getValue();
            } else {
                orgType = MsgUserRole.BRANCH_HEADER.getValue();
            }

            String name = orgInfo.getShowName();
            String mobile = orgAccount.getMobile();

            String str = getInitial(name, mobile);

            // 获取机构的logo作为校长或者分校校长头像
            String logo = null;
            try {
                OrgInfoSimpleDto orgDto = this.orgInfoService.getOrgInfo(orgId);
                logo = orgDto.getLogo();
            } catch (Exception e) {
                log.error("[ConsultMessage] orgLogo error param:{}", e);
            }
            TxCascadeCredentialDto txCascadeCredentialDto =
                TxCascadeCredentialDto.getInstanceByOrgInfo(orgType, orgInfo, orgNumber, logo);
            txCascadeCredentialDto.setInitial(str.toUpperCase());
            txCascadeCredentialDtos.add(txCascadeCredentialDto);
        }

        // 实例化一个比较器
        Comparator<TxCascadeCredentialDto> sortOfExportDto = new Comparator<TxCascadeCredentialDto>() {

            @Override
            public int compare(TxCascadeCredentialDto o1, TxCascadeCredentialDto o2) {
                // 因为PM要求数字开头的要排在最后，显示为#，ASCII中比字母大的符号只有~
                String initial1 = (o1.getInitial().equals("#") ? "~" : o1.getInitial());
                String initial2 = (o2.getInitial().equals("#") ? "~" : o2.getInitial());
                return initial1.compareTo(initial2) >= 0 ? 1 : -1;
            }

        };
        if (GenericsUtils.notNullAndEmpty(txCascadeCredentialDtos)) {
            Collections.sort(txCascadeCredentialDtos, sortOfExportDto);
        }

        return txCascadeCredentialDtos;
    }

    private String getInitial(String name, String mobile) {
        String pinyin = "";
        if (StringUtils.isNotBlank(name)) {
            pinyin = HanZiPinYinUtils.getLowerCasePinYin(name);
        } else {
            pinyin = HanZiPinYinUtils.getLowerCasePinYin(mobile);
        }

        String str = "#";
        if (StringUtils.isNotBlank(pinyin)) {
            char init = pinyin.charAt(0);
            if (init >= '0' && init <= '9') {
                str = "#";
            } else {
                str = String.valueOf(init);
            }
        }

        return str;

    }

    @Override
    public List<TxCascadeCredentialSelectionDto> getTxCascadeCredentialList(Integer orgId, Long cascadeId,
        CascadeSearchSource source, AccountSelectionDto dto) {
        Integer principalCascadeId = 0;
        List<TxCascadeCredentialSelectionDto> list = new ArrayList<TxCascadeCredentialSelectionDto>();

        TXCascadeAccount cascadeAccount = null;// 当前登录子账号
        Set<Integer> cascadesIds = new HashSet<Integer>();// 子账号id集合

        // 查询机构下所有的子账号
        List<TXCascadeAccount> txCascadeAccounts =
            this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(Long.parseLong(orgId + ""), Flag.FALSE.getInt());

        Map<Integer, TXCascadeAccount> txCascadeIdMap = new HashMap<Integer, TXCascadeAccount>();
        Map<Integer, TXCascadeAccount> txCredentialIdMap = new HashMap<Integer, TXCascadeAccount>();
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            txCascadeIdMap.put(txCascadeAccount.getId(), txCascadeAccount);
            txCredentialIdMap.put(txCascadeAccount.getCredentialId(), txCascadeAccount);
            cascadesIds.add(txCascadeAccount.getId());
        }
        // 参数验证
        if (cascadeId != null && cascadeId > 0) {
            cascadeAccount = txCascadeIdMap.get(cascadeId.intValue());
            if (cascadeAccount == null) {
                throw new PermissionException("账号ID不存在");
            }
        } else {
            cascadeId = principalCascadeId.longValue();
        }

        switch (source) {
            case CONSULTER_PASSTO:/** 规则 - 自己+全部下属 */
                cascadesIds.add(principalCascadeId);
                cascadesIds.addAll(txCascadeIdMap.keySet());

                // 去除线索持有人本身
                if (dto.getConsulterId() != null) {// 非null为了兼容旧版本
                    TxConsultUser txConsultUser = consultUserDao.getById(dto.getConsulterId());
                    cascadesIds.remove(txConsultUser.getCascadeId().intValue());
                }
                break;

            case CONSULTER_SEARCH:/** 规则 - 自己+全部下属 */
                cascadesIds.add(principalCascadeId);
                cascadesIds.addAll(txCascadeIdMap.keySet());
                break;

            case STUDENT_FILTER:
                cascadesIds.add(principalCascadeId);
                cascadesIds.addAll(txCascadeIdMap.keySet());
                break;
                
            case COMMENT_NOTUFY_COLLEAGUE:/** 规则 - 全部下属 */
                cascadesIds.add(principalCascadeId);
                cascadesIds.addAll(txCascadeIdMap.keySet());
                cascadesIds.remove(cascadeId.intValue()); // 去除自己
                break;
                
            case BACKLOG_PARTICIPANT:
            	cascadesIds.add(principalCascadeId);
                cascadesIds.addAll(txCascadeIdMap.keySet());
                break;

            default:
                break;
        }

        // 返回结果封装
        if (!CollectionUtils.isEmpty(cascadesIds)) {
            // 处理子账号处理
            Set<Integer> credentialIds = new HashSet<Integer>();
            for (Integer id : cascadesIds) {
                if (txCascadeIdMap.get(id.intValue()) != null)
                    credentialIds.add(txCascadeIdMap.get(id.intValue()).getCredentialId());
            }

            if (credentialIds.size() > 0) {
                List<TXCascadeCredential> txCascadeCredentials =
                    this.orgTxCascadeCredentialDao.getTxCascadCredentialListByCredentialIds(credentialIds);

                for (TXCascadeCredential txCascadCredential : txCascadeCredentials) {
                    String name = txCascadCredential.getName();
                    String mobile = txCascadCredential.getMobile();
                    String str = getInitial(name, mobile);
                    TXCascadeAccount txCascadeAccount = txCredentialIdMap.get(txCascadCredential.getId());
                    if (txCascadeAccount == null) { // 这里查出的数据为null，影响测试，暂时这样处理 by Rezar
                        continue;
                    }
                    TxCascadeCredentialSelectionDto sdto =
                        TxCascadeCredentialSelectionDto.getInstance(txCascadCredential, txCascadeAccount);
                    sdto.setInitial(str.toUpperCase());
                    list.add(sdto);
                }
            }

            // 处理主账号
            if (cascadesIds.contains(principalCascadeId.intValue())) {
                OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue());
                OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue());

                Integer orgType = null;
                OrgSubAccount orgSubAccount = this.orgSubAccountDao.getMasterByOrgId(orgId.intValue());
                if (GenericsUtils.notNullAndEmpty(orgSubAccount)) {
                    orgType = CampusAccountType.MASTER_PRINCIPAL.getCode();
                } else {
                    orgType = CampusAccountType.SLAVE_PRINCIPAL.getCode();
                }
                String name = orgInfo.getShowName();
                String mobile = orgAccount.getMobile();
                String str = getInitial(name, mobile);

                TxCascadeCredentialSelectionDto sdto =
                    TxCascadeCredentialSelectionDto.getInstanceByOrgInfo(orgType, orgInfo);
                String logo = orgInfoService.getLogo(orgId);
                if (StringUtils.isNotBlank(logo)) {
                    sdto.setAvatarUrl(logo);
                }
                sdto.setInitial(str.toUpperCase());
                list.add(sdto);
            }
        }

        // 按名称首字母排序
        Comparator<TxCascadeCredentialSelectionDto> sortOfExportDto =
            new Comparator<TxCascadeCredentialSelectionDto>() {
                @Override
                public int compare(TxCascadeCredentialSelectionDto o1, TxCascadeCredentialSelectionDto o2) {
                    if (o1.getInitial().matches("[a-zA-Z]*") && o2.getInitial().equals("#")) {
                        return -1;
                    } else if (o2.getInitial().matches("[a-zA-Z]*") && o1.getInitial().equals("#")) {
                        return 1;
                    }

                    return o1.getInitial().charAt(0) - o2.getInitial().charAt(0) >= 0 ? 1 : -1;
                }
            };
        Collections.sort(list, sortOfExportDto);

        return list;
    }

    @Override
    public void setAvatar(Long orgId, Integer cascadeId, Long storageId, String avatar) {
        if (cascadeId != null && cascadeId > 0) {
            TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(cascadeId);
            if (cascadeAccount == null) {
                throw new ParameterException();
            }
            TXCascadeCredential credential = orgTxCascadeCredentialDao.getById(cascadeAccount.getCredentialId());
            credential.setStorageId(storageId);
            credential.setAvatar(avatar);
            credential.setUpdateTime(new Date());
            orgTxCascadeCredentialDao.update(credential, false);
        } else {
            // 校长更新logo
            List<OrgPhoto> photos = orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), 1);
            if (photos != null && photos.size() > 0) {
                OrgPhoto photo = photos.get(0);
                photo.setOrgStorageId(storageId.intValue());
                photo.setUpdateTime(new Date());
                orgPhotoDao.update(photo, false);
            } else {
                OrgPhoto orgPhoto = new OrgPhoto();
                orgPhoto.setOrgId(orgId.intValue());
                orgPhoto.setOrgStorageId(storageId.intValue());
                orgPhoto.setAuditstatus(AuditStatus.PASS.getValue());
                orgPhoto.setCategory(OrgImgType.ORG_LOGO.getValue());
                orgPhoto.setGroupId(OrgImgType.ORG_LOGO.getGroupId());
                orgPhoto.setCreateTime(new Date());
                orgPhoto.setUpdateTime(new Date());
                orgPhoto.setIsdel(DataStatus.NORMAL.getValue());
                orgPhotoDao.save(orgPhoto);
            }
        }

    }

    /**
     * 待补充
     *
     * @param txCascadeCredential
     * @return
     */
    private TxCascadeCredentialDto buildToTxCascadeCredentialDto(TXCascadeCredential txCascadeCredential) {
        TxCascadeCredentialDto dto = new TxCascadeCredentialDto();
        dto.setName(txCascadeCredential.getName());
        dto.setCredentialId(txCascadeCredential.getId());
        dto.setAvatarUrl(txCascadeCredential.getAvatar());
        return dto;
    }

    @Override
    public List<HeadTeacherRespDto> listPcHeadTeacher(Long orgId, String key, Long courseId, PageDto pageDto) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "机构id非法");

        List<HeadTeacherRespDto> dtos = Lists.newArrayList();
        OrgInfo orginfo = orgInfoDao.queryOrgInfo(orgId.intValue(), key);
        if (orginfo != null) {
            OrgAccount orgAccount = orgAccountDao.getById(orgId);
            HeadTeacherRespDto dto = new HeadTeacherRespDto();
            dto.setAvatarUrl("https://imgs.genshuixue.com/11868862_i0x2qxlp.png");
            dto.setId(0);
            if (orgAccount != null) {
                dto.setMobile(orgAccount.getMobile());
            }
            // dto.setMobile("");
            dto.setName(orginfo.getContacts());
            dtos.add(dto);
        }
        // 查询出已选的班主任
        Integer cascadeId = null;
        if (courseId != null) {
            OrgCourse orgCourse = orgCourseDao.getById(courseId);
            if (orgCourse != null) {
                if (orgCourse.getIsDel() == 1) {
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程不存在");
                }
                cascadeId = orgCourse.getCascadeId();
            }
        }
        List<TXCascadeAccount> txCascadeAccount = txCascadeAccountDao.listIdByOrgId(orgId, cascadeId);
        Map<Integer, Integer> map =
            CollectorUtil.collectMap(txCascadeAccount, new Function<TXCascadeAccount, Integer>() {

                @Override
                public Integer apply(TXCascadeAccount account) {

                    return account.getCredentialId();
                }
            }, new Function<TXCascadeAccount, Integer>() {

                @Override
                public Integer apply(TXCascadeAccount account) {

                    return account.getId();
                }
            });
        Set<Integer> cascadeIds = BaseUtils.getPropertiesList(txCascadeAccount, "credentialId");
        List<TXCascadeCredential> txCascadeCredential =
            orgTxCascadeCredentialDao.gueryByKey(key, cascadeId, cascadeIds, pageDto);
        dtos.addAll(HeadTeacherRespDto.converToDto(txCascadeCredential, map));
        Collections.sort(dtos, new Comparator() {
            @Override
            public int compare(Object object1, Object object2) {
                HeadTeacherRespDto info1 = (HeadTeacherRespDto) object1;
                HeadTeacherRespDto info2 = (HeadTeacherRespDto) object2;
                // 按bean的名字排序
                return Collator.getInstance(Locale.CHINESE).compare(info1.getName(), info2.getName());
            }

        });
        return dtos;
    }

    @Override
    public TXCascadeCredential getByMobile(String mobile) {
        return this.orgTxCascadeCredentialDao.getByMobile(mobile);
    }

    @Override
    @Transactional
    public TXCascadeCredential modifyPassword(Integer id, String password) {
        TXCascadeCredential credential = this.orgTxCascadeCredentialDao.getById(id);
        credential.setPassword(password);
        credential.setUpdateTime(new Date());
        this.orgTxCascadeCredentialDao.saveOrUpdate(credential);

        // kick out online users
        txCascadeAccountDao.incrVersionByCredentialId(credential.getId());

        return credential;
    }

    @Override
    public Map<Integer, String> getNameMapByAccountIds(Collection<Integer> cascadeIdCollection) {
        //批量获取account信息
        List<TXCascadeAccount> txCascadeAccounts = txCascadeAccountDao.getByIds(cascadeIdCollection, "id","credentialId");
        if(CollectionUtils.isEmpty(txCascadeAccounts)){
            return Maps.newHashMap();
        }
        //从account获取提取credentialId
        List<Integer> credentialIdList = Lists.transform(txCascadeAccounts, new Function<TXCascadeAccount, Integer>() {
            @Override
            public Integer apply(TXCascadeAccount input) {
                return input.getCredentialId();
            }
        });
        Set<Integer> credentialIdSet = Sets.newHashSet(credentialIdList);
        //批量获取Credential信息
        List<TXCascadeCredential> cascadeCredentials = orgTxCascadeCredentialDao.getByIds(credentialIdSet, "id", "name");
        if(CollectionUtils.isEmpty(cascadeCredentials)){
            return Maps.newHashMap();
        }
        //key:credentialId,value:name
        Map<Integer, String> credentialIdNameMap = Maps.newHashMapWithExpectedSize(cascadeCredentials.size());
        for(TXCascadeCredential credential : cascadeCredentials){
            credentialIdNameMap.put(credential.getId(), credential.getName());
        }
        //key:cascadeId,value:name
        Map<Integer, String> nameMap = Maps.newHashMapWithExpectedSize(txCascadeAccounts.size());
        for(TXCascadeAccount account : txCascadeAccounts){
            nameMap.put(account.getId(), credentialIdNameMap.get(account.getCredentialId()));
        }
        return nameMap;
    }
}