package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.google.common.collect.Maps;

/**
 * @title TXPermissionServiceImpl
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年6月2日
 * @version 1.0
 */
    
@Service
public class TXPermissionServiceImpl implements TXPermissionService {
    
    @Autowired
    private TXPermissionDao txPermissionDao;

    @Override
    public Map<Long, TXPermission> getTXPermissionsMap(List<Long> codes) {
        Map<Long, TXPermission> data = Maps.newHashMap();
        List<TXPermission> txPermissions = txPermissionDao.geTxPermissions(codes);
        if(CollectionUtils.isNotEmpty(txPermissions)){
            for(TXPermission txPermission : txPermissions){
                data.put(txPermission.getCode(), txPermission);
            }
        }
        return data;
    }

    @Override
    public List<TXPermission> getTXPermissionsList(List<Long> codes) {
        List<TXPermission> txPermissions = txPermissionDao.geTxPermissions(codes);
        return txPermissions;
            
    }

    @Override
    public void saveAll(List<TXPermission> txPermissions) {
        txPermissionDao.saveAll(txPermissions);
    }

    @Override
    public List<TXPermission> getAllByPid(List<Integer> ids) {
        List<TXPermission> list = txPermissionDao.getByIds(ids);
        return list;
            
    }

    @Override
    public TXPermission getTXPermission(Long clde) {
        TXPermission txPermission = txPermissionDao.getTXPermission(clde);
        return txPermission;
    }

    @Override
    public Map<Integer, TXPermission> getAllTXPermissionsIDMap() {
        Map<Integer, TXPermission> data = Maps.newHashMap();
        List<TXPermission> txPermissions = txPermissionDao.getAll();
        if (CollectionUtils.isNotEmpty(txPermissions)) {
            for (TXPermission txPermission : txPermissions) {
                data.put(txPermission.getId(), txPermission);
            }
        }
        return data;
    }

    @Override
    public Map<Long, TXPermission> getAllTXPermissionsCodeMap() {
        Map<Long, TXPermission> data = Maps.newHashMap();
        List<TXPermission> txPermissions = txPermissionDao.getAll();
        if (CollectionUtils.isNotEmpty(txPermissions)) {
            for (TXPermission txPermission : txPermissions) {
                data.put(txPermission.getCode(), txPermission);
            }
        }
        return data;
    }
}
