
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.constants.SmsGateGroup;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author caoliang
 * @version 1.0
 * @title TXCampusAccountServiceImpl
 * @desc TODO
 * @date 2016年5月10日
 */
@Service
public class TXAccountServiceImpl implements TXAccountService {

    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Override
    public TXAccount getByOrgId(Integer orgId) {
        TXAccount account = txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode());
        return account;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.sal.organization.org.service.TXAccountService#getByIdAndOrgId(java.lang.Integer,
     * java.lang.Integer)
     */

    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        TXAccount account = txAccountDao.getByIdAndOrgId(id, orgId);
        return account;
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {
        TXAccount txAccount = txAccountDao.getByOrgNumber(orgNumber);
        return txAccount;
    }

    @Override
    public TXAccount getTXAccountByOrgId(Integer orgId) {
        OrgSubAccount subAcc = orgSubAccountDao.getByOrgId(orgId);
        TXAccount superAcc = null;
        if (0 == subAcc.getPid()) {// 先找到天校账号
            superAcc = this.getByOrgId(orgId);
        } else {
            //根据父校区orgId来查询txAccount;
            superAcc = this.getByOrgId(subAcc.getPid());
        }
        return superAcc;
    }

    @Override
    public Integer getTxAccountSmsGate(Integer orgId) {
        if (orgId == null) {
            return SmsGateGroup.DEFAULT_SMS_GATE;
        }
        TXAccount txAccount = getTXAccountByOrgId(orgId.intValue());
        if (txAccount == null) {
            return SmsGateGroup.DEFAULT_SMS_GATE;// 默认短信后缀网关
        }
        return txAccount.getSmsGate();
    }

    @Override
    public void saveTXAccount(TXAccount txAccount) {
        txAccountDao.save(txAccount);
    }


    @Override
    public TXAccount getByMobile(String mobile) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountByMobile(mobile);
        TXAccount txAccount = null;
        if (orgAccount != null) {
            txAccount = txAccountDao.getByOrgId(orgAccount.getId(), TXAccountStatus.VALID.getCode());
        }
        return txAccount;
    }
}
