
package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.util.properties.PropertiesReader;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgVideoDao;
import com.baijia.tianxiao.dal.org.dao.OrgVideoStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgVideo;
import com.baijia.tianxiao.dal.org.po.OrgVideoStorage;
import com.baijia.tianxiao.sal.organization.constant.VideoSrcType;
import com.baijia.tianxiao.sal.organization.org.dto.OrgVideoResponse;
import com.baijia.tianxiao.sal.organization.org.service.OrgVideoService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @author caoliang
 * @version 1.0
 * @title OrgVideoServiceImpl
 * @desc TODO
 * @date 2016年1月6日
 */
@Service
@Slf4j
public class OrgVideoServiceImpl implements OrgVideoService {

    @Autowired
    private OrgVideoDao orgVideoDao;
    @Autowired
    private OrgVideoStorageDao orgVideoStorageDao;

    @Override
    public List<OrgVideoResponse> loadOrgAllVideo(Integer org_id, PageDto pageDto) {

        List<OrgVideo> videos = this.orgVideoDao.searchOrgAllVideo(org_id, DeleteStatus.NORMAL.getValue(), pageDto);
        List<OrgVideoResponse> videoDtos = null;
        if (CollectionUtils.isNotEmpty(videos)) {
            List<OrgVideoStorage> videoStorages = this.orgVideoStorageDao.searchOrgAllVideo(org_id, VideoSrcType.ORG.getValue());
            Map<Integer, OrgVideoStorage> storageMap = makeVidStorageMap(videoStorages);
            log.info("OrgVideoServiceImpl.loadOrgAllVideo: orgId:{}, video count:{}", org_id, videos.size());
            videoDtos = new ArrayList<OrgVideoResponse>();

            OrgVideoResponse dto = null;
            try {
                String preVideoLink = PropertiesReader.getValue("wxm", "video.link");
                for (OrgVideo po : videos) {
                    dto = new OrgVideoResponse();
                    dto.setId(po.getId());
                    dto.setVid(String.valueOf(po.getVid()));
                    dto.setvName(po.getVName());
                    dto.setAuditstatus(po.getAuditstatus());
                    dto.setOther(po.getOther());
                    dto.setReason(po.getReason());

                    OrgVideoStorage storage = storageMap.get(po.getVid());
                    if (storage != null) {
                        log.info("org_id:{}, vid:{}, cover:{}", org_id, po.getVid(), storage.getImg());
                        dto.setCover(storage.getImg());
                        dto.setVideo_unique(storage.getVideo_unique());
                        dto.setSource(storage.getSource());
                        dto.setLink(preVideoLink + dto.getVideo_unique());
                    } else {
                        log.warn("OrgVideoServiceImpl.loadOrgAllVideo: vid:{} has no cover ,abort it", po.getVid());
                        continue;
                    }
                    videoDtos.add(dto);
                }
            } catch (Exception e) {
                log.error("loadAllVideo for {}", org_id, e);
                throw e;
            }
        }

        log.info("OrgVideoServiceImpl.loadOrgAllVideo: videoDtos:{}", videoDtos);
        return videoDtos;
    }

    private Map<Integer, OrgVideoStorage> makeVidStorageMap(List<OrgVideoStorage> videoStorages) {
        if (CollectionUtils.isEmpty(videoStorages)) {
            return Collections.emptyMap();
        }
        Map<Integer, OrgVideoStorage> map = Maps.newHashMap();
        for (OrgVideoStorage storage : videoStorages) {
            map.put(storage.getVideo_id(), storage);
        }
        return map;
    }

}
