package com.baijia.tianxiao.sal.organization.finance.constant;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/1
 * Time: 下午6:01
 * To change this template use File | Settings | File Templates.
 */
public enum CommonBankEnum {

    CMB("招商银行", "cbm", "https://imgs.genshuixue.com/0app/motopay/cmb.png", "D"),
    ICBC("中国工商银行", "icbc", "https://imgs.genshuixue.com/0app/motopay/icbc.png", "D"),
    CCB("中国建设银行", "ccb", "https://imgs.genshuixue.com/0app/motopay/ccb.png", "D"),
    ABC("中国农业银行", "abc", "https://imgs.genshuixue.com/0app/motopay/abc.png", "D"),
    BOC("中国银行", "boc", "https://imgs.genshuixue.com/0app/motopay/boc.png", "D"),
    SPDB("浦发银行", "spdb", "https://imgs.genshuixue.com/0app/motopay/spdb.png", "D"),
    CIB("兴业银行", "cib", "https://imgs.genshuixue.com/0app/motopay/cib.png", "D"),
    HXB("华夏银行", "hxb", "https://imgs.genshuixue.com/0app/motopay/hxb.png", "D"),
    PSBC("中国邮政储蓄", "psbc", "https://imgs.genshuixue.com/0app/motopay/psbc.png", "D"),
    CGB("广发银行", "cgb", "https://imgs.genshuixue.com/0app/motopay/cgb.png", "D"),
    CEB("中国光大银行", "cbm", "https://imgs.genshuixue.com/0app/motopay/ceb.png", "D"),
    PAB("平安银行", "pab", "https://imgs.genshuixue.com/0app/motopay/pab.png", "D"),
    CMBC("中国民生银行", "cmbc", "https://imgs.genshuixue.com/0app/motopay/cmbc.png", "D"),
    CITIC("中信银行", "citic", "https://imgs.genshuixue.com/0app/motopay/citic.png", "D"),
    JSB("江苏银行", "jsb", "https://imgs.genshuixue.com/0app/motopay/jsb.png", "D"),
    BOS("上海银行", "bos", "https://imgs.genshuixue.com/0app/motopay/bos.png", "D"),
    NBCB("宁波银行", "nbcb", "https://imgs.genshuixue.com/0app/motopay/nbcb.png", "D"),
    HZB("杭州银行", "hzb", "https://imgs.genshuixue.com/0app/motopay/hzb.png", "D"),
    HNC("南昌银行", "hnc", "https://imgs.genshuixue.com/0app/motopay/hnc.png", "D"),
    BCM("交通银行", "bcm", "https://imgs.genshuixue.com/0app/motopay/bcm.png", "D"),
    BOB("北京银行", "bob", "https://imgs.genshuixue.com/0app/motopay/bob.png", "D"),;

    private String name;
    private String bankCode;
    private String bankLogo;
    private String cardType;

    CommonBankEnum(String name, String bankCode, String bankLogo, String cardType) {
        this.name = name;
        this.bankCode = bankCode;
        this.bankLogo = bankLogo;
        this.cardType = cardType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBankLogo() {
        return bankLogo;
    }

    public void setBankLogo(String bankLogo) {
        this.bankLogo = bankLogo;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>"; //定义script的正则表达式
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>"; //定义style的正则表达式
        String regEx_html = "<[^>]+>"; //定义HTML标签的正则表达式

        Pattern p_script = Pattern.compile(regEx_script, Pattern.CASE_INSENSITIVE);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll(""); //过滤script标签

        Pattern p_style = Pattern.compile(regEx_style, Pattern.CASE_INSENSITIVE);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll(""); //过滤style标签

        Pattern p_html = Pattern.compile(regEx_html, Pattern.CASE_INSENSITIVE);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll(""); //过滤html标签

        return htmlStr.trim(); //返回文本字符串
    }

    public static void main(String[] args) {
        String s = delHTMLTag("<div><span>八田日培训学院时尚美甲老师</span><br></div><div>八田日培训学院个人扮靓彩妆老师</div><div>从事化妆品行业两年，性格外向，授课内容深入浅出，寓教于乐，善于与学员高度互动，语言幽默，穿透力强，现场学习氛围轻松。</div>");
        System.out.println(s);
    }
}
