
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.organization.token;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.validation.ValidateTokenUtil;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @title SyncAccountVersion
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年10月10日
 * @version 1.0
 */
@Slf4j
@Component
public class SyncAccountVersion implements InitializingBean {

    private static final int BATCH = 1000;

    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Override
    public void afterPropertiesSet() throws Exception {
        InnerSync innerSync = new InnerSync();
        innerSync.setDaemon(true);
        innerSync.start();

    }

    class InnerSync extends Thread {

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(60 * 1000);
                    Map<String, Integer> accountVersionMap = Maps.newHashMap();
                    fillOrgSubAccount(accountVersionMap);
                    fillTXCascadeAccount(accountVersionMap);
                    ValidateTokenUtil.accountVersionMap = accountVersionMap;
                }
            } catch (Throwable t) {
                log.warn("InnerSync error!", t);
            }

        }

        private void fillOrgSubAccount(Map<String, Integer> accountVersionMap) {
            log.debug("InnerSync start orgSubAccounts ...");
            List<OrgSubAccount> orgSubAccounts = null;
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(BATCH);
            pageDto.setPageNum(1);
            int total = 0;
            do {
                orgSubAccounts = orgSubAccountDao.getAllByPageDto(pageDto);
                if (CollectionUtils.isNotEmpty(orgSubAccounts)) {
                    for (OrgSubAccount orgSubAccount : orgSubAccounts) {
                        accountVersionMap.put(ValidateTokenUtil.ORG_ID_PREFIX + orgSubAccount.getOrgId(),
                            orgSubAccount.getAccountVersion());
                    }
                }
                total += orgSubAccounts.size();
                pageDto.setPageNum(pageDto.getPageNum() + 1);
            } while (orgSubAccounts.size() == BATCH);
            log.debug("InnerSync load orgSubAccounts finish! load size:{}", total);
            log.debug("InnerSync load orgSubAccounts finish accountVersionMap :{}", accountVersionMap);
        }

        private void fillTXCascadeAccount(Map<String, Integer> accountVersionMap) {
            List<TXCascadeAccount> txCascadeAccounts = null;
            log.debug("InnerSync start txCascadeAccounts ...");
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(BATCH);
            pageDto.setPageNum(1);
            int total = 0;
            do {
                txCascadeAccounts = txCascadeAccountDao.getAllByPageDto(pageDto);
                if (CollectionUtils.isNotEmpty(txCascadeAccounts)) {
                    for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
                        accountVersionMap.put(ValidateTokenUtil.CASCADE_PREFIX + txCascadeAccount.getId(),
                            txCascadeAccount.getAccountVersion());
                    }
                }
                total += txCascadeAccounts.size();
                pageDto.setPageNum(pageDto.getPageNum() + 1);
            } while (txCascadeAccounts.size() == BATCH);
            log.debug("InnerSync load txCascadeAccounts finish! load size:{}", total);
        }
    }

}
