
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.organization.org.service.impl;

import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgConfigDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgConfig;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.sal.organization.org.service.OrgConfigService;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.utils.RestUtil;
import com.baijia.tianxiao.util.rest.RestUtils;

/**
 * @title OrgConfigServiceImpl
 * @desc TODO 
 * @author zhangbing
 * @date 2016年2月17日
 * @version 1.0
 */
@Service
@Slf4j
public class OrgConfigServiceImpl implements OrgConfigService {
    
    @Autowired
    private OrgConfigDao orgConfigDao;
    
    @Autowired
    private OrgAccountDao accountDao;

    /**
     * 1.一个机构账号多设备登录，第一个登录账号的设备默认开启push，并将该设备的唯一编码存入org_config
     * 2.如果有其他设备手动开启push开关,覆盖之前的设备开关配置，
     * 3.同一个机构账号多设备登录,只有一个设备能接受到push消息
     */
    @Override
    public OrgConfig getOrgConfig(int orgId, String deviceId) {
        OrgAccount account = this.accountDao.getAccountById(orgId);
        
        OrgConfig config = null;
        if (account != null) {
            config = this.orgConfigDao.getOrgConfig(account.getNumber(), UserRole.ORGANIZATION.getRole(), BizConf.ORG_DEVICE_PUSH_SWITCH);
            log.info("number:{}, deviceId:{}, config:{}", account.getNumber(), deviceId, config);
            if (config != null) {
                if (!deviceId.equalsIgnoreCase(config.getValue())) {
                    config = null;
                }
            } else {
                config = this.saveOrgConfig(account.getNumber(), deviceId);
            }
        }
        
        return config;
    }
    
    /**
     * 保存设备push消息开关配置
     * @param number
     * @param deviceId
     * @return
     */
    OrgConfig saveOrgConfig(Integer number, String deviceId) {
        OrgConfig config = new OrgConfig();
        config.setCreateTime(new Timestamp(System.currentTimeMillis()));
        config.setTag(BizConf.ORG_DEVICE_PUSH_SWITCH);
        config.setUserId(number);
        config.setUserRole(UserRole.ORGANIZATION.getRole());
        config.setValue(deviceId);
        
        this.orgConfigDao.save(config);
        return config;
    }

    /**
     * push开关操作
     */
    @Override
    public void setOrgConfig(int orgId, String deviceId, boolean isClose, String appType, boolean isTrialAccount) {
        if (isClose) {
            close(orgId, deviceId, appType);
        } else {
            OrgAccount account = this.accountDao.getAccountById(orgId);
            OrgConfig config = null;
            if (account != null) {
                config = this.orgConfigDao.getOrgConfig(account.getNumber(), UserRole.ORGANIZATION.getRole(), BizConf.ORG_DEVICE_PUSH_SWITCH);
                if (config != null) {
                    config.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                    config.setValue(deviceId);
                    this.orgConfigDao.update(config, "value", "updateTime");
                    
                    //如果是体验账号，打开消息开关也需要关闭push推送消息
                    if (isTrialAccount) {
                        close(orgId, deviceId, appType);
                    }
                } else {
                    config = this.saveOrgConfig(account.getNumber(), deviceId);
                }
            }
        }
    }
    
    private void close(int orgId, String deviceId, String appType) {
        OrgAccount account = this.accountDao.getAccountById(orgId);
        OrgConfig config = null;
        if (account != null) {
            config = this.orgConfigDao.getOrgConfig(account.getNumber(), UserRole.ORGANIZATION.getRole(), BizConf.ORG_DEVICE_PUSH_SWITCH);
            if (config != null && deviceId.equalsIgnoreCase(config.getValue())) {
                unBind(orgId, appType);
                this.orgConfigDao.delById(config.getId());
            }
        }
    }
    
    /**
     * 解除机构账号push消息的绑定
     * @param params
     */
    public void unBind(int orgId, String appType) {
        Map<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("user_id", orgId+ "");
        parameterMap.put("user_role", UserRole.ORGANIZATION.getRole()+"");
        parameterMap.put("app_type", appType);
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", getTokenFromCache());
        
        RestfulResult<String> result = null;
        try {
            log.info("-------------------------------------------------------------");
            log.info("[unbind].params:{}", parameterMap);
            
            result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "push", "unbind", null, parameterMap, null);
            log.info("[unbind].result:{}", result);
            log.info("-------------------------------------------------------------");
            if (result.getCode() != 0) {
                throw new RuntimeException();
            }
        } catch (Exception e) {
            log.warn("[unbind] UnBind parameterMap:{}, result:{}", parameterMap, result);
            throw new RuntimeException();
        }
    }

    /**
     * 获取authToken
     * @return
     */
    public String getTokenFromCache() {
        String token = null;
        try {
            token = null;
            token = RestUtil.getInstance().getAuthToken();
            log.info("Get token from cached,token=" + token);
        } catch (Exception e) {
            log.error("NameChangeUtil.getTokenFromCache: rest-get-token error.", e);
        }
        return token;
    }
}

    