/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PermissionOperationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxRolePermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxRolePermission;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.AuthorityDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAuthApplicationMenuService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxAccountPermissionServiceImpl
implements TxAccountPermissionService {
    private static final Logger log = LoggerFactory.getLogger(TxAccountPermissionServiceImpl.class);
    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXAuthApplicationMenuService txAuthApplicationMenuService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TxRolePermissionDao txRolePermissionDao;
    public static final Integer TX_ACCOUNT_TYPE_FORMAL = 0;
    public static final Integer TX_ACCOUNT_TYPE_TRAIL = 1;
    private static final List<PermissionDto> expermissinDefaultPermission = new ArrayList<PermissionDto>();

    @Override
    public List<PermissionDto> listAllAuthModules(Integer pType, Integer deviceType, Long uId, Integer uType) {
        List permissions = this.txAccountPermissionDao.listAllConfigs(pType, deviceType, Integer.valueOf(uId.intValue()), uType);
        if (GenericsUtils.isNullOrEmpty((Object)permissions)) {
            return Collections.emptyList();
        }
        List pIds = ListUtil.toKeyList((Collection)permissions, (String)"pId", TxAccountPermission.class);
        ImmutableMap permissionMaps = Maps.uniqueIndex((Iterable)permissions, (Function)new Function<TxAccountPermission, Long>(){

            public Long apply(TxAccountPermission arg0) {
                return (long)arg0.getPId();
            }
        });
        List<ApplicationAuthConfig> findApplicationMenus = this.txAuthApplicationMenuService.findApplicationMenus(pIds);
        if (GenericsUtils.isNullOrEmpty(findApplicationMenus)) {
            return Collections.emptyList();
        }
        ArrayList<PermissionDto> retPermissions = new ArrayList<PermissionDto>(findApplicationMenus.size());
        for (ApplicationAuthConfig config : findApplicationMenus) {
            TxAccountPermission permission = (TxAccountPermission)permissionMaps.get(config.getId());
            Integer type = 0;
            if (permission != null) {
                type = permission.getPType();
            }
            PermissionDto pd = new PermissionDto();
            pd.setName(config.getModuleName());
            pd.setTag(config.getModuleCode());
            pd.setType(type);
            retPermissions.add(pd);
        }
        return retPermissions;
    }

    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType) {
        return this.findAuths(orgId, casCadeId, deviceType, TX_ACCOUNT_TYPE_FORMAL);
    }

    private List<PermissionDto> toExperiecceAccountPermissions() {
        return expermissinDefaultPermission;
    }

    private List<PermissionDto> toTxPermissionDto(List<TxAccountPermission> permissions) {
        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return Collections.emptyList();
        }
        ArrayList<TxAccountPermission> devicePermissions = new ArrayList<TxAccountPermission>();
        for (TxAccountPermission tap : permissions) {
            devicePermissions.add(tap);
        }
        log.info("find all txAccountPermissions, size:{} ", (Object)devicePermissions.size());
        Map<Integer, TXPermission> allByPidMap = this.txPermissionService.getAllTXPermissionsIDMap();
        ArrayList<PermissionDto> retDtos = new ArrayList<PermissionDto>();
        for (TxAccountPermission tap : devicePermissions) {
            Integer pId = tap.getPId();
            TXPermission tp = allByPidMap.get(pId);
            if (tp == null) continue;
            PermissionDto dto = new PermissionDto();
            dto.setName(tp.getName());
            dto.setTag(String.valueOf(tp.getCode()));
            dto.setType(tap.getPType());
            retDtos.add(dto);
        }
        return retDtos;
    }

    private List<TxAccountPermission> pickPermissions(List<TxAccountPermission> Permissions, Set<Long> ControlSet) {
        Map<Integer, TXPermission> allPIdMap = this.txPermissionService.getAllTXPermissionsIDMap();
        LinkedList result = Lists.newLinkedList(Permissions);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            if (ControlSet.contains(allPIdMap.get(((TxAccountPermission)iter.next()).getPId()).getCode())) continue;
            iter.remove();
        }
        return result;
    }

    @Override
    public List<TxAccountPermission> getAllPByUidLevelRoleDevice(Integer cascadeId, Integer vipLevel, Integer role, Integer device) {
        List txRolePermissions = this.txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(vipLevel, role, device);
        List<TxAccountPermission> defaultPermissions = this.buildPermissions(txRolePermissions);
        log.debug("the defaultPermissions size:{}", (Object)defaultPermissions.size());
        if (null != cascadeId) {
            HashMap PCMap = Maps.newHashMap();
            HashMap APPMap = Maps.newHashMap();
            List<TxAccountPermission> txAccountPermissions = this.txAccountPermissionDao.listAllConfigs(null, device, cascadeId, Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
            txAccountPermissions = this.pickPermissions(txAccountPermissions, TXPermissionConst.PERMISSION_SAVE_CONTROL_SET);
            log.debug("after pick the permission list size:{}", (Object)txAccountPermissions.size());
            if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
                for (TxAccountPermission p : txAccountPermissions) {
                    if (p.getDeviceType().equals(DeviceType.PC.getCode())) {
                        PCMap.put(p.getPId(), p.getPType());
                    }
                    if (!p.getDeviceType().equals(DeviceType.APP.getCode())) continue;
                    APPMap.put(p.getPId(), p.getPType());
                }
            }
            for (TxAccountPermission tap : defaultPermissions) {
                if (tap.getDeviceType().equals(DeviceType.PC.getCode()) && PCMap.containsKey(tap.getPId())) {
                    tap.setPType((Integer)PCMap.get(tap.getPId()));
                }
                if (!tap.getDeviceType().equals(DeviceType.APP.getCode()) || !APPMap.containsKey(tap.getPId())) continue;
                tap.setPType((Integer)APPMap.get(tap.getPId()));
            }
        }
        return defaultPermissions;
    }

    private List<TxAccountPermission> buildPermissions(List<TxRolePermission> txRolePermissions) {
        ArrayList result = Lists.newArrayList();
        for (TxRolePermission trp : txRolePermissions) {
            TxAccountPermission tap = new TxAccountPermission();
            tap.setPId(trp.getPId());
            tap.setPType(trp.getPType());
            tap.setUType(Integer.valueOf(0));
            tap.setDeviceType(trp.getDeviceType());
            result.add(tap);
        }
        return result;
    }

    @Override
    public Map<Integer, TxAccountPermission> getPMapByUidLevelRoleDevice(Integer uid, Integer vipLevel, Integer role, Integer device) {
        HashMap data = Maps.newHashMap();
        List<TxAccountPermission> list = this.getAllPByUidLevelRoleDevice(uid, vipLevel, role, device);
        for (TxAccountPermission txAccountPermission : list) {
            data.put(txAccountPermission.getPId(), txAccountPermission);
        }
        log.debug("the length of TxAccountPermission pMap is{}", (Object)data.size());
        return data;
    }

    @Override
    public void saveAll(List<TxAccountPermission> txAccountPermissions) {
        this.txAccountPermissionDao.saveAll(txAccountPermissions, new String[0]);
    }

    @Override
    public void updateAll(List<TxAccountPermission> txAccountPermissions) {
        if (CollectionUtils.isNotEmpty(txAccountPermissions)) {
            for (TxAccountPermission txAccountPermission : txAccountPermissions) {
                this.txAccountPermissionDao.update((Object)txAccountPermission, new String[0]);
            }
        }
    }

    @Override
    public boolean hasPermission(Long cascadeId, ApplicationType deviceType, TXPermissionConst permission) {
        ArrayList<Long> codes = new ArrayList<Long>();
        codes.add(permission.getpCode());
        List<TXPermission> permissionList = this.txPermissionService.getTXPermissionsList(codes);
        if (CollectionUtils.isEmpty(permissionList)) {
            return false;
        }
        TxAccountPermission txAccountPermission = this.txAccountPermissionDao.getTxAccountPermission(permissionList.get(0).getId(), deviceType.type, Integer.valueOf(cascadeId.intValue()));
        return txAccountPermission != null && txAccountPermission.getPType().equals(PermissionOperationType.CAN_USE.type);
    }

    @Override
    public AuthorityDto findAuths(Long orgId, Integer casCadeId, Integer deviceType, Integer accountTypeOfUser) {
        if (accountTypeOfUser == null) {
            accountTypeOfUser = TX_ACCOUNT_TYPE_FORMAL;
        }
        AuthorityDto authorityDto = new AuthorityDto();
        RoleType superRole = null;
        Long roleValue = null;
        String roleName = "";
        Integer uId = casCadeId;
        TXAccount superAccount = null;
        List<PermissionDto> permissionDtos = null;
        if (accountTypeOfUser == TX_ACCOUNT_TYPE_FORMAL) {
            if (casCadeId != null && (long)casCadeId.intValue() != 0L) {
                TXCascadeAccount tca = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)casCadeId, new String[0]);
                if (tca == null) {
                    log.info("can not find any cascade account with cadcadeId : {} ", (Object)casCadeId);
                    return null;
                }
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(tca.getOrgId());
                if (osa == null) {
                    OrgAccount accountById = this.orgAccountDao.getAccountById(tca.getOrgId().intValue(), new String[0]);
                    superAccount = this.txAccountService.getByOrgId(tca.getOrgId());
                    if (accountById == null || null == superAccount) {
                        log.info(" can not find any org account with orgId : {} ", (Object)orgId);
                        return null;
                    }
                } else {
                    Integer pId = osa.getPid();
                    superAccount = 0 == pId ? this.txAccountService.getByOrgId(tca.getOrgId()) : this.txAccountService.getByOrgId(pId);
                }
                Integer accountType = tca.getAccountType();
                superRole = RoleType.getRoleType((Integer)accountType);
            } else {
                OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()));
                if (osa == null) {
                    OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
                    superAccount = this.txAccountService.getByOrgId(orgId.intValue());
                    if (accountById == null || null == superAccount) {
                        log.info(" can not find any org account with orgId : {} ", (Object)orgId);
                        return null;
                    }
                    superRole = RoleType.PRESIDENT;
                } else {
                    Integer pId = osa.getPid();
                    if (0 == pId) {
                        superAccount = this.txAccountService.getByOrgId(orgId.intValue());
                        superRole = RoleType.PRESIDENT;
                    } else {
                        superAccount = this.txAccountService.getByOrgId(pId);
                        superRole = RoleType.BRANCH_SCH_PRESIDENT;
                    }
                }
                uId = orgId.intValue();
            }
            log.info("uId is :{} and roleType is : {} ", (Object)uId, (Object)superRole);
            List<TxAccountPermission> permissions = null;
            if (superRole == RoleType.CHARAGE || superRole == RoleType.EMPLOYEE) {
                permissions = this.getAllPByUidLevelRoleDevice(uId, superAccount.getVipLevel(), superRole.type, deviceType);
                log.info("convert to txPermissionDto with : {} ", (Object)permissions.size());
                permissionDtos = this.toTxPermissionDto(permissions);
            } else if (superRole == RoleType.PRESIDENT || superRole == RoleType.BRANCH_SCH_PRESIDENT) {
                permissions = this.getAllPByUidLevelRoleDevice(null, superAccount.getVipLevel(), superRole.type, deviceType);
                log.info("convert to txPermissionDto with : {} ", (Object)permissions.size());
                permissionDtos = this.toTxPermissionDto(permissions);
            }
        } else if (accountTypeOfUser == TX_ACCOUNT_TYPE_TRAIL) {
            superRole = RoleType.PRESIDENT;
            permissionDtos = this.toExperiecceAccountPermissions();
        }
        roleValue = superRole.type.longValue();
        roleName = superRole.desc;
        authorityDto.setRole(roleValue);
        authorityDto.setRoleName(roleName);
        authorityDto.setHasPermissions(permissionDtos);
        if (null != superAccount && superAccount.getVipLevel().equals(TXAccountType.DAZHONG.getCode())) {
            authorityDto.setVipName(TXAccountType.DAZHONG.getLabel());
        }
        return authorityDto;
    }

    @Override
    public List<TxAccountPermission> getAccountPermission(Integer uid, Integer pid) {
        List txAccountPermissions = this.txAccountPermissionDao.geTxAccountPermission(pid, uid);
        return txAccountPermissions;
    }

    @Override
    public List<TxAccountPermission> getAccountPermission(Integer uid, List<Integer> pid) {
        List txAccountPermissions = this.txAccountPermissionDao.geTxAccountPermission(pid, uid);
        return txAccountPermissions;
    }

    @Override
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId) {
        TxAccountPermissionsDto result = null;
        List plist = null;
        OrgSubAccount subAcc = null;
        TXAccount superAcc = null;
        subAcc = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId));
        superAcc = 0 == subAcc.getPid() ? this.txAccountService.getByOrgId(orgId) : this.txAccountService.getByOrgId(subAcc.getPid());
        log.debug("universalGetPermissions param is[ orgId:{},cascadeId:{}],superAcc:{}", new Object[]{orgId, cascadeId, superAcc});
        if (null == cascadeId) {
            if (0 == subAcc.getPid()) {
                plist = this.txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(superAcc.getVipLevel(), RoleType.PRESIDENT.type);
                result = this.rolePermissionsToDto(orgId, cascadeId, plist);
            } else if (0 != subAcc.getPid()) {
                plist = this.txRolePermissionDao.getTxRolePermissionsByVipLevelAndRole(superAcc.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type);
                result = this.rolePermissionsToDto(orgId, cascadeId, plist);
            }
        } else {
            TXCascadeAccount txCasAcc = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            List<TxAccountPermission> txAccountPermissions = this.getAllPByUidLevelRoleDevice(cascadeId, superAcc.getVipLevel(), txCasAcc.getAccountType(), null);
            result = this.buildDto2(orgId, cascadeId, txAccountPermissions);
        }
        return result;
    }

    private TxAccountPermissionsDto buildDto2(int orgId, Integer cascadeId, List<TxAccountPermission> txAccountPermissions) {
        Map<Integer, TXPermission> pMap = this.txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        ArrayList PCps = Lists.newArrayList();
        ArrayList APPps = Lists.newArrayList();
        for (TxAccountPermission rp : txAccountPermissions) {
            TXPermission permission = pMap.get(rp.getPId());
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(), permission.getName(), rp.getPType(), rp.getDeviceType()));
                continue;
            }
            if (!rp.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(), permission.getName(), rp.getPType(), rp.getDeviceType()));
        }
        result.setPCps(PCps);
        result.setAPPps(APPps);
        return result;
    }

    private TxAccountPermissionsDto rolePermissionsToDto(int orgId, Integer cascadeId, List<TxRolePermission> plist) {
        log.debug("rolePermissionsToDto the input rolePermissions list size is{}", (Object)plist.size());
        Map<Integer, TXPermission> pIdMap = this.txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        ArrayList PCps = Lists.newArrayList();
        ArrayList APPps = Lists.newArrayList();
        for (TxRolePermission rp : plist) {
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(), pIdMap.get(rp.getPId()).getName(), rp.getPType(), rp.getDeviceType()));
                continue;
            }
            if (!rp.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), rp.getPCode(), pIdMap.get(rp.getPId()).getName(), rp.getPType(), rp.getDeviceType()));
        }
        result.setPCps(PCps);
        result.setAPPps(APPps);
        return result;
    }

    @Override
    public TxAccountPermissionsDto universalGetPermissions(int orgId, Integer cascadeId, Collection<Long> pCodes) {
        TxAccountPermissionsDto result = null;
        if (CollectionUtils.isEmpty(pCodes)) {
            result = new TxAccountPermissionsDto();
            result.setOrgID(orgId);
            result.setCascadeId(cascadeId);
            result.setAPPps(new ArrayList<TxAccountPermissionsDto.AccountPermissionDto>());
            result.setPCps(new ArrayList<TxAccountPermissionsDto.AccountPermissionDto>());
            return result;
        }
        List plist = null;
        OrgSubAccount subAcc = null;
        TXAccount superAcc = null;
        subAcc = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId));
        superAcc = 0 == subAcc.getPid() ? this.txAccountService.getByOrgId(orgId) : this.txAccountService.getByOrgId(subAcc.getPid());
        if (null == cascadeId) {
            if (0 == subAcc.getPid()) {
                plist = this.txRolePermissionDao.getTxRolePermissionsByCodes(superAcc.getVipLevel(), RoleType.PRESIDENT.type, pCodes);
                result = this.rolePermissionsToDto(orgId, cascadeId, plist);
            }
            if (0 != subAcc.getPid()) {
                plist = this.txRolePermissionDao.getTxRolePermissionsByCodes(superAcc.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type, pCodes);
                result = this.rolePermissionsToDto(orgId, cascadeId, plist);
            }
        } else {
            TXCascadeAccount txCasAcc = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            List<TxAccountPermission> txAccountPermissions = this.getAllPByUidLevelRoleDevice(cascadeId, superAcc.getVipLevel(), txCasAcc.getAccountType(), null);
            result = this.buildDtoByFilter(orgId, cascadeId, txAccountPermissions, pCodes);
        }
        return result;
    }

    private TxAccountPermissionsDto buildDtoByFilter(int orgId, Integer cascadeId, List<TxAccountPermission> txAccountPermissions, Collection<Long> pCodes) {
        Map<Integer, TXPermission> pMap = this.txPermissionService.getAllTXPermissionsIDMap();
        TxAccountPermissionsDto result = new TxAccountPermissionsDto();
        result.setOrgID(orgId);
        result.setCascadeId(cascadeId);
        ArrayList PCps = Lists.newArrayList();
        ArrayList APPps = Lists.newArrayList();
        HashSet pCodeSet = Sets.newHashSet(pCodes);
        for (TxAccountPermission rp : txAccountPermissions) {
            TXPermission permission = pMap.get(rp.getPId());
            if (!pCodeSet.contains(permission.getCode())) continue;
            if (rp.getDeviceType().equals(DeviceType.PC.getCode())) {
                PCps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(), permission.getName(), rp.getPType(), rp.getDeviceType()));
                continue;
            }
            if (!rp.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            APPps.add(new TxAccountPermissionsDto.AccountPermissionDto(rp.getPId(), permission.getCode(), permission.getName(), rp.getPType(), rp.getDeviceType()));
        }
        result.setAPPps(APPps);
        result.setPCps(PCps);
        return result;
    }

    static {
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6821\u9a8c\u8f93\u5165\u7684\u652f\u4ed8\u5bc6\u7801", "10601", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u63d0\u73b0", "10602", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6536\u6b3e\u9875\u9762", "10302", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u6dfb\u52a0\u673a\u6784\u7535\u8bdd", "4060302", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u5220\u9664\u673a\u6784\u7535\u8bdd", "4060301", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u7f16\u8f91\u673a\u6784\u7535\u8bdd", "4060303", 1));
        expermissinDefaultPermission.add(new PermissionDto(0L, "\u8bbe\u7f6e\u652f\u4ed8\u5bc6\u7801", "10603", 1));
    }
}

