/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.MIMEType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgInfoServiceImpl
implements OrgInfoService {
    private static final Logger log = LoggerFactory.getLogger(OrgInfoServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgPhotoDao orgPhotoDao;
    @Autowired
    private OrgStorageDao orgStorageDao;

    @Override
    public OrgInfoSimpleDto getOrgInfo(Long orgId) throws BussinessException, Exception {
        OrgInfoSimpleDto result = null;
        try {
            Preconditions.checkNotNull((Object)orgId, (Object)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            Preconditions.checkNotNull((Object)orgInfo, (Object)"\u975e\u6cd5\u8bf7\u6c42");
            OrgAccount account = this.orgAccountDao.getAccountById(orgInfo.getOrgId().intValue(), new String[0]);
            Preconditions.checkNotNull((Object)account, (Object)"\u975e\u6cd5\u8bf7\u6c42");
            result = this.copyFrom(orgInfo);
            result.setOrgNumber(account.getNumber().longValue());
        }
        catch (BussinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return result;
    }

    private OrgInfoSimpleDto copyFrom(OrgInfo orgInfo) {
        OrgInfoSimpleDto result = new OrgInfoSimpleDto();
        result.setShortName(orgInfo.getShortName());
        result.setTelephone("4000122166");
        result.setExtension(orgInfo.getExtension());
        log.info("----------before---result:{}", (Object)result);
        result.setLogo(this.getLogo(orgInfo.getOrgId()));
        result.setOrgId(orgInfo.getOrgId());
        result.setMarkingStatus(orgInfo.getMarketingStatus());
        log.info("---------result:{}", (Object)result);
        return result;
    }

    private String getLogo(int orgId) {
        String logo = OrgImgType.ORG_LOGO.getDefaultUrl();
        try {
            OrgStorage storage;
            OrgPhoto photo;
            Integer storageId;
            List photos = this.orgPhotoDao.getByOrgIdAndCategory(orgId, OrgImgType.ORG_LOGO.getValue());
            if (photos != null && !photos.isEmpty() && (storageId = (photo = (OrgPhoto)photos.get(0)).getOrgStorageId()) != null && (storage = (OrgStorage)this.orgStorageDao.getById((Serializable)Long.valueOf(storageId.longValue()), new String[0])) != null) {
                logo = this.constructUrl(storage);
            }
        }
        catch (Exception e) {
            log.error("get org logo failed, e:{}", (Throwable)e);
        }
        return logo;
    }

    public String constructUrl(OrgStorage storage) {
        String imgServer = PropertiesReader.getValue((String)"upload", (String)"img.server");
        StringBuilder sb = new StringBuilder(imgServer);
        String surfix = MIMEType.values()[storage.getMimeType() - 1].getExtension();
        return sb.append(storage.getFid()).append("_").append(storage.getSn()).append(".").append(surfix).toString();
    }
}

