/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgConfigDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgConfig;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.sal.organization.org.service.OrgConfigService;
import com.baijia.tianxiao.sal.push.constant.Config;
import com.baijia.tianxiao.sal.push.utils.RestUtil;
import com.baijia.tianxiao.util.rest.RestUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgConfigServiceImpl
implements OrgConfigService {
    private static final Logger log = LoggerFactory.getLogger(OrgConfigServiceImpl.class);
    @Autowired
    private OrgConfigDao orgConfigDao;
    @Autowired
    private OrgAccountDao accountDao;

    @Override
    public OrgConfig getOrgConfig(int orgId, String deviceId) {
        OrgAccount account = this.accountDao.getAccountById(orgId, new String[0]);
        OrgConfig config = null;
        if (account != null) {
            config = this.orgConfigDao.getOrgConfig(account.getNumber().intValue(), UserRole.ORGANIZATION.getRole(), "org_device_push_switch");
            log.info("number:{}, deviceId:{}, config:{}", new Object[]{account.getNumber(), deviceId, config});
            if (config != null) {
                if (!deviceId.equalsIgnoreCase(config.getValue())) {
                    config = null;
                }
            } else {
                config = this.saveOrgConfig(account.getNumber(), deviceId);
            }
        }
        return config;
    }

    OrgConfig saveOrgConfig(Integer number, String deviceId) {
        OrgConfig config = new OrgConfig();
        config.setCreateTime(new Timestamp(System.currentTimeMillis()));
        config.setTag("org_device_push_switch");
        config.setUserId(number);
        config.setUserRole(UserRole.ORGANIZATION.getRole());
        config.setValue(deviceId);
        this.orgConfigDao.save((Object)config, new String[0]);
        return config;
    }

    @Override
    public void setOrgConfig(int orgId, String deviceId, boolean isClose, String appType) {
        if (isClose) {
            this.close(orgId, deviceId, appType);
        } else {
            OrgAccount account = this.accountDao.getAccountById(orgId, new String[0]);
            OrgConfig config = null;
            if (account != null) {
                config = this.orgConfigDao.getOrgConfig(account.getNumber().intValue(), UserRole.ORGANIZATION.getRole(), "org_device_push_switch");
                if (config != null) {
                    config.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                    config.setValue(deviceId);
                    this.orgConfigDao.update((Object)config, new String[]{"value", "updateTime"});
                } else {
                    config = this.saveOrgConfig(account.getNumber(), deviceId);
                }
            }
        }
    }

    private void close(int orgId, String deviceId, String appType) {
        OrgAccount account = this.accountDao.getAccountById(orgId, new String[0]);
        OrgConfig config = null;
        if (account != null && (config = this.orgConfigDao.getOrgConfig(account.getNumber().intValue(), UserRole.ORGANIZATION.getRole(), "org_device_push_switch")) != null && deviceId.equalsIgnoreCase(config.getValue())) {
            this.unBind(orgId, appType);
            this.orgConfigDao.delById((Serializable)config.getId());
        }
    }

    public void unBind(int orgId, String appType) {
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("user_id", orgId + "");
        parameterMap.put("user_role", UserRole.ORGANIZATION.getRole() + "");
        parameterMap.put("app_type", appType);
        parameterMap.put("app_id", Config.APP_ID);
        parameterMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        parameterMap.put("auth_token", this.getTokenFromCache());
        RestfulResult result = null;
        try {
            log.info("-------------------------------------------------------------");
            log.info("[unbind].params:{}", parameterMap);
            result = RestUtil.getInstance().rest(RestUtils.RestMethod.POST, "push", "unbind", null, parameterMap, null);
            log.info("[unbind].result:{}", (Object)result);
            log.info("-------------------------------------------------------------");
            if (result.getCode() != 0) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            log.warn("[unbind] UnBind parameterMap:{}, result:{}", parameterMap, result);
            throw new RuntimeException();
        }
    }

    public String getTokenFromCache() {
        String token = null;
        try {
            token = null;
            token = RestUtil.getInstance().getAuthToken();
            log.info("Get token from cached,token=" + token);
        }
        catch (Exception e) {
            log.error("NameChangeUtil.getTokenFromCache: rest-get-token error.", (Throwable)e);
        }
        return token;
    }
}

