/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.sal.organization.org.service.OrgBranchsService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OrgBranchsServicesImpl
implements OrgBranchsService {
    private static final Logger log = LoggerFactory.getLogger(OrgBranchsServicesImpl.class);
    @Autowired
    private OrgBranchsDao orgBranchsDao;

    @Override
    public OrgBranchs getDefaultOrgBranchs(int orgId) {
        List branchsList = this.orgBranchsDao.listBranchsByOrgId(orgId);
        if (branchsList != null && branchsList.size() > 0) {
            return (OrgBranchs)branchsList.get(0);
        }
        return new OrgBranchs();
    }

    @Override
    public void saveOrUpdate(int orgId, String province, String county, String district, String address, String longitude, String latitude) {
        OrgBranchs orgBranchs = this.getDefaultOrgBranchs(orgId);
        Date now = new Date();
        if (orgBranchs == null) {
            orgBranchs = new OrgBranchs();
            orgBranchs.setCreateTime(now);
        }
        if (StringUtils.isEmpty((Object)orgBranchs.getBranchName())) {
            orgBranchs.setBranchName("\u4e3b\u6821\u533a");
        }
        orgBranchs.setOrgId(Integer.valueOf(orgId));
        orgBranchs.setProvince(province);
        orgBranchs.setCounty(county);
        orgBranchs.setDistrict(district);
        orgBranchs.setAddress(address);
        orgBranchs.setLongitude(longitude);
        orgBranchs.setLatitude(latitude);
        orgBranchs.setUpdateTime(now);
        log.debug("save or update orgBranch==={}", (Object)orgBranchs);
        this.orgBranchsDao.saveOrUpdate((Object)orgBranchs, new String[0]);
    }
}

