/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.index.service.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.dto.request.TxVisitorRequest;
import com.baijia.tianxiao.sal.organization.index.service.TxVisitorService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TxVisitorServiceImpl
implements TxVisitorService {
    private static final Logger log = LoggerFactory.getLogger(TxVisitorServiceImpl.class);
    @Autowired
    private TxVisitorDao txVisitorDao;

    @Override
    public void saveVisitor(TxVisitorRequest request) {
        log.debug("save visitor request =={}", (Object)request);
        TxVisitor txVisitor = new TxVisitor();
        if (StringUtils.isEmpty((Object)request.getOrgName())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setOrgName(request.getOrgName());
        if (StringUtils.isEmpty((Object)request.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setMobile(request.getMobile());
        if (request.getProvinceId() == null || request.getCityId() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        txVisitor.setProvince(request.getProvince());
        txVisitor.setCity(request.getCity());
        txVisitor.setProvinceId(request.getProvinceId());
        txVisitor.setCityId(request.getCityId());
        txVisitor.setRemark(request.getRemark());
        txVisitor.setStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        txVisitor.setCreateTime(new Date());
        txVisitor.setUpdateTime(new Date());
        this.txVisitorDao.save((Object)txVisitor, new String[0]);
        log.debug("save visitor success =={}", (Object)txVisitor);
    }
}

