/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgPhotoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgPhoto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.util.storage.StorageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgPhotoServiceImpl
implements OrgPhotoService {
    private static final Logger log = LoggerFactory.getLogger(OrgPhotoServiceImpl.class);
    @Resource
    private OrgPhotoDao orgPhotoDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStorageDao orgStorageDao;

    @Override
    public String getPhotoUrlByOrgIdAndCategory(@NonNull Long orgId, @NonNull OrgImgType imgType) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (imgType == null) {
            throw new NullPointerException("imgType");
        }
        log.info("get org photo by orgId:{},imgType:{}", (Object)orgId, (Object)imgType);
        List photoes = this.orgPhotoDao.getByOrgIdAndCategory(orgId.intValue(), imgType.getValue());
        String photoUrl = imgType.getDefaultUrl();
        if (CollectionUtils.isNotEmpty((Collection)photoes)) {
            OrgStorage storage = (OrgStorage)this.orgStorageDao.getById((Serializable)((OrgPhoto)photoes.get(0)).getOrgStorageId(), new String[]{"fid", "sn", "mimeType"});
            photoUrl = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
        }
        log.info("get org photo url by orgId:{},imgType:{},url:{}", new Object[]{orgId, imgType, photoUrl});
        return photoUrl;
    }
}

