/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.constant.PAccessType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PMasterType;
import com.baijia.tianxiao.dal.pcAuthority.constant.PermissionOperationType;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.ApplicationAuthConfigDao;
import com.baijia.tianxiao.dal.pcAuthority.dao.PermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.ApplicationAuthConfig;
import com.baijia.tianxiao.dal.pcAuthority.po.Permission;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.AuthorityDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionRequest;
import com.baijia.tianxiao.sal.organization.org.service.TXAuthPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class TXAuthPermissionServiceImpl
implements TXAuthPermissionService {
    private static final Logger log = LoggerFactory.getLogger(TXAuthPermissionServiceImpl.class);
    private static final Long ONE_DAY_TIME = 86400000L;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private ApplicationAuthConfigDao ApplicationAuthConfigDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredendtialDao;
    @Autowired
    private TxVisitorDao txVistorDao;

    @Override
    public void savePermissions(List<PermissionRequest> permissions) {
        if (GenericsUtils.isNullOrEmpty(permissions)) {
            return;
        }
        List<Permission> permissionPos = this.toPermissionPos(permissions);
        log.info("permissionPos'size is : {} ", (Object)permissionPos.size());
        this.permissionDao.saveAll(permissionPos, new String[0]);
    }

    private List<Permission> toPermissionPos(List<PermissionRequest> permissions) {
        ArrayList<Permission> permissionPos = new ArrayList<Permission>();
        for (PermissionRequest dto : permissions) {
            permissionPos.add(dto.toPo());
        }
        return permissionPos;
    }

    @Override
    public List<PermissionDto> findPermissions(Integer applicationType, Integer pMasterType, Long pValue, String accessKey) {
        ArrayList<PermissionDto> ret = new ArrayList<PermissionDto>();
        List permissions = null;
        if (pMasterType != PMasterType.USER.type && pMasterType == PMasterType.ROLE.type) {
            permissions = this.permissionDao.findPermissionWithRoleType(pValue, accessKey);
        }
        if (GenericsUtils.notNullAndEmpty(permissions)) {
            List pIds = ListUtil.toKeyList(permissions, (String)"pAccessValue", Permission.class);
            List menus = this.ApplicationAuthConfigDao.getByIdsAndApplicationType(pIds, applicationType);
            ImmutableMap menuMap = Maps.uniqueIndex((Iterable)menus, (Function)new Function<ApplicationAuthConfig, Long>(){

                public Long apply(ApplicationAuthConfig from) {
                    return from.getId();
                }
            });
            if (GenericsUtils.notNullAndEmpty((Object)menus)) {
                for (Permission permission : permissions) {
                    ret.add(PermissionDto.toDto(permission, (ApplicationAuthConfig)menuMap.get(permission.getPAccessValue())));
                }
            }
        }
        return ret;
    }

    @Override
    public void initRolePermission(Long roleId, List<Long> ApplicationAuthConfigIds) {
        log.info("begin to init user permission ");
        ArrayList<PermissionRequest> permissionRequests = new ArrayList<PermissionRequest>();
        if (GenericsUtils.notNullAndEmpty(ApplicationAuthConfigIds)) {
            for (Long ApplicationAuthConfigId : ApplicationAuthConfigIds) {
                PermissionRequest pr = new PermissionRequest();
                pr.setApplicationMenuId(ApplicationAuthConfigId);
                pr.setPMasterType(PMasterType.ROLE.type);
                pr.setType(PermissionOperationType.CAN_USE.type);
                pr.setPValue(roleId);
                permissionRequests.add(pr);
            }
        }
        log.info(" permissionRequest are : {} ", permissionRequests);
        this.savePermissions(permissionRequests);
    }

    @Override
    public AuthorityDto findAuths(Long orgId, Long casCadeId, Integer applicationType) {
        HashSet<PermissionDto> permissions = new HashSet<PermissionDto>();
        HashSet<Long> roleTypes = new HashSet<Long>();
        RoleType superRole = null;
        Long roleValue = null;
        String roleName = "";
        String mobile = "";
        if (casCadeId != null) {
            TXCascadeAccount tca = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)casCadeId, new String[0]);
            if (tca == null) {
                return null;
            }
            TXCascadeCredential cascadeCredential = (TXCascadeCredential)this.txCascadeCredendtialDao.getById((Serializable)tca.getCredentialId(), new String[0]);
            if (cascadeCredential != null) {
                mobile = cascadeCredential.getMobile();
            }
            Integer accountType = tca.getAccountType();
            superRole = RoleType.getRoleType((Integer)accountType);
        } else {
            Integer pId;
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()));
            if (osa == null) {
                return null;
            }
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
            if (orgAccount != null) {
                mobile = orgAccount.getMobile();
            }
            superRole = 0 == (pId = osa.getPid()) ? RoleType.PRESIDENT : RoleType.BRANCH_SCH_PRESIDENT;
        }
        roleValue = superRole.type.longValue();
        roleName = superRole.desc;
        roleTypes.add(roleValue);
        List subRoleTypes = RoleType.getSubRoleTypes((RoleType)superRole);
        for (RoleType subRoleType : subRoleTypes) {
            roleTypes.add(subRoleType.type.longValue());
        }
        AuthorityDto authorityDto = new AuthorityDto();
        Integer userType = 0;
        List byMobile = this.txVistorDao.getByMobile(mobile);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        if (GenericsUtils.notNullAndEmpty((Object)byMobile)) {
            for (TxVisitor txVistor : byMobile) {
                Date startTime = txVistor.getStartTime();
                Integer remaindDay = txVistor.getRemainDay();
                Integer isDel = txVistor.getIsdel();
                log.info("txVistor createTime is : {} ", (Object)dateFormat.format(startTime));
                if (isDel != 0 || startTime.getTime() + (long)remaindDay.intValue() * ONE_DAY_TIME <= now.getTime()) continue;
                userType = 1;
                break;
            }
            if (userType == 0) {
                log.info("find the mobile:{}  is a vistor's mobile and can not login again for orgId:{} and cascade_Id:{}", new Object[]{mobile, orgId, casCadeId});
                return null;
            }
        }
        for (Long roleType : roleTypes) {
            List<PermissionDto> permissionDtos = this.findPermissions(applicationType, PMasterType.ROLE.type, roleType, PAccessType.PC_AUTH.desc);
            if (!GenericsUtils.notNullAndEmpty(permissionDtos)) continue;
            permissions.addAll(permissionDtos);
        }
        authorityDto.setRole(roleValue);
        authorityDto.setRoleName(roleName);
        authorityDto.setHasPermissions(new ArrayList<PermissionDto>(permissions));
        return authorityDto;
    }
}

