/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.TemplateStatus;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao;
import com.baijia.tianxiao.dal.org.po.OrgHomepageConfig;
import com.baijia.tianxiao.dal.org.po.OrgHomepageTemplate;
import com.baijia.tianxiao.sal.organization.org.dto.OrgHomepageTemplateListDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgHomepageTemplateService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgHomepageTemplateServiceImpl
implements OrgHomepageTemplateService {
    @Autowired
    private OrgHomepageTemplateDao orgHomepageTemplateDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;

    @Override
    public List<OrgHomepageTemplateListDto> getDefaultTemplateList(Integer orgId) {
        OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
        List templateLists = this.orgHomepageTemplateDao.getAllValidTemplate();
        if (usingTemplate != null) {
            return this.wrapper(usingTemplate.getTemplateId(), templateLists);
        }
        return this.wrapper(templateLists);
    }

    private List<OrgHomepageTemplateListDto> wrapper(int usedTemplateId, List<OrgHomepageTemplate> templateLists) {
        ArrayList data = Lists.newArrayList();
        OrgHomepageTemplateListDto item = null;
        for (OrgHomepageTemplate template : templateLists) {
            item = new OrgHomepageTemplateListDto();
            item.setUsing(template.getId() == usedTemplateId);
            item.setScheme(template.getTemplateName());
            item.setTemplateId(template.getId());
            item.setUrl(template.getUrl());
            item.setName(template.getDisplayName());
            data.add(item);
        }
        return data;
    }

    private List<OrgHomepageTemplateListDto> wrapper(List<OrgHomepageTemplate> templateLists) {
        ArrayList data = Lists.newArrayList();
        OrgHomepageTemplateListDto item = null;
        for (OrgHomepageTemplate template : templateLists) {
            item = new OrgHomepageTemplateListDto();
            item.setUsing(false);
            item.setScheme(template.getTemplateName());
            item.setTemplateId(template.getId());
            item.setUrl(template.getUrl());
            item.setName(template.getDisplayName());
            data.add(item);
        }
        return data;
    }

    @Override
    public OrgHomepageTemplate getTemplateById(Integer id) {
        return (OrgHomepageTemplate)this.orgHomepageTemplateDao.getById((Serializable)id, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(String scheme, String content) {
        this.orgHomepageTemplateDao.updateTemplate(scheme, content);
    }
}

