/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.org.service.impl;

import com.baijia.tianxiao.dal.org.constant.TemplateStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageConfigDao;
import com.baijia.tianxiao.dal.org.dao.OrgHomepageTemplateDao;
import com.baijia.tianxiao.dal.org.po.OrgHomepageConfig;
import com.baijia.tianxiao.dal.org.po.OrgHomepageTemplate;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.constant.WxTemplateType;
import com.baijia.tianxiao.sal.organization.org.service.OrgHomepageConfigService;
import java.io.Serializable;
import java.sql.Timestamp;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgHomepageConfigServiceImpl
implements OrgHomepageConfigService {
    private static final Logger log = LoggerFactory.getLogger(OrgHomepageConfigServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgHomepageTemplateDao orgHomepageTemplateDao;
    @Autowired
    private OrgHomepageConfigDao orgHomepageConfigDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTemplate(Integer orgId, Integer templateId, String content) {
        if (!this.doBefore(orgId)) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.USER_NOT_FOUND);
        }
        OrgHomepageConfig conf = new OrgHomepageConfig();
        conf.setContent(content);
        conf.setOrgId(orgId);
        conf.setTemplateId(templateId);
        conf.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.orgHomepageConfigDao.save((Object)conf, Boolean.valueOf(false), new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editTemplate(Integer orgId, Integer templateId, String content, String type) throws BussinessException {
        if (this.doBefore(orgId)) {
            OrgHomepageTemplate template = (OrgHomepageTemplate)this.orgHomepageTemplateDao.getById((Serializable)templateId, new String[0]);
            if (template != null) {
                if ("scheme".equals(type)) {
                    this.setScheme(orgId, template);
                } else if ("theme".equals(type)) {
                    this.setTheme(orgId, template, content);
                } else if ("config".equals(type)) {
                    this.setConfig(orgId, template, content);
                }
            }
        } else {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.USER_NOT_FOUND);
        }
    }

    void setScheme(Integer orgId, OrgHomepageTemplate template) {
        OrgHomepageConfig conf = this.orgHomepageConfigDao.getTemplateConf(orgId, template.getId());
        OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
        if (usingTemplate != null) {
            usingTemplate.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            usingTemplate.setStatus(Integer.valueOf(TemplateStatus.UNUSED.getCode()));
            this.orgHomepageConfigDao.update((Object)usingTemplate, new String[0]);
        }
        if (conf != null) {
            conf.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            conf.setStatus(Integer.valueOf(TemplateStatus.USING.getCode()));
            this.orgHomepageConfigDao.update((Object)conf, Boolean.valueOf(false), new String[]{"content", "status", "updateTime"});
        } else {
            conf = new OrgHomepageConfig();
            conf.setCreateTime(new Timestamp(System.currentTimeMillis()));
            conf.setOrgId(orgId);
            conf.setTemplateId(template.getId());
            conf.setContent(JSONObject.fromObject((Object)template.getContent()).getJSONObject("config").toString());
            conf.setStatus(Integer.valueOf(TemplateStatus.USING.getCode()));
            this.orgHomepageConfigDao.save((Object)conf, Boolean.valueOf(false), new String[]{"createTime", "orgId", "templateId", "content", "status"});
        }
    }

    void setTheme(Integer orgId, OrgHomepageTemplate template, String theme) {
        OrgHomepageConfig conf = this.orgHomepageConfigDao.getTemplateConf(orgId, template.getId());
        if (conf != null && conf.getStatus().intValue() == TemplateStatus.USING.getCode()) {
            String content = conf.getContent();
            JSONObject json = JSONObject.fromObject((Object)content);
            json.put((Object)"theme", (Object)theme);
            conf.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            conf.setContent(json.toString());
            this.orgHomepageConfigDao.update((Object)conf, Boolean.valueOf(false), new String[]{"updateTime", "content"});
        }
    }

    void setConfig(Integer orgId, OrgHomepageTemplate template, String config) {
        this.setScheme(orgId, template);
        OrgHomepageConfig conf = this.orgHomepageConfigDao.getTemplateConf(orgId, template.getId());
        if (conf != null && conf.getStatus().intValue() == TemplateStatus.USING.getCode()) {
            conf.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            conf.setContent(config);
            this.orgHomepageConfigDao.update((Object)conf, Boolean.valueOf(false), new String[]{"updateTime", "content"});
        }
    }

    @Override
    public OrgHomepageConfig getUsingTemplate(Integer orgId) {
        return this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
    }

    private boolean doBefore(Integer orgId) {
        return this.orgAccountDao.getById((Serializable)orgId, new String[0]) != null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearTemplateConfig(Integer orgId) {
        OrgHomepageConfig usingTemplate = this.orgHomepageConfigDao.getTemplateConfByStatus(orgId, Integer.valueOf(TemplateStatus.USING.getCode()));
        if (usingTemplate != null) {
            usingTemplate.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            usingTemplate.setStatus(Integer.valueOf(TemplateStatus.UNUSED.getCode()));
            this.orgHomepageConfigDao.update((Object)usingTemplate, Boolean.valueOf(false), new String[]{"status", "updateTime"});
        }
    }

    @Override
    public String defaultHeadImg(Integer orgId) {
        OrgHomepageConfig config = this.getUsingTemplate(orgId);
        String imgUrl = "";
        if (config == null) {
            return "";
        }
        OrgHomepageTemplate template = (OrgHomepageTemplate)this.orgHomepageTemplateDao.getById((Serializable)config.getTemplateId(), new String[0]);
        log.debug("template content =={}", (Object)config.getContent());
        JSONObject json = JSONObject.fromObject((Object)config.getContent());
        JSONArray jsonArray = JSONArray.fromObject((Object)json.get("widgets"));
        JSONObject arrayObject = JSONObject.fromObject((Object)jsonArray.get(1));
        JSONObject imgObject = JSONObject.fromObject((Object)arrayObject.get("config"));
        log.debug("template name =={}", (Object)template.getTemplateName());
        imgUrl = template.getTemplateName().equals(WxTemplateType.ABROAD.getName()) || template.getTemplateName().equals(WxTemplateType.ZAOJIAO.getName()) || template.getTemplateName().equals(WxTemplateType.KAIXUE.getName()) || template.getTemplateName().equals(WxTemplateType.LANGUAGE.getName()) ? imgObject.getString("img") : imgObject.getString("src");
        return imgUrl.equals("") ? null : imgUrl;
    }

    public static void main(String[] args) {
        String str = "{\"theme\":\"default\",\"widgets\":[{\"type\":\"titleBar\",\"config\":{}},{\"type\":\"header\",\"config\":{\"src\":\"http://img.gsxservice.com/7116056_bxwg5djr.png\"}},{\"type\":\"timeLine\",\"config\":{\"legend\":[{\"text\":\"Brand Story\",\"maxlength\":16},{\"text\":\"\u54c1\u724c\u6545\u4e8b\",\"maxlength\":8}],\"list\":[{\"text\":\"\u5320\u5fc3\u631a\u8bda \u8ffd\u6c42\u6781\u81f4\",\"maxlength\":10},{\"img\":\"http://img.gsxservice.com/7284841_vm6g3ldy.png\",\"text\":\"2015\u5e74\u6211\u4eec\u4ece\u5317\u4eac\u4e09\u91cc\u5c6fVILLAGE\u8d77\u822a\",\"maxlength\":24},{\"img\":\"http://img.gsxservice.com/7284845_z6f0fij7.png\",\"text\":\"\u53ea\u4e3a\u5065\u5eb7\u3001\u5b89\u5168\u3001\u7f8e\u5473\",\"maxlength\":18},{\"img\":\"http://img.gsxservice.com/7284847_nb4impwl.png\",\"text\":\"\u7528\u5fc3\u6210\u5c31\u5353\u8d8a\",\"maxlength\":18},{\"img\":\"http://img.gsxservice.com/7284849_fb4h1byi.png\",\"text\":\"\u6bcf\u4f4d\u5b66\u5458\u4eab\u53d7\u8ffd\u68a6\u7684\u8fc7\u7a0b\",\"maxlength\":18}]}},{\"type\":\"video\",\"config\":{\"img\":\"http://img.gsxservice.com/7284850_bmd89lh6.png\",\"text\":\"\u4f20\u627f\u6b27\u6d32\u767e\u5e74\u5de5\u827a\u4e0e\u73b0\u4ee3\u827a\u672f\u7684\u7ed3\u5408\",\"url\":\"\",\"maxlength\":20}},{\"type\":\"imageText\",\"config\":{\"skin\":\"skin10\",\"img\":\"http://img.gsxservice.com/7285127_qt3qmux3.jpg\",\"txtContainer\":true,\"texts\":[{\"text\":\"ibaker\u50cf\u4e00\u67b6\u98de\u673a\uff0c\",\"maxlength\":12},{\"text\":\"\u8e0f\u4e0a\u822a\u73ed\uff0c\u79bb\u68a6\u60f3\u66f4\u8fdb\u4e00\u6b65\",\"maxlength\":14}],\"submit\":{\"text\":\"\u9a6c\u4e0a\u54a8\u8be2GO>\",\"action\":\"makePhoneCall\",\"editable\":true,\"maxlength\":8}}},{\"type\":\"definationTable\",\"config\":{\"legend\":[{\"text\":\"CLASSES\",\"maxlength\":16},{\"text\":\"\u8bfe\u7a0b\u4ecb\u7ecd\",\"maxlength\":8}],\"list\":[{\"title\":{\"text\":\"\u6559\u5b66\u76ee\u7684\",\"maxlength\":8,\"clazz\":\"icon-list-os\"},\"content\":{\"text\":\"\u8bfe\u7a0b\u6db5\u76d6\u9762\u5e7f\uff0c\u4fbf\u4e8e\u5b66\u5458\u968f\u5e02\u573a\u4e0e\u6d88\u8d39\u5ba2\u6237\u7684\u53d8\u5316\u800c\u8c03\u8282\u548c\u53d8\u5316\uff0c\u901a\u8fc7\u5b66\u4e60\u60a8\u5c06\u4e86\u89e3\u4e16\u754c\u4e0d\u540c\u56fd\u5bb6\u7684\u4f20\u7edf\u548c\u6d41\u884c\u751c\u54c1\u98ce\u683c\u548c\u72ec\u7279\u827a\u672f\u521b\u610f\uff0c\u5f00\u9614\u60a8\u7684\u89c6\u91ce\u3002\u4f7f\u5b66\u5458\u5728\u77ed\u65f6\u95f4\u5185\u5b66\u5230\u771f\u6b63\u5bf9\u81ea\u5df1\u6709\u5e2e\u52a9\u7684\u8bfe\u7a0b\uff0c\u5177\u5907\u624e\u5b9e\u7684\u529f\u5e95\u4e0e\u4e3e\u4e00\u53cd\u4e09\u3001\u968f\u5fc3\u53d8\u6362\u54c1\u79cd\u7684\u80fd\u529b\u3002\",\"maxlength\":200}},{\"title\":{\"text\":\"\u9002\u5408\u4eba\u7fa4\",\"maxlength\":8,\"clazz\":\"icon-person-o\"},\"content\":{\"text\":\"\u4e0d\u4ec5\u771f\u7684\u70d8\u57f9\u7231\u597d\u8005\uff08\u7cfb\u7edf\u5b66\u4e60\u6b27\u5f0f\u897f\u70b9\uff09\u3001\u73b0\u6709\u5496\u5561\u5e97\u751c\u70b9\u54c1\u79cd\u63d0\u5347\uff08\u63d0\u9ad8\u6280\u672f\u53ca\u7ba1\u7406\u8fd0\u8425\u6c34\u5e73\uff0c\u611f\u53d7\u7eaf\u6b63\u6b27\u5f0f\u6559\u80b2\uff09\u3001\u4ee5\u53ca\u5e0c\u671b\u5f00\u521b\u897f\u70b9\u751f\u610f\u7684\u5b66\u5458\uff08\u6e34\u671b\u521b\u4e1a\u7684\u57ce\u5e02\u767d\u9886\u3001\u804c\u573a\u4eba\u58eb\u3001\u5c0f\u8d44\u7fa4\u4f53\u548c\u5927\u5b66\u751f\uff09\uff0c\u96f6\u57fa\u7840\u4e14\u5e0c\u671b\u8fdb\u5165\u70d8\u57f9\u884c\u4e1a\u6216\u8005\u5b66\u4e60\u4e13\u4e1a\u897f\u70b9\u7684\u5728\u5185\u7684\u5e7f\u5927\u7fa4\u4f53\u3002\",\"maxlength\":200}},{\"title\":{\"text\":\"\u8bfe\u7a0b\u7279\u70b9\",\"maxlength\":8,\"clazz\":\"icon-hat-o\"},\"content\":{\"text\":\"\u8bfe\u7a0b\u7d27\u51d1\uff0c\u6b3e\u6b3e\u7cbe\u54c1\u3002\u6b27\u5f0f\u897f\u70b9\u57f9\u8bad\u8bfe\u7a0b\uff0c\u7406\u8bba\u7ed3\u5408\u5b9e\u64cd\u5728\u5174\u8da3\u4e2d\u5b66\u4e60\uff0c\u5728\u6210\u5c31\u611f\u4e2d\u5f3a\u5316\u8bb0\u5fc6\u3002\u6211\u4eec\u7684\u8bfe\u7a0b\u4ece\u6613\u5230\u96be\uff0c\u65e0\u8bba\u662f\u6709\u57fa\u7840\u8fd8\u662f\u6ca1\u6709\u57fa\u7840\u7684\u5b66\u5458\u90fd\u9002\u5408\u5b66\u4e60\u3002\",\"maxlength\":200}},{\"title\":{\"text\":\"\u8bfe\u7a0b\u5185\u5bb9\",\"maxlength\":8,\"clazz\":\"icon-doc-o\"},\"content\":{\"text\":\"\u5496\u5561\u751c\u54c1Coffee pastries\uff0c\u6b27\u5f0f\u86cb\u7cd5Cakes\uff0c\u624b\u5de5\u5de7\u514b\u529bChocolate, \u6155\u65afMousse\uff0c\u897f\u9910\u5385\u751c\u54c1Desserts\uff0c\u897f\u70b9\u88c5\u9970\u6280\u5de7Gamishes,\u6cd5\u5f0f\u897f\u70b9\u7cfb\u5217\uff0c\u9762\u5305\u3001\u86cb\u631e\u3001\u6d3e\u7cfb\u5217\uff0c\u4e16\u754c\u7ecf\u5178\u86cb\u7cd5\u7cfb\u5217\uff0c\u829d\u58eb\u86cb\u7cd5\u7cfb\u5217\uff0c\u897f\u5f0f\u9171\u6c41\u7cfb\u5217\uff0c\u897f\u70b9\u57fa\u7840\u7406\u8bba\uff0c\u897f\u70b9\u827a\u672f\u8bbe\u8ba1\u3001\u897f\u70b9\u6280\u5de7\u3002\",\"maxlength\":200}}],\"submit\":{\"text\":\"\u9884\u7ea6\u8bd5\u542c\u8bfe\u7a0b&gt;\",\"action\":\"makePhoneCall\",\"editable\":true,\"maxlength\":10}}},{\"type\":\"materialTable\",\"config\":{\"legend\":[{\"text\":\"CLASSES\",\"maxlength\":16},{\"text\":\"\u8bfe\u5802\u4f5c\u54c1\",\"maxlength\":8}],\"list\":[{\"skin\":\"skin11\",\"img\":\"http://img.gsxservice.com/7284854_1ivvni6g.png\",\"imgType\":\"ad\",\"texts\":[{\"text\":\"\u84dd\u8272\u5730\u4e2d\u6d77\",\"maxlength\":10}],\"submit\":{\"text\":\"\u9a6c\u4e0a\u54a8\u8be2\",\"action\":\"makePhoneCall\"}},{\"skin\":\"skin11\",\"img\":\"http://img.gsxservice.com/7284856_meevdjku.png\",\"imgType\":\"ad\",\"texts\":[{\"text\":\"\u767e\u8c61\u679c\u5de7\u514b\u529b\u6155\u65af\u86cb\u7cd5\",\"maxlength\":10}],\"submit\":{\"text\":\"\u9a6c\u4e0a\u54a8\u8be2\",\"action\":\"makePhoneCall\"}},{\"skin\":\"skin11\",\"img\":\"http://img.gsxservice.com/7284860_xde50syb.png\",\"imgType\":\"ad\",\"texts\":[{\"text\":\"\u82f9\u679c\u6d3e\",\"maxlength\":10}],\"submit\":{\"text\":\"\u9a6c\u4e0a\u54a8\u8be2\",\"action\":\"makePhoneCall\"}},{\"skin\":\"skin11\",\"img\":\"http://img.gsxservice.com/7284866_1k92andu.png\",\"imgType\":\"ad\",\"texts\":[{\"text\":\"\u8349\u8393\u86cb\u7cd5\",\"maxlength\":10}],\"submit\":{\"text\":\"\u9a6c\u4e0a\u54a8\u8be2\",\"action\":\"makePhoneCall\"}}],\"submit\":{\"tplDataHref\":\"album\",\"text\":\"\u66f4\u591a\u4f5c\u54c1>\"}}},{\"type\":\"imageText\",\"config\":{\"skin\":\"skin12\",\"img\":\"http://img.gsxservice.com/7285661_45sdf56q.jpg\",\"txtContainer\":true,\"texts\":[{\"text\":\"Ibaker\u4f1a\u5458\",\"maxlength\":10},{\"text\":\"\u5728\u8fd9\u91cc\u5c3d\u4eab\u53a8\u827a\u793e\u4ea4\",\"maxlength\":14},{\"text\":\"\u8fd8\u53ef\u4eab\u53d7\u8bfe\u7a0b\u4f1a\u5458\u4ef7\u4f18\u60e0\",\"maxlength\":14}],\"submit\":{\"text\":\"\u6211\u60f3\u52a0\u5165>\",\"maxlength\":5,\"editable\":true,\"action\":\"makeOrder\"}}},{\"type\":\"classifyCourseList\",\"config\":{\"skin\":\"skin2\",\"legend\":[{\"text\":\"REGISTRATION\",\"maxlength\":16},{\"text\":\"\u5728\u7ebf\u62a5\u540d\",\"maxlength\":8}],\"button\":{\"action\":\"makePhoneCall\",\"text\":\"\u5728\u7ebf\u54a8\u8be2\"}}},{\"type\":\"imageText\",\"config\":{\"skin\":\"skin13\",\"img\":\"http://img.gsxservice.com/7287105_h4984q45.jpg\",\"txtContainer\":true,\"texts\":[{\"text\":\"\u52a0\u76dfibaker\",\"maxlength\":10},{\"text\":\"\u4e0e\u6211\u4eec\u4e00\u8d77\u5021\u5bfc\u5065\u5eb7\u3001\u5b89\u5168\u3001\u7f8e\u5473\",\"maxlength\":16}],\"submit\":{\"text\":\"\u8054\u7cfb\u6211\u4eec\",\"editable\":true,\"action\":\"makePhoneCall\",\"maxlength\":4}}},{\"type\":\"lifeContactUs\",\"config\":{\"legend\":[{\"text\":\"CONTACT US\",\"maxlength\":16},{\"text\":\"\u8054\u7cfb\u6211\u4eec\",\"maxlength\":8}],\"contacts\":{\"weixin\":{\"text\":\"ibaker1209\",\"maxlength\":20},\"qq\":{\"text\":\"43403928109\",\"maxlength\":20}},\"branches\":[{\"name\":{\"text\":\"ibaker\u6df1\u5733\u4e07\u8fbe\u5e97\",\"maxlength\":20},\"address\":{\"text\":\"\u5e7f\u4e1c\u7701\u6df1\u5733\u5e02\u5357\u6e56\u4e07\u8fbeF12309\",\"maxlength\":20},\"tel\":{\"text\":\"0755-88888888\",\"maxlength\":20}},{\"name\":{\"text\":\"ibaker\u4e0a\u6d77\u6d66\u4e1c\u5e97\",\"maxlength\":20},\"address\":{\"text\":\"\u4e0a\u6d77\u5e02\u6d66\u4e1c\u65b0\u533a\",\"maxlength\":20},\"tel\":{\"text\":\"021-88888888\",\"maxlength\":20}}],\"submit\":{\"text\":\"\u67e5\u770b\u5168\u90e8\u52a0\u76df\u5e97\",\"maxlength\":10,\"tplDataHref\":\"branch\",\"editable\":true}}}]}";
        JSONObject json = JSONObject.fromObject((Object)str);
        JSONArray jsonArray = JSONArray.fromObject((Object)json.get("widgets"));
        JSONObject arrayObject = JSONObject.fromObject((Object)jsonArray.get(1));
        JSONObject imgObject = JSONObject.fromObject((Object)arrayObject.get("config"));
        System.out.println("jsonObject ===" + imgObject.getString("src"));
    }
}

