/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.organization.todo.service.impl;

import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCrontabTaskDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCrontabTaskLog;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.todo.constant.GroupType;
import com.baijia.tianxiao.sal.organization.todo.constant.RemindType;
import com.baijia.tianxiao.sal.organization.todo.constant.TaskStatus;
import com.baijia.tianxiao.sal.organization.todo.constant.TodoErrorCode;
import com.baijia.tianxiao.sal.organization.todo.dto.BacklogDto;
import com.baijia.tianxiao.sal.organization.todo.dto.BacklogListResponseDto;
import com.baijia.tianxiao.sal.organization.todo.dto.RelatedStudent;
import com.baijia.tianxiao.sal.organization.todo.service.TxBacklogService;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.dto.PushConfig;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.utils.NativeUrlUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TxBacklogServiceImpl
implements TxBacklogService {
    private static final Logger log = LoggerFactory.getLogger(TxBacklogServiceImpl.class);
    private static final String BACKLOG_ACTION = "backlog_info";
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgCrontabTaskDao orgCrontabTaskDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private ConsultMessageService messageService;
    @Autowired
    private ConsultAvatarUrlService consultAvatarUrlService;

    @Override
    @DataAuthority(resourceTypes={RequestSourceDesc.BACK_LOG_LIST})
    public BacklogListResponseDto getBacklogList(Long orgId, int groupType, PageDto page) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Preconditions.checkArgument((groupType >= 0 && groupType <= 3 ? 1 : 0) != 0, (Object)"groupType is illegal");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.ORG_NOT_EXIST);
        }
        Integer txCascadeId = TianxiaoMContext.getTXCascadeId();
        BacklogListResponseDto responseDto = new BacklogListResponseDto();
        ArrayList backlogListDto = Lists.newArrayList();
        List list = Lists.newArrayList();
        responseDto.setGroupType(groupType);
        responseDto.setList(backlogListDto);
        boolean canAccess = RequestSourceDesc.BACK_LOG_LIST.canAccess("getBacklogList", this.getClass(), Long.class, Integer.TYPE, PageDto.class);
        if (canAccess) {
            txCascadeId = null;
        }
        list = this.txBacklogDao.getBacklogListByGroup(orgId, txCascadeId, Integer.valueOf(groupType), page, new String[0]);
        log.info("getBacklogList-------orgId={},groupType={},page={},list={}", new Object[]{orgId, GroupType.getNoteWithValue(groupType), page, list});
        ArrayList<Long> consultUserIds = new ArrayList<Long>();
        ArrayList<Long> studentIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (TxBacklog po : list) {
                BacklogDto dto = new BacklogDto();
                this.backlogPo2Dto(po, dto);
                if (po.getStudentId() != null && po.getStudentId() > 0L) {
                    studentIds.add(po.getStudentId());
                } else {
                    consultUserIds.add(po.getConsultUserId());
                }
                backlogListDto.add(dto);
            }
            Map<Long, RelatedStudent> studentMap = this.buildStudents(studentIds, orgId);
            Map<Long, RelatedStudent> consultUserMap = this.buildConsultUsers(consultUserIds, orgId);
            for (BacklogDto dto : backlogListDto) {
                RelatedStudent relatedStudent = null;
                if (dto.getRelatedStudent() == null) {
                    log.warn("RelatedStudent is null!");
                    continue;
                }
                relatedStudent = dto.getRelatedStudent().getType() == 1 ? studentMap.get(dto.getRelatedStudent().getStudentId()) : consultUserMap.get(dto.getRelatedStudent().getStudentId());
                if (relatedStudent != null) {
                    dto.setRelatedStudent(relatedStudent);
                    continue;
                }
                log.warn("[Backlog] student is not exist.{}", (Object)dto.getRelatedStudent());
            }
        }
        return responseDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long saveBacklog(Long orgId, BacklogDto backlogDto) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Long backlogId = backlogDto.getBacklogId();
        log.info("saveBacklog---------backlogDto={},backlogId={}", (Object)backlogDto, (Object)backlogId);
        backlogId = null != backlogId && backlogId > 0L ? this.editBacklog(backlogDto, orgId) : this.addBacklog(backlogDto, orgId);
        return backlogId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void delBacklog(Long orgId, Long backlogId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Preconditions.checkArgument((backlogId != null && backlogId > 0L ? 1 : 0) != 0, (Object)"backlogId is illegal");
        TxBacklog txBacklog = (TxBacklog)this.txBacklogDao.getById((Serializable)backlogId, new String[]{"id", "orgId", "delStatus"});
        log.info("delBacklog---------backlogId={},orgId={},txBacklog={}", new Object[]{backlogId, orgId, txBacklog});
        if (null != txBacklog && DeleteStatus.NORMAL.getValue() == txBacklog.getDelStatus()) {
            if (null == txBacklog.getOrgId() || txBacklog.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_IN_ORG);
            }
        } else {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
        }
        txBacklog.setDelStatus(DeleteStatus.DELETED.getValue());
        txBacklog.setUpdateTime(new Date());
        this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[]{"delStatus", "updateTime"});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void setBacklogStatus(Long orgId, Long backlogId, int finish) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Preconditions.checkArgument((backlogId != null && backlogId > 0L ? 1 : 0) != 0, (Object)"backlogId is illegal");
        TxBacklog txBacklog = this.txBacklogDao.getBacklogByIdAndOrgId(backlogId, orgId, new String[]{"id", "finish"});
        log.info("setBacklogStatus------txBacklog={}", (Object)txBacklog);
        if (null == txBacklog) throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
        if (finish == txBacklog.getFinish()) throw new BussinessException((UniverseErrorCode)(0 == finish ? TodoErrorCode.BACKLOG_HAS_UNFINISH : TodoErrorCode.BACKLOG_HAS_FINISH));
        txBacklog.setFinish(finish);
        txBacklog.setUpdateTime(new Date());
        if (finish == 0) {
            this.txBacklogDao.update((Object)txBacklog, new String[]{"finish", "updateTime"});
            return;
        } else {
            if (finish != 1) return;
            this.txBacklogDao.update((Object)txBacklog, new String[]{"finish", "updateTime"});
        }
    }

    private void backlogPo2Dto(TxBacklog po, BacklogDto dto) {
        dto.setIsSys(po.getIsSys());
        dto.setBacklogId(po.getId());
        dto.setContent(StringUtils.isNotBlank((CharSequence)po.getContent()) ? po.getContent() : "");
        if (null != po.getEndTime()) {
            dto.setEndTime(po.getEndTime().getTime());
            if (null != po.getRemindTime()) {
                dto.setRemindType(RemindType.getByDiff(po.getRemindTime().getTime() - po.getEndTime().getTime()).getValue());
            } else {
                dto.setRemindType(RemindType.NO_REMIND.getValue());
            }
        } else {
            dto.setEndTime(System.currentTimeMillis());
            dto.setRemindType(RemindType.NO_REMIND.getValue());
        }
        dto.setFinish(po.getFinish());
        dto.setFinishString(TaskStatus.getNoteByValue(po.getFinish()));
        dto.setRelatedStudent(this.buildStudent(po.getConsultUserId(), po.getStudentId()));
    }

    private RelatedStudent buildStudent(Long consultUserId, Long studentId) {
        RelatedStudent relatedStudent = null;
        if (null != studentId && studentId > 0L) {
            relatedStudent = new RelatedStudent();
            relatedStudent.setType(1);
            relatedStudent.setStudentId(studentId);
        } else if (null != consultUserId && consultUserId > 0L) {
            relatedStudent = new RelatedStudent();
            relatedStudent.setType(0);
            relatedStudent.setStudentId(consultUserId);
        }
        log.info("buildStudent------relatedStudent={}", relatedStudent);
        return relatedStudent;
    }

    private Map<Long, RelatedStudent> buildStudents(Collection<Long> studentIds, Long orgId) {
        HashMap<Long, RelatedStudent> retMap = new HashMap<Long, RelatedStudent>();
        if (null != studentIds && studentIds.size() > 0) {
            List students = this.orgStudentDao.getStudentByIds(orgId, studentIds, new String[]{"id", "userId"});
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            if (students != null) {
                for (OrgStudent stu : students) {
                    map.put(stu.getUserId(), stu.getId());
                }
            }
            Map avatarMap = this.consultAvatarUrlService.batchStudentAvatarUrlAndNameDMap(map.keySet(), orgId);
            Set keySet = avatarMap.keySet();
            for (Long id : keySet) {
                ConsultAvatarUrlAndNameDto dto = (ConsultAvatarUrlAndNameDto)avatarMap.get(id);
                RelatedStudent relatedStudent = new RelatedStudent();
                relatedStudent.setType(1);
                relatedStudent.setStudentId((Long)map.get(id));
                relatedStudent.setName(dto.getName());
                relatedStudent.setAvatar(dto.getAvatarUrl());
                retMap.put((Long)map.get(id), relatedStudent);
            }
        }
        return retMap;
    }

    private Map<Long, RelatedStudent> buildConsultUsers(Collection<Long> consultUserIds, Long orgId) {
        List consultUsers;
        HashMap<Long, RelatedStudent> retMap = new HashMap<Long, RelatedStudent>();
        if (null != consultUserIds && consultUserIds.size() > 0 && null != (consultUsers = this.txConsultUserDao.batchTxConsultUserByIds(consultUserIds, null, null))) {
            Map avatarMap = this.consultAvatarUrlService.batchConsultAvatarUrlAndNameDtoMap(consultUserIds, orgId);
            Set keySet = avatarMap.keySet();
            for (Long id : keySet) {
                ConsultAvatarUrlAndNameDto dto = (ConsultAvatarUrlAndNameDto)avatarMap.get(id);
                RelatedStudent relatedStudent = new RelatedStudent();
                relatedStudent.setType(0);
                relatedStudent.setStudentId(id);
                relatedStudent.setName(dto.getName());
                relatedStudent.setAvatar(dto.getAvatarUrl());
                retMap.put(id, relatedStudent);
            }
        }
        return retMap;
    }

    private Long addBacklog(BacklogDto backlogDto, Long orgId) {
        log.info("addBacklog------orgId={}, backlogDto={}", (Object)orgId, (Object)backlogDto);
        TxBacklog txBacklog = new TxBacklog();
        backlogDto.setCascadeId(TianxiaoMContext.getTXCascadeId() == null ? 0 : TianxiaoMContext.getTXCascadeId());
        this.backlogDto2Po(backlogDto, txBacklog, orgId);
        this.txBacklogDao.save((Object)txBacklog, Boolean.valueOf(true), new String[0]);
        log.info("addBacklog-------txBacklog={}", (Object)txBacklog.toString());
        return txBacklog.getId();
    }

    private Long editBacklog(BacklogDto backlogDto, Long orgId) {
        Long backlogId = backlogDto.getBacklogId();
        TxBacklog txBacklog = this.txBacklogDao.getBacklogByIdAndOrgId(backlogId, orgId, new String[0]);
        log.info("editBacklog-------backlogDto={},txBacklog={}", (Object)backlogDto, (Object)txBacklog);
        if (null == txBacklog) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
        }
        this.verifyParaAndStatus(txBacklog, backlogDto);
        this.syncStudentInfo(txBacklog, backlogDto, orgId);
        this.backlogDto2Po(backlogDto, txBacklog, orgId);
        this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(true), new String[0]);
        log.info("editBacklog-------txBacklog={}", (Object)txBacklog);
        return txBacklog.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void backlogDto2Po(BacklogDto dto, TxBacklog po, Long orgId) {
        po.setStudentId(Long.valueOf(0L));
        po.setConsultUserId(Long.valueOf(0L));
        po.setOrgId(orgId);
        if (dto.getCascadeId() != null) {
            po.setCascadeId(dto.getCascadeId());
        }
        po.setContent(StringUtils.isNotEmpty((CharSequence)dto.getContent()) ? dto.getContent() : "");
        po.setEndTime(new Date(dto.getEndTime()));
        po.setCreateTime(null == po.getCreateTime() ? new Date() : po.getCreateTime());
        po.setUpdateTime(new Date());
        if (dto.getRemindType() >= RemindType.ON_TIME.getValue() && dto.getRemindType() <= RemindType.TWO_DAY_AHEAD.getValue()) {
            po.setRemindTime(new Date(dto.getEndTime() - RemindType.getDiffByValue(dto.getRemindType())));
        } else {
            po.setRemindTime(null);
        }
        if (null == dto.getRelatedStudent() || null == dto.getRelatedStudent().getStudentId() || dto.getRelatedStudent().getStudentId() <= 0L) return;
        if (0 == dto.getRelatedStudent().getType()) {
            Long consultUserId = dto.getRelatedStudent().getStudentId();
            TxConsultUser consultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)consultUserId, new String[]{"id", "orgId", "delStatus", "studentId"});
            if (null == consultUser || DeleteStatus.NORMAL.getValue() != consultUser.getDelStatus().intValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_EXIST);
            if (orgId.longValue() != consultUser.getOrgId().longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_IN_ORG);
            po.setConsultUserId(consultUserId);
            return;
        } else {
            if (1 != dto.getRelatedStudent().getType()) return;
            Long studentId = dto.getRelatedStudent().getStudentId();
            OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[]{"org_id", "delStatus"});
            if (null == student || DeleteStatus.NORMAL.getValue() != student.getDelStatus().intValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_EXIST);
            if (orgId.longValue() != student.getOrgId().longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_IN_ORG);
            po.setStudentId(studentId);
            List list = this.txConsultUserDao.lookByStudentId(orgId, studentId, new String[]{"id", "studentId"});
            if (!CollectionUtils.isNotEmpty((Collection)list)) return;
            po.setConsultUserId(((TxConsultUser)list.get(0)).getId());
        }
    }

    private void verifyParaAndStatus(TxBacklog txBacklog, BacklogDto backlogDto) {
        if (txBacklog.getEndTime().before(new Date())) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.CAN_NOT_EDIT_EXPIRED_BACKLOG);
        }
        if (BizConf.TRUE.intValue() == txBacklog.getFinish()) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.CAN_NOT_EDIT_FINISH_BACKLOG);
        }
        if (BizConf.TRUE.intValue() == txBacklog.getIsSys() && null != backlogDto.getRelatedStudent() && (0 == backlogDto.getRelatedStudent().getType() ? null != txBacklog.getConsultUserId() && txBacklog.getConsultUserId().longValue() != backlogDto.getRelatedStudent().getStudentId().longValue() : null != txBacklog.getStudentId() && txBacklog.getStudentId().longValue() != backlogDto.getRelatedStudent().getStudentId().longValue())) {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.CAN_NOT_EDIT_SYSTEM_BACKLOG_WITH_STUDENT);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void syncStudentInfo(TxBacklog txBacklog, BacklogDto backlogDto, Long orgId) {
        if (BizConf.TRUE.intValue() != txBacklog.getIsSys() || backlogDto.getEndTime().longValue() == txBacklog.getEndTime().getTime()) return;
        if (0 == backlogDto.getRelatedStudent().getType()) {
            if (backlogDto.getRelatedStudent().getStudentId().longValue() != txBacklog.getConsultUserId().longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
            TxConsultUser consulterUser = this.consultUserDao.getOrgConsultUser(orgId, txBacklog.getConsultUserId());
            if (null == consulterUser) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_EXIST);
            consulterUser.setNextRemindTime(new Date(backlogDto.getEndTime()));
            consulterUser.setUpdateTime(new Date());
            this.txConsultUserDao.update((Object)consulterUser, new String[]{"nextRemindTime", "updateTime"});
            return;
        } else {
            if (1 != backlogDto.getRelatedStudent().getType()) return;
            if (backlogDto.getRelatedStudent().getStudentId().longValue() != txBacklog.getStudentId().longValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
            OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)txBacklog.getStudentId(), new String[0]);
            if (null == orgStudent || orgStudent.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) throw new BussinessException((UniverseErrorCode)TodoErrorCode.STUDENT_NOT_EXIST);
            orgStudent.setNextRemindTime(new Date(backlogDto.getEndTime()));
            orgStudent.setUpdateTime(new Date());
            this.orgStudentDao.update((Object)orgStudent, new String[]{"nextRemindTime", "updateTime"});
        }
    }

    @Override
    public void remind(Date startTime, Date endTime, OrgCrontabTaskLog taskLog, boolean isNew) {
        List result = this.txBacklogDao.getBacklogListByRemindTime(startTime, endTime);
        if (result != null && !result.isEmpty()) {
            this.prepared(result, taskLog, isNew);
        } else {
            taskLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            if (isNew) {
                this.orgCrontabTaskDao.save((Object)taskLog, new String[0]);
            } else {
                this.orgCrontabTaskDao.update((Object)taskLog, new String[]{"executeTime", "updateTime"});
            }
        }
    }

    private void prepared(List<TxBacklog> result, OrgCrontabTaskLog taskLog, boolean isNew) {
        for (TxBacklog backlog : result) {
            this.pushBacklog(backlog);
        }
        taskLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        taskLog.setValue(result.get(result.size() - 1).getId());
        if (isNew) {
            this.orgCrontabTaskDao.save((Object)taskLog, new String[0]);
        } else {
            this.orgCrontabTaskDao.update((Object)taskLog, new String[]{"executeTime", "updateTime", "value"});
        }
    }

    private void pushBacklog(TxBacklog backlog) {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("bid", backlog.getId());
        log.info("[Notice] Todo notice");
        try {
            String content = NoticeType.TO_DO.getContent() + ":" + backlog.getContent();
            this.messageService.sendNotice(backlog.getOrgId(), backlog.getCascadeId(), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.TO_DO, (String)ActionUtil.getAction((String)BACKLOG_ACTION, param), (String)content));
        }
        catch (Exception e) {
            log.error("[Notice] exception ", (Throwable)e);
        }
    }

    private PushConfig getPushConfig(TxBacklog backlog) {
        PushConfig config = new PushConfig();
        config.setTip("\u60a8\u6709\u4e00\u4e2a\u5f85\u529e\u4e8b\u9879\u9700\u8981\u5904\u7406");
        String url = NativeUrlUtil.getUrl((String)BACKLOG_ACTION);
        url = NativeUrlUtil.addParam((String)url, (String)"bid", (Object)backlog.getId());
        config.setJumpUrl(url);
        return config;
    }

    @Override
    public BacklogDto getBacklogDetail(Long orgId, Long bid) throws BussinessException {
        TxBacklog backlog = (TxBacklog)this.txBacklogDao.getById((Serializable)bid, new String[0]);
        BacklogDto dto = null;
        if (backlog != null && backlog.getOrgId().longValue() == orgId.longValue()) {
            dto = new BacklogDto();
            this.backlogPo2Dto(backlog, dto);
            RelatedStudent relatedStudent = null;
            if (dto.getRelatedStudent() != null) {
                if (dto.getRelatedStudent().getType() == 1) {
                    Map<Long, RelatedStudent> studentMap = this.buildStudents(Arrays.asList(dto.getRelatedStudent().getStudentId()), orgId);
                    relatedStudent = studentMap.get(dto.getRelatedStudent().getStudentId());
                } else {
                    Map<Long, RelatedStudent> consultUserMap = this.buildConsultUsers(Arrays.asList(dto.getRelatedStudent().getStudentId()), orgId);
                    relatedStudent = consultUserMap.get(dto.getRelatedStudent().getStudentId());
                }
                dto.setRelatedStudent(relatedStudent);
            }
        } else {
            throw new BussinessException((UniverseErrorCode)TodoErrorCode.BACKLOG_NOT_EXIST);
        }
        return dto;
    }
}

