/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.msg.service.impl;

import com.baijia.tianxiao.common.service.MsgSendService;
import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.msg.dao.TxSmsCountDao;
import com.baijia.tianxiao.dal.msg.po.TxSmsCount;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.exception.MsgSendException;
import com.baijia.tianxiao.sal.msg.service.CommonSmsService;
import com.google.common.base.Preconditions;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MsgSendServiceImpl
implements MsgSendService {
    private static final Logger log = LoggerFactory.getLogger(MsgSendServiceImpl.class);
    @Resource
    private WechatMsgRenderService wechatMsgSenderService;
    @Resource
    private CommonSmsService smsService;
    @Resource
    private TxSmsCountDao txSmsCountDao;

    public boolean sendMsg(SendMsgRequest request) throws MsgSendException {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkArgument((request.getSenderId() != null ? 1 : 0) != 0, (Object)"sender id is null");
        Preconditions.checkArgument((request.getReceiverId() != null ? 1 : 0) != 0, (Object)"receiver id is null");
        Preconditions.checkArgument((request.getOrgId() != null ? 1 : 0) != 0, (Object)"orgId id is null");
        Preconditions.checkArgument((request.getSenderRole() != null ? 1 : 0) != 0, (Object)"senderRole id is null");
        Preconditions.checkArgument((request.getReceiverRole() != null ? 1 : 0) != 0, (Object)"receiverRole id is null");
        boolean sendResult = false;
        log.info("try to send msg by request:{}", (Object)request);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getWeixinOpenId()}) && request.getWechatTemplateId() != null) {
            log.info("try to send msg by wechat:{}", (Object)request.getWechatParams());
            try {
                request.getWechatParams().put("touser", request.getWeixinOpenId());
                sendResult = this.wechatMsgSenderService.sendMsg(request.getOrgId(), this.wechatMsgSenderService.render(request.getWechatTemplateId(), request.getWechatParams()));
                if (sendResult) {
                    log.info("send msg result:{} by wechat:{}", (Object)sendResult, (Object)request.getWechatParams());
                    return true;
                }
            }
            catch (Exception e) {
                log.warn("send by wechat catch error:", (Throwable)e);
            }
        }
        if (!sendResult && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getSmsContent()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getMobile()})) {
            log.info("try to send msg by sms mobile:{},content:{}", (Object)request.getMobile(), (Object)request.getSmsContent());
            SmsMessageType msgType = request.getSmsMsgType();
            if (msgType == null) {
                msgType = SmsMessageType.TIANXIAO_NOTIFY;
            }
            if (request.isCountSms()) {
                try {
                    TxSmsCount smsCount = this.txSmsCountDao.decreaseSmsCount(request.getOrgId());
                    log.info("send sms left sms count:{}", (Object)smsCount);
                }
                catch (Exception e) {
                    log.warn("sms count is not enough:", (Throwable)e);
                    return false;
                }
            }
            sendResult = this.smsService.sendSms(request.getSenderId(), request.getSenderRole().getCode(), request.getReceiverId(), request.getReceiverRole().getCode(), request.getMobile(), request.getSmsMsgType(), request.getSmsContent());
            log.info("send sms msg result:{}", (Object)sendResult);
        }
        return sendResult;
    }
}

