
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.msg.service.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.common.service.MsgSendService;
import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.msg.dao.TxSmsCountDao;
import com.baijia.tianxiao.dal.msg.po.TxSmsCount;
import com.baijia.tianxiao.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.exception.MsgSendException;
import com.baijia.tianxiao.sal.msg.service.CommonSmsService;
import com.google.common.base.Preconditions;

import lombok.extern.slf4j.Slf4j;

/**
 * @title MsgSendServiceImpl
 * @desc TODO
 * @author cxm
 * @date 2016年3月21日
 * @version 1.0
 */
@Service
@Slf4j
public class MsgSendServiceImpl implements MsgSendService {

    @Autowired(required = false)
    private WechatMsgRenderService wechatMsgSenderService;

    @Resource
    private CommonSmsService smsService;

    @Resource
    private TxSmsCountDao txSmsCountDao;

    final ExecutorService exec = Executors.newFixedThreadPool(5);

    @Override
    public boolean sendMsg(final SendMsgRequest request) throws MsgSendException {
        Preconditions.checkNotNull(request);
        Preconditions.checkArgument(request.getSenderId() != null, "sender id is null");
        Preconditions.checkArgument(request.getReceiverId() != null, "receiver id is null");
        Preconditions.checkArgument(request.getOrgId() != null, "orgId id is null");

        Preconditions.checkArgument(request.getSenderRole() != null, "senderRole id is null");
        Preconditions.checkArgument(request.getReceiverRole() != null, "receiverRole id is null");
        boolean sendResult = false;
        log.info("try to send msg by request:{}", request);
        if (StringUtils.isNoneBlank(request.getWeixinOpenId()) && request.getWechatTemplateId() != null) {
            log.info("try to send msg by wechat:{}", request.getWechatParams());
            try {
                request.getWechatParams().put("touser", request.getWeixinOpenId());
                Callable<Boolean> call = new Callable<Boolean>() {
                    @Override
                    public Boolean call() throws Exception {
                        return wechatMsgSenderService.sendMsg(request.getOrgId(),
                            wechatMsgSenderService.render(request.getWechatTemplateId(), request.getWechatParams()));
                    }
                };
                Future<Boolean> future = exec.submit(call);
                sendResult = future.get(1500, TimeUnit.MILLISECONDS); // 设置超时时间,超过这个时间任务返回
                                                                      // MARK:微信重刷token的时候经常会发生TCP握手等待,可能微信那边backlog值有点小,阻塞的情况下会导致签到的定时任务(使用SPRING
                                                                      // CRONTAB)级联阻塞.
                log.info("send msg result:{} by wechat:{}", sendResult, request.getWechatParams());
                if (sendResult) {
                    return true;
                }
            } catch (Exception e) {
                log.warn("send by wechat catch error,receiver id is:{},error is:{} ", request.getReceiverId(), e);
            }
        }
        if (!sendResult && StringUtils.isNoneBlank(request.getSmsContent())
            && StringUtils.isNoneBlank(request.getMobile())) {
            log.info("try to send msg by sms mobile:{},content:{}", request.getMobile(), request.getSmsContent());

            SmsMessageType msgType = request.getSmsMsgType();
            if (msgType == null) {
                msgType = SmsMessageType.TIANXIAO_NOTIFY;
            }
            if (request.isCountSms()) {
                try {
                    TxSmsCount smsCount = txSmsCountDao.decreaseSmsCount(request.getOrgId());
                    log.info("send sms left sms count:{}", smsCount);
                } catch (Exception e) {
                    log.warn("sms count is not enough:", e);
                    return false;
                }
            }

            sendResult = smsService.sendSms(request.getSenderId(), request.getSenderRole().getCode(),
                request.getReceiverId(), request.getReceiverRole().getCode(), request.getMobile(),
                request.getSmsMsgType(), request.getSmsContent());
            log.info("send sms msg receiver id is:{},result:{}", request.getReceiverId(), sendResult);
        }

        return sendResult;
    }

}
