/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.solr.constant.ConsultConstant;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.sal.elastic.service.TxConsultUserQueryService;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TxConsultUserQuerySeviceImpl
extends AbstractEsBaseServiceImpl
implements TxConsultUserQueryService {
    private static final Logger log = LoggerFactory.getLogger(TxConsultUserQuerySeviceImpl.class);
    @Autowired
    private CustomFieldDao customFieldDao;
    private static final Long ONE_DAY_TIME = 86400000L;
    private static final Set<String> KEYWORD_FIELD = new HashSet<String>();

    protected boolean isKeywordField(String key) {
        return KEYWORD_FIELD.contains(key);
    }

    @Override
    public List<ConsulterListDto> searchConsultFromEs(ConsulterListQueryParam param, PageDto pageDto) {
        Date end;
        Calendar calendarEnd;
        Date start;
        log.info("[ES] consult query param={}", (Object)param);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"org_id", (Object)param.getOrgId())).must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"del_status", (Object)0)).must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"student_id", (Object)0)).must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"is_consulter", (Object)1));
        if (param.getConsulterType() != ConsultConstant.INVALID) {
            if (param.getCascadeIdSet() != null && param.getCascadeIdSet().size() > 0) {
                queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"cascade_id", (Collection)param.getCascadeIdSet()));
            }
        } else if (param.getInvalidDayNum() != null) {
            // empty if block
        }
        if (param.getIsInvalid() != null) {
            queryBuilder.must((QueryBuilder)this.getMatchQuery("is_invalid", param.getIsInvalid()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getKeyFieldName()) && StringUtils.isNotBlank((CharSequence)param.getKeyword())) {
            String name = this.toEsField(param.getKeyFieldName());
            String query = param.getKeyword();
            if (name.equals("")) {
                if (param.getKeyFieldName().startsWith("customField")) {
                    String numStr = param.getKeyFieldName().replace("customField", "");
                    CustomField field = this.customFieldDao.getCustomFieldById(param.getOrgId(), Long.valueOf(Long.parseLong(numStr)));
                    Integer type = field.getType();
                    String searchNamePre = "custom_field." + numStr;
                    String searchName = "";
                    if (type == 1) {
                        searchName = searchNamePre + ".content.keyword";
                    }
                    queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)searchName, (String)("*" + query + "*")));
                }
            } else {
                if (this.isKeywordField(name)) {
                    name = name + ".keyword";
                }
                queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)name, (String)("*" + query + "*")));
            }
        }
        if (StringUtils.isBlank((CharSequence)param.getKeyFieldName()) && StringUtils.isNotBlank((CharSequence)param.getKeyword())) {
            BoolQueryBuilder shouldBuilder = QueryBuilders.boolQuery();
            shouldBuilder.should().add(this.getWildcardQuery("name.keyword", param.getKeyword()));
            if (NumberUtils.isDigits((String)param.getKeyword()) && param.getKeyword().length() >= 3) {
                shouldBuilder.should().add(this.getWildcardQuery("_mobile", param.getKeyword()));
            }
            shouldBuilder.should().add(this.getWildcardQuery("tag.keyword", param.getKeyword()));
            queryBuilder.must((QueryBuilder)shouldBuilder);
        }
        if (GenericsUtils.notNullAndEmpty((Object)param.getSex())) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"sex", (Object)param.getSex()));
        }
        if (param.getConsultStatus() != null) {
            int consultstatus = param.getConsultStatus();
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"consult_status", (Object)consultstatus));
        }
        if (GenericsUtils.notNullAndEmpty((Object)param.getLastRemindTimeState())) {
            int lastRemindTimeStatus = param.getLastRemindTimeState();
            param.setDateFieldKey("lastRemindTime");
            TimeType timeType = TimeType.getTimeTypeByCode((Integer)lastRemindTimeStatus);
            TimeRange timeRange = timeType.timeRange();
            param.setStart(timeRange.getStartTime());
            param.setEnd(timeRange.getEndTime());
        }
        if (GenericsUtils.notNullAndEmpty((Object)param.getRecentBrowseDayNum())) {
            param.setDateFieldKey("lastBrowseTime");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -7);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            start = calendar.getTime();
            calendarEnd = Calendar.getInstance();
            end = calendarEnd.getTime();
            param.setStart(start);
            param.setEnd(end);
        }
        if (GenericsUtils.notNullAndEmpty((Object)param.getRemindDayNum())) {
            param.setDateFieldKey("lastRemindTime");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -7);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            start = calendar.getTime();
            calendarEnd = Calendar.getInstance();
            end = calendarEnd.getTime();
            param.setStart(start);
            param.setEnd(end);
        }
        if (GenericsUtils.notNullAndEmpty((Object)param.getMinRemainingDay()) || GenericsUtils.notNullAndEmpty((Object)param.getMaxRemainingDay())) {
            param.setDateFieldKey("FinallyHoldTime");
            if (GenericsUtils.notNullAndEmpty((Object)param.getMinRemainingDay()) && param.getMinRemainingDay() == 1) {
                param.setMinRemainingDay("0");
            }
            Date date = new Date();
            if (GenericsUtils.notNullAndEmpty((Object)param.getMinRemainingDay())) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateUtil.getStartOfDayAccurateToMillSeconde((Date)date));
                calendar.add(5, param.getMinRemainingDay());
                Date start2 = calendar.getTime();
                param.setStart(start2);
            }
            Calendar calendarEnd2 = Calendar.getInstance();
            calendarEnd2.setTime(DateUtil.getStartOfDayAccurateToMillSeconde((Date)date));
            calendarEnd2.add(5, param.getMaxRemainingDay() + 1);
            Date end2 = calendarEnd2.getTime();
            if (GenericsUtils.isNullOrEmpty((Object)param.getMinRemainingDay())) {
                param.setStart(new Date(0L));
            }
            param.setEnd(end2);
        }
        if (param.getDateFieldKey() != null) {
            String dateFieldKey = ClientUtils.escapeQueryChars((String)param.getDateFieldKey());
            String keyFieldName = this.toEsField(dateFieldKey);
            if (!keyFieldName.equals("")) {
                queryBuilder.must((QueryBuilder)this.getTimestampRangeQueryBuilder(keyFieldName, param.getStart(), param.getEnd()));
            } else {
                String customDateKey = "custom_field." + param.getDateFieldKey().replace("customField", "") + ".content";
                queryBuilder.must((QueryBuilder)this.getTimestampRangeQueryBuilder(customDateKey, param.getStart(), param.getEnd()));
            }
        }
        if (param.getConsultSource() != null) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"consult_source", (Object)param.getConsultSource()));
        }
        if (GenericsUtils.notNullAndEmpty((Object)param.getCascadeForSearch())) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cascade_id", (Object)param.getCascadeForSearch()));
        }
        if (GenericsUtils.notNullAndEmpty((Object)param.getIntentLevel())) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"intension_level", (Object)param.getIntentLevel()));
        }
        if (param.getBirthMonth() != null && param.getBirthMonth() > 0) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"birthMonth", (Object)param.getBirthMonth()));
        }
        if (param.getBirthDayOfMonth() != null && param.getBirthDayOfMonth() > 0) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"birthDayOfMonth", (Object)param.getBirthDayOfMonth()));
        }
        if (param.getBirthYear() != null && param.getBirthYear() > 0) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"birthYear", (Object)param.getBirthYear()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSelectFieldKey()) && param.getSelectFieldValue() != null) {
            String selectKey = param.getSelectFieldKey().replace("customField", "");
            queryBuilder = queryBuilder.must((QueryBuilder)this.getMatchQuery(this.getCustomFieldKey(selectKey, param.getOrgId()), param.getSelectFieldValue()));
        }
        SortBuilder sortBuilder = null;
        sortBuilder = param.isPinyinSort() ? SortBuilders.fieldSort((String)"pinyin.keyword").order(SortOrder.ASC) : SortBuilders.fieldSort((String)"last_remind_time").order(SortOrder.DESC);
        if (GenericsUtils.notNullAndEmpty((Object)param.getPropName())) {
            String orderName = this.toEsField(param.getPropName());
            if (orderName.equals("pinyin")) {
                orderName = orderName + ".keyword";
            }
            if (param.getSortType() == 0) {
                sortBuilder = SortBuilders.fieldSort((String)orderName).order(SortOrder.ASC);
            }
            if (param.getSortType() == 1) {
                sortBuilder = SortBuilders.fieldSort((String)orderName).order(SortOrder.DESC);
            }
        }
        log.info("[ES] consult user query param={}", (Object)queryBuilder.toString());
        SearchResponse searchResponse = (SearchResponse)this.getClient().prepareSearch(new String[]{"consult_users"}).setTypes(new String[]{"consult_user"}).setQuery((QueryBuilder)queryBuilder).addSort(sortBuilder).setFrom((pageDto.getPageNum() - 1) * pageDto.getPageSize()).setSize(pageDto.getPageSize().intValue()).execute().actionGet();
        SearchHits hits = searchResponse.getHits();
        log.info("[ES] consult query size={}", (Object)hits.getTotalHits());
        pageDto.setCount(Integer.valueOf((int)hits.getTotalHits()));
        SearchHit[] searchHits = hits.hits();
        ArrayList<ConsulterListDto> list = new ArrayList<ConsulterListDto>();
        for (SearchHit hit : searchHits) {
            String consultJson = hit.getSourceAsString();
            try {
                Map consultMap = (Map)JacksonUtil.str2Obj((String)consultJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
                ConsulterListDto consulterListDto = this.mapToConsult(consultMap);
                list.add(consulterListDto);
            }
            catch (IOException e) {
                log.error("json transport fail{}", (Object)consultJson);
            }
        }
        return list;
    }

    private String toEsField(String fieldname) {
        if (fieldname.equals("name")) {
            return "name";
        }
        if (fieldname.equals("mobile")) {
            return "_mobile";
        }
        if (fieldname.equals("parentName")) {
            return "_parent_name";
        }
        if (fieldname.equals("parentMobile")) {
            return "_parent_mobile";
        }
        if (fieldname.equals("tag")) {
            return "tag";
        }
        if (fieldname.equals("nextRemindTime")) {
            return "next_remind_time";
        }
        if (fieldname.equals("lastFollowTime")) {
            return "last_follow_time";
        }
        if (fieldname.equals("createTime")) {
            return "create_time";
        }
        if (fieldname.equals("updateTime")) {
            return "update_time";
        }
        if (fieldname.equals("birthday")) {
            return "birthday";
        }
        if (fieldname.equals("intensionLevelStr")) {
            return "intension_level";
        }
        if (fieldname.equals("cascadeId")) {
            return "cascade_id";
        }
        if (fieldname.equals("cascadeIdStr")) {
            return "cascade_id";
        }
        if ("birthdayStr".equals(fieldname)) {
            return "birthday";
        }
        if ("createTimeStr".equals(fieldname)) {
            return "create_time";
        }
        if ("lastRemindTime".equals(fieldname)) {
            return "last_remind_time";
        }
        if ("lastRemindTimeStr".equals(fieldname)) {
            return "last_remind_time";
        }
        if ("lastBrowseTime".equals(fieldname)) {
            return "last_browse_time";
        }
        if ("FinallyHoldTime".equals(fieldname)) {
            return "finally_hold_time";
        }
        return "";
    }

    private ConsulterListDto mapToConsult(Map map) {
        String finallyHoldTimeStr;
        String lastFollowTime;
        String nextRemindTime;
        String lastRemindTime;
        ConsulterListDto consulterListDto = new ConsulterListDto();
        if (GenericsUtils.notNullAndEmpty(map.get("_mobile"))) {
            consulterListDto.setMobile(map.get("_mobile").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("cascade_id"))) {
            consulterListDto.setCascadeId(Integer.valueOf(Integer.parseInt(map.get("cascade_id").toString())));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("address"))) {
            consulterListDto.setAddress(map.get("address").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("birthday"))) {
            String birth = map.get("birthday").toString();
            Long birthNum = Long.parseLong(birth);
            Date birthday = null;
            if (birthNum > 0L) {
                birthday = new Date(Long.parseLong(birth));
            }
            consulterListDto.setBirthday(birthday);
        }
        if (GenericsUtils.notNullAndEmpty(map.get("consult_source"))) {
            consulterListDto.setConsultSource(Integer.valueOf(Integer.parseInt(map.get("consult_source").toString())));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("consult_status"))) {
            consulterListDto.setConsultStatus(Integer.valueOf(Integer.parseInt(map.get("consult_status").toString())));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("create_time"))) {
            String createTime = map.get("create_time").toString();
            consulterListDto.setCreateTime(new Date(Long.parseLong(createTime)));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("degree_class"))) {
            consulterListDto.setDegreeClass(map.get("degree_class").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("id"))) {
            consulterListDto.setId(Long.valueOf(Long.parseLong(map.get("id").toString())));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("intension_level"))) {
            consulterListDto.setIntensionLevel(Integer.valueOf(Integer.parseInt(map.get("intension_level").toString())));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("is_invalid"))) {
            consulterListDto.setIsInvalid(Integer.valueOf(Integer.parseInt(map.get("is_invalid").toString())));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("mail"))) {
            consulterListDto.setMail(map.get("mail").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("name"))) {
            consulterListDto.setName(map.get("name").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("last_remind_time")) && Long.parseLong(lastRemindTime = map.get("last_remind_time").toString()) > 0L) {
            consulterListDto.setLastRemindTime(new Date(Long.parseLong(lastRemindTime)));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("next_remind_time")) && Long.parseLong(nextRemindTime = map.get("next_remind_time").toString()) > 0L) {
            consulterListDto.setNextRemindTime(new Date(Long.parseLong(nextRemindTime)));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("last_follow_time")) && Long.parseLong(lastFollowTime = map.get("last_follow_time").toString()) > 0L) {
            consulterListDto.setLastFollowTime(new Date(Long.parseLong(lastFollowTime)));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("finally_hold_time")) && Long.parseLong(finallyHoldTimeStr = map.get("finally_hold_time").toString()) > 0L) {
            Date finallyHoldTime = new Date(Long.parseLong(finallyHoldTimeStr));
            Integer lessDayNum = 0;
            Date now = new Date();
            if (finallyHoldTime != null && finallyHoldTime.after(now) && (lessDayNum = DateUtil.getStartOfDayAccurateToMillSeconde((Date)finallyHoldTime).equals(DateUtil.getStartOfDayAccurateToMillSeconde((Date)now)) ? Integer.valueOf(1) : Integer.valueOf((int)((DateUtil.getStartOfDayAccurateToMillSeconde((Date)finallyHoldTime).getTime() - DateUtil.getStartOfDayAccurateToMillSeconde((Date)now).getTime()) / ONE_DAY_TIME))) == 0) {
                lessDayNum = 1;
            }
            log.info("lessDayNum is : {} for finallyHoldTime : {} ", (Object)lessDayNum, (Object)finallyHoldTime);
            consulterListDto.setTimeRemaining(lessDayNum);
        }
        if (GenericsUtils.notNullAndEmpty(map.get("update_time"))) {
            String updateTime = map.get("update_time").toString();
            consulterListDto.setUpdateTime(new Date(Long.parseLong(updateTime)));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("_parent_mobile"))) {
            consulterListDto.setParentMobile(map.get("_parent_mobile").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("_parent_name"))) {
            consulterListDto.setParentName(map.get("_parent_name").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("qq"))) {
            consulterListDto.setQq(map.get("qq").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("relatives"))) {
            consulterListDto.setRelatives(Integer.valueOf(Integer.parseInt(map.get("relatives").toString())));
        }
        if (GenericsUtils.notNullAndEmpty(map.get("school"))) {
            consulterListDto.setSchool(map.get("school").toString());
        }
        if (GenericsUtils.notNullAndEmpty(map.get("sex"))) {
            consulterListDto.setSex(Integer.valueOf(Integer.parseInt(map.get("sex").toString())));
        }
        return consulterListDto;
    }

    static {
        KEYWORD_FIELD.add("parent_name");
        KEYWORD_FIELD.add("tag");
        KEYWORD_FIELD.add("_parent_name");
        KEYWORD_FIELD.add("school");
        KEYWORD_FIELD.add("name");
    }
}

