/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.UserLastFollowTime;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.elastic.service.StudentDataImportService;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentDataImportServiceImpl
extends AbstractEsBaseServiceImpl
implements StudentDataImportService {
    private static final Logger log = LoggerFactory.getLogger(StudentDataImportServiceImpl.class);
    @Autowired
    private OrgStudentDao studentDao;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TxStudentTagDao tagDao;
    @Autowired
    private OrgStudentLessonDao lessonDao;
    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private TxStudentFinanceAccountDao studentFinanceAccountDao;
    @Autowired
    private TxStudentCommentDao studentCommentDao;

    @Override
    public void fullImport() {
        this.importByOrgId(null);
    }

    @Override
    public void importByOrgId(Long orgId) {
        long time = System.currentTimeMillis();
        BulkProcessor bulkProcessor = this.getDefaultBulkProcessor();
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(3000));
        List students = null;
        students = orgId == null ? this.studentDao.getByPage(page, new String[0]) : this.studentDao.getOrgStudentByPage(orgId, page);
        while (students.size() > 0) {
            this.fillBulkData(orgId, students, bulkProcessor);
            page.setPageNum(Integer.valueOf(page.getPageNum() + 1));
            students = orgId == null ? this.studentDao.getByPage(page, new String[0]) : this.studentDao.getOrgStudentByPage(orgId, page);
            log.info("import page={}", (Object)page);
        }
        log.info("import {} data costs:{}", (Object)page.getCount(), (Object)(System.currentTimeMillis() - time));
    }

    private void fillBulkData(long orgId, List<OrgStudent> students, BulkProcessor bulkProcessor) {
        if (students == null || students.size() < 1) {
            log.warn("[ES] students is null.orgId={}", (Object)orgId);
            return;
        }
        List studentIds = ListUtil.toKeyList(students, (String)"id", OrgStudent.class);
        List userIds = ListUtil.toKeyList(students, (String)"userId", OrgStudent.class);
        List accounts = this.studentFinanceAccountDao.listFinanceAccount(Long.valueOf(orgId), (Collection)studentIds);
        Map accountMap = CollectionHelper.toKeyMap((Collection)accounts, (String)"studentId");
        Map kexiaoStatMap = this.kexiaoApiService.queryUserKexiaoStat(Long.valueOf(orgId), (Collection)userIds);
        Map valueMap = this.customFieldValueDao.batchGetValueMap(null, true, (Collection)studentIds, null);
        List tags = this.tagDao.getTags((Collection)userIds, null, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), null);
        Map<Long, List<TxStudentTag>> studentTags = this.toMap(tags, StudentType.ORG_STUDENTS);
        Set scheduleUserIds = this.lessonDao.hasScheduleLesson((Collection)userIds);
        Set refundUserIds = this.signupCourseDao.hasRefund((Collection)userIds);
        for (OrgStudent student : students) {
            Map<String, Object> map = this.studentToMap(student, (List)valueMap.get(student.getId()), studentTags.get(student.getUserId()), (KexiaoStudentStat)kexiaoStatMap.get(student.getUserId()), (TxStudentFinanceAccount)accountMap.get(student.getId()));
            if (scheduleUserIds.contains(student.getUserId())) {
                map.put("scheduleStatus", 1);
            } else {
                map.put("scheduleStatus", 2);
            }
            if (refundUserIds.contains(student.getUserId())) {
                map.put("refundClassStatus", 1);
            } else {
                map.put("refundClassStatus", 2);
            }
            bulkProcessor.add(((IndexRequest)new IndexRequest().index("students")).type("student").source(map).id(student.getId().toString()));
        }
    }

    @Override
    public void importByOrgIdAndUpdateTime(Long orgId, int beforeHour) {
        long time = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, beforeHour);
        List students = this.studentDao.listByUpdateTime(orgId, calendar.getTime());
        BulkProcessor bulkProcessor = this.getDefaultBulkProcessor();
        this.fillBulkData(orgId, students, bulkProcessor);
        log.info("[ES] Import {} data costs:{}", (Object)students.size(), (Object)(System.currentTimeMillis() - time));
    }

    @Override
    public void batchImport(Long orgId, Collection<Long> studentIds) {
        log.info("[ES] batch import studentIds={},orgId={}", studentIds, (Object)orgId);
        if (studentIds == null || studentIds.size() < 1) {
            return;
        }
        long time = System.currentTimeMillis();
        List students = this.studentDao.getByIds(studentIds, new String[0]);
        BulkProcessor bulkProcessor = this.getDefaultBulkProcessor();
        this.fillBulkData(orgId, students, bulkProcessor);
        log.info("[ES] BatchImport {} data costs:{}", (Object)students.size(), (Object)(System.currentTimeMillis() - time));
    }

    @Override
    public void batchImportByUserIds(Long orgId, Collection<Long> userIds) {
        log.info("[ES] batch import userIds={},orgId={}", userIds, (Object)orgId);
        if (userIds == null || userIds.size() < 1) {
            return;
        }
        long time = System.currentTimeMillis();
        List students = this.studentDao.getStudentByUserIds(orgId, userIds, new String[0]);
        BulkProcessor bulkProcessor = this.getDefaultBulkProcessor();
        this.fillBulkData(orgId, students, bulkProcessor);
        log.info("[ES] BatchImport {} data costs:{}", (Object)students.size(), (Object)(System.currentTimeMillis() - time));
    }

    @Override
    public void saveOrUpdateStudentById(Long studentId) {
        log.info("[ES] update studentId={}", (Object)studentId);
        OrgStudent student = (OrgStudent)this.studentDao.getById((Serializable)studentId, new String[0]);
        int i = 1;
        while (student == null && i <= 10) {
            try {
                Thread.sleep(i * 5 * 1000);
                student = (OrgStudent)this.studentDao.getById((Serializable)studentId, new String[0]);
                log.warn("[ES] Retry count={},studentId={}", (Object)(++i), (Object)studentId);
            }
            catch (InterruptedException e) {
                log.error("[ES] InterruptedException error={}", (Throwable)e);
            }
        }
        if (student == null) {
            log.error("[ES] studentId={} is not exist", (Object)studentId);
            return;
        }
        this.saveOrUpdateStudent(student);
    }

    @Override
    public void saveOrUpdateStudentByUserId(Long orgId, Long userId) {
        OrgStudent student = this.studentDao.getStudentByUserId(orgId, userId, new String[0]);
        int i = 1;
        while (student == null && i <= 10) {
            try {
                Thread.sleep(i * 5 * 1000);
                student = this.studentDao.getStudentByUserId(orgId, userId, new String[0]);
                log.warn("[ES] Retry count={},userId={},orgId={}", new Object[]{++i, userId, orgId});
            }
            catch (InterruptedException e) {
                log.error("[ES] InterruptedException error={}", (Throwable)e);
            }
        }
        if (student == null) {
            log.error("[ES] orgId={},userId={} is not exist", (Object)orgId, (Object)userId);
            return;
        }
        this.saveOrUpdateStudent(student);
    }

    @Override
    public void importLastFollowTime() {
        long time = System.currentTimeMillis();
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(3000));
        List data = this.studentCommentDao.getLastFollowComment(page, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()));
        while (data.size() > 0) {
            for (UserLastFollowTime user : data) {
                OrgStudent student = this.studentDao.getStudent(user.getOrgId(), user.getId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
                if (student == null) continue;
                student.setLastFollowTime(user.getLastFollowTime());
                this.studentDao.update((Object)student, new String[]{"lastFollowTime"});
            }
            page.setCount(Integer.valueOf((page.getPageNum() - 1) * page.getPageSize() + data.size()));
            page.setPageNum(Integer.valueOf(page.getPageNum() + 1));
            data = this.studentCommentDao.getLastFollowComment(page, Integer.valueOf(StudentType.ORG_STUDENTS.getCode()));
        }
        log.info("import {} data costs:{}", (Object)page.getCount(), (Object)(System.currentTimeMillis() - time));
    }

    private void saveOrUpdateStudent(OrgStudent student) {
        log.info("[ES] update student={},userId={}", (Object)student.getId(), (Object)student.getUserId());
        DeleteResponse deleteresponse = (DeleteResponse)this.getClient().prepareDelete("students", "student", String.valueOf(student.getId())).execute().actionGet();
        Map valueMap = this.customFieldValueDao.batchGetValueMap(student.getOrgId(), true, Arrays.asList(student.getId()), null);
        List tags = this.tagDao.getTags(student.getUserId(), student.getOrgId(), Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), new String[0]);
        List<Long> userIds = Arrays.asList(student.getUserId());
        Map kexiaoStatMap = this.kexiaoApiService.queryUserKexiaoStat(student.getOrgId(), userIds);
        TxStudentFinanceAccount account = this.studentFinanceAccountDao.getFinanceAccount(student.getOrgId(), student.getId());
        Map<String, Object> map = this.studentToMap(student, (List)valueMap.get(student.getId()), tags, (KexiaoStudentStat)kexiaoStatMap.get(student.getUserId()), account);
        Set scheduleUserIds = this.lessonDao.hasScheduleLesson(userIds);
        if (scheduleUserIds.contains(student.getUserId())) {
            map.put("scheduleStatus", 1);
        } else {
            map.put("scheduleStatus", 2);
        }
        Set refundUserIds = this.signupCourseDao.hasRefund(userIds);
        if (refundUserIds.contains(student.getUserId())) {
            map.put("refundClassStatus", 1);
        } else {
            map.put("refundClassStatus", 2);
        }
        this.getClient().prepareIndex("students", "student").setSource(map).setId(student.getId().toString()).execute().actionGet();
    }

    private Map<String, Object> studentToMap(OrgStudent student, List<CustomFieldValue> customFieldValues, List<TxStudentTag> tags, KexiaoStudentStat stat, TxStudentFinanceAccount account) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", student.getId());
        map.put("user_id", student.getUserId());
        map.put("org_id", student.getOrgId());
        map.put("name", student.getName());
        map.put("mobile", student.getMobile());
        map.put("weixin", student.getWeixin());
        map.put("lesson_status", student.getLessonStatus());
        map.put("add_cascade_id", student.getAddCascadeId());
        map.put("parent_name", student.getParentName());
        map.put("parent_mobile", student.getParentMobile());
        map.put("source", student.getSource());
        String pinyin = HanZiPinYinUtils.getLowerCasePinYin((String)student.getName());
        if (StringUtils.isNotBlank((CharSequence)pinyin)) {
            char init = pinyin.charAt(0);
            if (init < 'a' || init > 'z') {
                pinyin = "~";
            }
        } else {
            pinyin = "~";
        }
        map.put("pinyin", pinyin);
        map.put("gender", student.getGender());
        map.put("del_status", student.getDelStatus());
        map.put("avatar", student.getAvatar());
        map.put("create_time", student.getCreateTime().getTime());
        map.put("update_time", student.getUpdateTime().getTime());
        map.put("show_time", student.getCreateTime().getTime());
        if (student.getNextRemindTime() != null) {
            map.put("next_remind_time", student.getNextRemindTime().getTime());
        }
        if (student.getLastRemindTime() != null) {
            map.put("last_remind_time", student.getLastRemindTime().getTime());
        }
        if (student.getLastFollowTime() != null) {
            map.put("last_follow_time", student.getLastFollowTime().getTime());
        }
        HashMap<String, Map> customFieldMap = new HashMap<String, Map>();
        if (customFieldValues != null) {
            for (CustomFieldValue value : customFieldValues) {
                try {
                    Map valueMap = (Map)JacksonUtil.str2Obj((String)value.getValue(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    customFieldMap.put(value.getFieldId().toString(), valueMap);
                }
                catch (IOException e) {
                    log.error("IOException = {}", (Throwable)e);
                }
            }
        }
        map.put("custom_field", customFieldMap);
        String tagStr = "";
        if (tags != null && tags.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (TxStudentTag tag : tags) {
                sb.append(",").append(tag.getContent());
            }
            tagStr = sb.substring(1);
        }
        map.put("tag", tagStr);
        if (student.getBirthday() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(student.getBirthday());
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            map.put("birthday", student.getBirthday().getTime());
            map.put("birthDayOfMonth", calendar.get(5));
            map.put("birthMonth", calendar.get(2) + 1);
            map.put("birthYear", calendar.get(1));
        } else {
            map.put("birthday", -1);
            map.put("birthDayOfMonth", -1);
            map.put("birthMonth", -1);
            map.put("birthYear", -1);
        }
        if (StringUtils.isNotBlank((CharSequence)student.getWeixin())) {
            map.put("stuCenterBindStatus", 1);
        } else {
            map.put("stuCenterBindStatus", 2);
        }
        if (stat != null) {
            if (stat.getCompleteStatus() == 0) {
                map.put("leftAmount", stat.getLeftAmount());
                map.put("arrangeTime", stat.getArrangeNormalTime() + stat.getArrangeFreeTime());
                map.put("kexiaoTime", stat.getKexiaoNormalTime() + stat.getKexiaoFreeTime());
                map.put("totalTime", stat.getTotalTime());
                map.put("leftTime", stat.getTotalTime() - (stat.getKexiaoNormalTime() + stat.getKexiaoFreeTime()));
                map.put("arrangeCount", stat.getArrangeNormalCount() + stat.getArrangeFreeCount());
                map.put("kexiaoCount", stat.getKexiaoNormalCount() + stat.getKexiaoFreeCount());
                map.put("totalCount", stat.getTotalCount());
                map.put("leftCount", stat.getTotalCount() - (stat.getKexiaoNormalCount() + stat.getKexiaoFreeCount()));
            } else {
                map.put("leftAmount", -1);
                map.put("arrangeTime", -1);
                map.put("kexiaoTime", -1);
                map.put("totalTime", -1);
                map.put("leftTime", -1);
                map.put("arrangeCount", -1);
                map.put("kexiaoCount", -1);
                map.put("totalCount", -1);
                map.put("leftCount", -1);
            }
        } else {
            map.put("leftAmount", 0);
            map.put("arrangeTime", 0);
            map.put("kexiaoTime", 0);
            map.put("totalTime", 0);
            map.put("leftTime", 0);
            map.put("arrangeCount", 0);
            map.put("kexiaoCount", 0);
            map.put("totalCount", 0);
            map.put("leftCount", 0);
        }
        if (account != null) {
            map.put("banlance", account.getBalance());
        } else {
            map.put("banlance", 0);
        }
        return map;
    }
}

