/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.sal.elastic.service.OrgTeacherDocumentQueryService;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherDocumentQueryServiceImpl
extends AbstractEsBaseServiceImpl
implements OrgTeacherDocumentQueryService {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherDocumentQueryServiceImpl.class);

    @Override
    public List<Long> quertTeacherUserIds(Long orgId, String name) {
        BoolQueryBuilder builder = new BoolQueryBuilder();
        builder.must((QueryBuilder)new TermQueryBuilder("orgId", (Object)orgId));
        builder.must((QueryBuilder)this.getWildcardQuery("name.keyword", name));
        SearchRequestBuilder srq = this.getClient().prepareSearch(new String[]{"teachers"}).setTypes(new String[]{"teacher"}).setQuery((QueryBuilder)new ConstantScoreQueryBuilder((QueryBuilder)builder)).setSize(10000);
        ArrayList result = Lists.newArrayList();
        SearchResponse response = (SearchResponse)srq.execute().actionGet();
        for (SearchHit searchHit : response.getHits().getHits()) {
            result.add(Long.parseLong(searchHit.getSource().get("teacherUserId").toString()));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> listByQuery(Integer orgId, Integer useStatus, Integer countType, Integer orderType, String searchKey, PageDto pageDto) {
        if (pageDto == null) {
            pageDto = new PageDto();
            pageDto.setPageNum(Integer.valueOf(1));
            pageDto.setPageSize(Integer.valueOf(100));
        }
        log.info("es with params -- orgID:{}", (Object)orgId);
        BoolQueryBuilder builder = new BoolQueryBuilder();
        builder.must((QueryBuilder)new TermQueryBuilder("orgId", (Object)orgId));
        if (useStatus != null) {
            builder.must((QueryBuilder)new TermQueryBuilder("useStatus", (Object)useStatus));
        } else {
            builder.must((QueryBuilder)new TermsQueryBuilder("useStatus", Lists.newArrayList((Object[])new Integer[]{0, 1}).toArray()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            builder.must((QueryBuilder)new BoolQueryBuilder().should((QueryBuilder)this.getWildcardQuery("name.keyword", searchKey)).should((QueryBuilder)this.getWildcardQuery("mobile.keyword", searchKey)));
        }
        String sortValue = this.getSolrRule(countType);
        SearchRequestBuilder srq = this.getClient().prepareSearch(new String[]{"teachers"}).setTypes(new String[]{"teacher"}).setQuery((QueryBuilder)new ConstantScoreQueryBuilder((QueryBuilder)builder)).addSort(sortValue, null != orderType && orderType == 2 ? SortOrder.DESC : SortOrder.ASC).setFrom(pageDto.firstNum()).setSize(pageDto.getPageSize().intValue());
        SearchResponse response = (SearchResponse)srq.execute().actionGet();
        SearchHits hits = response.getHits();
        pageDto.setCount(Integer.valueOf((int)hits.getTotalHits()));
        ArrayList mapList = Lists.newArrayList();
        for (SearchHit hit : hits.getHits()) {
            Map val = hit.getSource();
            mapList.add(val);
        }
        log.info("search result size is :{} ", (Object)mapList.size());
        return mapList;
    }

    public String getSolrRule(Integer countType) {
        String field;
        switch (countType) {
            case 0: {
                field = "createTime";
                break;
            }
            case 1: {
                field = "finishedClassTime";
                break;
            }
            case 2: {
                field = "hasSignupStudentCount";
                break;
            }
            case 3: {
                field = "scoreNum";
                break;
            }
            case 4: {
                field = "pauseTime";
                break;
            }
            default: {
                field = "createTime";
            }
        }
        return field;
    }

    @Override
    public List<Map<String, Object>> queryOrgTeachersWithIds(Integer orgId, Collection<Long> teacherIds, Boolean ... isIdQuery) {
        boolean isId = GenericsUtils.notNullAndEmpty((Object)isIdQuery) ? isIdQuery[0] : true;
        String queryField = isId ? "orgTeacherId" : "teacherUserId";
        SearchRequestBuilder srq = this.getClient().prepareSearch(new String[]{"teachers"}).setTypes(new String[]{"teacher"}).setQuery((QueryBuilder)new ConstantScoreQueryBuilder((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new TermQueryBuilder("orgId", (Object)orgId)).must((QueryBuilder)new TermsQueryBuilder(queryField, teacherIds.toArray()))));
        SearchResponse response = (SearchResponse)srq.execute().actionGet();
        SearchHits hits = response.getHits();
        ArrayList mapList = Lists.newArrayList();
        for (SearchHit hit : hits.getHits()) {
            Map val = hit.getSource();
            mapList.add(val);
        }
        return mapList;
    }
}

