/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.solr.dto.OrgTeacherDocument;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sal.elastic.service.OrgTeacherDocumentImportService;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ThreeTuple;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgTeacherDocumentImportServiceImpl
extends AbstractEsBaseServiceImpl
implements OrgTeacherDocumentImportService {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherDocumentImportServiceImpl.class);
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;

    @Override
    public Map<Long, OrgTeacherDocument> createOrgTeacherDocuments(Long orgId, Collection<OrgTeacher> orgTeachers, Date beginDate, Date endDate, boolean isSaveOrUpdate, boolean immediate) {
        if (GenericsUtils.isNullOrEmpty(orgTeachers)) {
            log.info(" empty OrgTeacher  :{} ", orgTeachers);
            return GenericsUtils.emptyMap();
        }
        Set teacherUserIds = orgTeachers.stream().map(orgTeacher -> orgTeacher.getUserId()).collect(Collectors.toSet());
        List teachers = null;
        try {
            teachers = this.teacherDao.getByUserIds(teacherUserIds, new String[0]);
        }
        catch (Exception e) {
            log.error("error :{} ", (Throwable)e);
        }
        if (GenericsUtils.isNullOrEmpty((Object)teachers)) {
            log.info(" can not find any teacher with teacherUserIds :{} ", teacherUserIds);
            return GenericsUtils.emptyMap();
        }
        Map teacherMap = CollectorUtil.collectMap((Collection)teachers, input -> input.getUserId());
        String dataMonth = DateUtil.getCurrentYM((Long)beginDate.getTime());
        HashMap orgTeacherDocumentMap = Maps.newHashMap();
        Map scoreMap = this.orgLessonCommentDao.getAveCommentByTeacherIds(teacherUserIds, new String[0]);
        Map teacherLessonIds = this.orgTeacherLessonDao.divideTeacherLessonIds((List)Lists.newArrayList(teacherUserIds), beginDate, endDate);
        HashMap classTimeInfos = Maps.newHashMap();
        HashMap lessonIdMap = Maps.newHashMap();
        for (Map.Entry entry : teacherLessonIds.entrySet()) {
            Long teacherId = (Long)entry.getKey();
            List values = (List)entry.getValue();
            if (!GenericsUtils.notNullAndEmpty((Object)values)) continue;
            for (ThreeTuple value : values) {
                Long lessonId = (Long)value.first;
                Integer finishClassTime = (Integer)value.second;
                Integer arrangeClassTime = (Integer)value.three;
                if (!classTimeInfos.containsKey(teacherId)) {
                    TwoTuple classTimeTuple = TupleUtil.tuple((Object)finishClassTime, (Object)arrangeClassTime);
                    classTimeInfos.put(teacherId, classTimeTuple);
                } else {
                    TwoTuple twoTuple = (TwoTuple)classTimeInfos.get(teacherId);
                    Integer finishClassTimeSum = (Integer)twoTuple.first;
                    Integer arrangeClassTimeSum = (Integer)twoTuple.second;
                    twoTuple = TupleUtil.tuple((Object)(finishClassTime + finishClassTimeSum), (Object)(arrangeClassTime + arrangeClassTimeSum));
                    classTimeInfos.put(teacherId, twoTuple);
                }
                List<Long> finishLessonIds = null;
                List<Long> arrangeLessonIds = null;
                if (!lessonIdMap.containsKey(teacherId)) {
                    finishLessonIds = Lists.newArrayList();
                    arrangeLessonIds = Lists.newArrayList();
                    TwoTuple tuple = TupleUtil.tuple((Object)finishLessonIds, (Object)arrangeLessonIds);
                    lessonIdMap.put(teacherId, tuple);
                } else {
                    TwoTuple twoTuple = (TwoTuple)lessonIdMap.get(teacherId);
                    finishLessonIds = (List)twoTuple.first;
                    arrangeLessonIds = (List)twoTuple.second;
                }
                arrangeLessonIds.add(lessonId);
                if (finishClassTime <= 0) continue;
                finishLessonIds.add(lessonId);
            }
        }
        Map<Long, TwoTuple<Integer, Integer>> teacherStudentCountMap = this.findTeacherStudentCountInfoMap(lessonIdMap);
        HashMap teacherClassTimeMap = classTimeInfos;
        for (OrgTeacher orgTeacher2 : orgTeachers) {
            TwoTuple<Integer, Integer> studentCountInfo;
            Long userId = orgTeacher2.getUserId();
            Teacher teacher = (Teacher)teacherMap.get(userId);
            OrgTeacherDocument otd = OrgTeacherDocument.newInstance((Long)orgTeacher2.getId(), (String)dataMonth);
            otd.setOrgId(orgTeacher2.getOrgId());
            otd.setAvatarStorageId(teacher.getAvatar());
            otd.setCreateTime(Long.valueOf(teacher.getCreatedAt().getTime()));
            otd.setDataMonth(dataMonth);
            otd.setMobile(orgTeacher2.getMobile());
            otd.setName(teacher.getRealName());
            Long score = (Long)scoreMap.get(userId);
            otd.setScoreNum(score == null ? 0L : score);
            otd.setOrgTeacherId(orgTeacher2.getId());
            otd.setTeacherUserId(userId);
            otd.setUseStatus(orgTeacher2.getUseStatus());
            if (orgTeacher2.getStatus().intValue() == OrgTeacherStatus.TERMINATED.getCode()) {
                otd.setUseStatus(Integer.valueOf(2));
            }
            if (orgTeacher2.isInUse()) {
                otd.setPauseTime(null);
            } else {
                otd.setPauseTime(Long.valueOf(orgTeacher2.getUpdateTime() == null ? System.currentTimeMillis() : orgTeacher2.getUpdateTime().getTime()));
            }
            TwoTuple classTimeInfo = (TwoTuple)teacherClassTimeMap.get(userId);
            if (classTimeInfo != null) {
                Integer finishedClassTime = (Integer)classTimeInfo.first;
                Integer arrangeClassTime = (Integer)classTimeInfo.second;
                otd.setFinishedClassTime(finishedClassTime);
                otd.setArrangeClassTime(arrangeClassTime);
            }
            if ((studentCountInfo = teacherStudentCountMap.get(userId)) != null) {
                Integer hasSignupStudentCount = (Integer)studentCountInfo.first;
                Integer arrangeStudentCount = (Integer)studentCountInfo.second;
                otd.setArrangeStudentCount(arrangeStudentCount);
                otd.setHasSignupStudentCount(hasSignupStudentCount);
            }
            orgTeacherDocumentMap.put(orgTeacher2.getId(), otd);
        }
        if (isSaveOrUpdate) {
            this.addNewDocument(orgTeacherDocumentMap.values(), immediate);
        }
        return orgTeacherDocumentMap;
    }

    @Override
    public Map<Long, OrgTeacherDocument> createOrgTeacherDocuments(Long orgId, List<Long> teacherUserIds, Date beginDate, Date endDate, boolean isSaveOrUpdate, boolean immediate) {
        List teacherByUserIdsAndOrgId = this.orgTeacherDao.getTeacherByUserIdsAndOrgId(orgId, teacherUserIds, null, null, new String[0]);
        return this.createOrgTeacherDocuments(orgId, teacherByUserIdsAndOrgId, beginDate, endDate, isSaveOrUpdate, immediate);
    }

    private Map<Long, TwoTuple<Integer, Integer>> findTeacherStudentCountInfoMap(Map<Long, TwoTuple<List<Long>, List<Long>>> lessonIdMaps) {
        ArrayList finishLessonIds = Lists.newArrayList();
        ArrayList arrangeLessonIds = Lists.newArrayList();
        HashMap inversionIdMap = Maps.newHashMap();
        for (Map.Entry<Long, TwoTuple<List<Long>, List<Long>>> entry : lessonIdMaps.entrySet()) {
            Long teacherId = entry.getKey();
            TwoTuple<List<Long>, List<Long>> value = entry.getValue();
            finishLessonIds.addAll((Collection)value.first);
            arrangeLessonIds.addAll((Collection)value.second);
            for (Long lessonId : (List)value.second) {
                GenericsUtils.addListIfNotExists((Map)inversionIdMap, (Object)lessonId, (Object)teacherId);
            }
        }
        Map studentCountMap = this.orgStudentLessonDao.countStudentNumsWithLessonIds((List)finishLessonIds, (List)arrangeLessonIds);
        HashMap retMap = Maps.newHashMap();
        for (Map.Entry entry : studentCountMap.entrySet()) {
            Long lessonId = (Long)entry.getKey();
            TwoTuple tupleValue = (TwoTuple)entry.getValue();
            List teacherIds = (List)inversionIdMap.get(lessonId);
            if (!GenericsUtils.notNullAndEmpty((Object)teacherIds)) continue;
            for (Long teacherId : teacherIds) {
                Integer totalStudentCount;
                Integer finishStudentCount;
                if (!retMap.containsKey(teacherId)) {
                    finishStudentCount = (Integer)tupleValue.first;
                    totalStudentCount = (Integer)tupleValue.second;
                    TwoTuple countTuple = TupleUtil.tuple((Object)finishStudentCount, (Object)totalStudentCount);
                    retMap.put(teacherId, countTuple);
                    continue;
                }
                finishStudentCount = (Integer)((TwoTuple)retMap.get((Object)teacherId)).first;
                totalStudentCount = (Integer)((TwoTuple)retMap.get((Object)teacherId)).second;
                retMap.put(teacherId, TupleUtil.tuple((Object)(finishStudentCount + (Integer)tupleValue.first), (Object)(totalStudentCount + (Integer)tupleValue.second)));
            }
        }
        return retMap;
    }

    private void addNewDocument(Collection<OrgTeacherDocument> otds, boolean immediate) {
        if (GenericsUtils.isNullOrEmpty(otds)) {
            return;
        }
        this.backupByES(otds, immediate);
    }

    private void backupByES(Collection<OrgTeacherDocument> otds, boolean immediate) {
        if (CollectionUtils.isEmpty(otds)) {
            return;
        }
        if (immediate) {
            ArrayList futures = Lists.newArrayList();
            for (OrgTeacherDocument document : otds) {
                futures.add(this.getClient().index(((IndexRequest)new IndexRequest().index("teachers")).type("teacher").source(document.convertToMap()).id(document.getOrgTeacherId().toString())));
            }
            for (ActionFuture future : futures) {
                future.actionGet();
            }
        } else {
            BulkProcessor processor = this.getDefaultBulkProcessor();
            for (OrgTeacherDocument document : otds) {
                processor.add(((IndexRequest)new IndexRequest().index("teachers")).type("teacher").source(document.convertToMap()).id(document.getOrgTeacherId().toString()));
            }
        }
        log.info("backupByES size:{} ", (Object)otds.size());
    }
}

