/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.sal.elastic.service.LessonCommentStatisticEsQueryer;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LessonCommentStatisticEsQueryerImpl
extends AbstractEsBaseServiceImpl
implements LessonCommentStatisticEsQueryer {
    private static final Logger log = LoggerFactory.getLogger(LessonCommentStatisticEsQueryerImpl.class);

    @Override
    public Long commentCountTimeRange(Long orgId, Collection<Long> lessonIds, TimeRange timeRange) {
        SearchRequestBuilder search = this.getClient().prepareSearch(new String[]{"comments"}).setTypes(new String[]{"lessoncomment"});
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must((QueryBuilder)new TermQueryBuilder("orgId", (Object)orgId)).must((QueryBuilder)new TermQueryBuilder("delStatus", 0));
        boolQueryBuilder.must((QueryBuilder)new RangeQueryBuilder("lessonStartTime").gt((Object)timeRange.getStartTime().getTime()).lte((Object)timeRange.getEndTime().getTime()));
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            boolQueryBuilder.must((QueryBuilder)new TermsQueryBuilder("lessonId", lessonIds));
        }
        search.setQuery((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)boolQueryBuilder));
        search.setSize(0);
        search.addAggregation((AggregationBuilder)AggregationBuilders.sum((String)"studentCommentCountSum").field("studentCommentCount"));
        SearchResponse response = (SearchResponse)search.execute().actionGet();
        log.debug("response:{} ", (Object)response);
        Sum studentCommentCountSum = (Sum)response.getAggregations().get("studentCommentCountSum");
        return Math.round(studentCommentCountSum.getValue());
    }

    @Override
    public Long avgScoreTimeRange(Long orgId, Collection<Long> lessonIds, TimeRange timeRange) {
        SearchRequestBuilder search = this.getClient().prepareSearch(new String[]{"comments"}).setTypes(new String[]{"lessoncomment"});
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must((QueryBuilder)new TermQueryBuilder("orgId", (Object)orgId)).must((QueryBuilder)new TermQueryBuilder("delStatus", 0));
        boolQueryBuilder.must((QueryBuilder)new RangeQueryBuilder("lessonStartTime").gt((Object)timeRange.getStartTime().getTime()).lte((Object)timeRange.getEndTime().getTime()));
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            boolQueryBuilder.must((QueryBuilder)new TermsQueryBuilder("lessonId", lessonIds));
        }
        search.setQuery((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)boolQueryBuilder));
        search.setSize(0);
        search.addAggregation((AggregationBuilder)AggregationBuilders.sum((String)"studentCommentCountSum").field("studentCommentCount"));
        search.addAggregation((AggregationBuilder)AggregationBuilders.sum((String)"studentTotalScoreSum").field("studentTotalScore"));
        SearchResponse response = (SearchResponse)search.execute().actionGet();
        log.debug("response:{} ", (Object)response);
        Sum studentCommentCountSum = (Sum)response.getAggregations().get("studentCommentCountSum");
        Sum studentTotalScoreSum = (Sum)response.getAggregations().get("studentTotalScoreSum");
        return studentCommentCountSum.getValue() > 0.0 ? Math.round(studentTotalScoreSum.getValue() / studentCommentCountSum.getValue()) : 0L;
    }
}

