/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.sal.elastic.dto.LessonCommentStatistic;
import com.baijia.tianxiao.sal.elastic.service.LessonCommentStatisticEsImporter;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LessonCommentStatisticEsImporterImpl
extends AbstractEsBaseServiceImpl
implements LessonCommentStatisticEsImporter {
    private static final Logger log = LoggerFactory.getLogger(LessonCommentStatisticEsImporterImpl.class);
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    public static final String INDEX = "comments";
    public static final String TYPE = "lessoncomment";

    @Override
    public int deleteExpiredStatisticByLessonStartTime(Date date) {
        return this.batchDeleteByQuery(INDEX, TYPE, (QueryBuilder)new ConstantScoreQueryBuilder((QueryBuilder)new RangeQueryBuilder("lessonStartTime").lt((Object)date.getTime())));
    }

    @Override
    public LessonCommentStatistic syncLessonCommentStatistic(Long orgId, Long lessonId, boolean immediate) {
        List<LessonCommentStatistic> statistics = this.syncLessonCommentStatistic(orgId, Lists.newArrayList((Object[])new Long[]{lessonId}), immediate);
        return CollectionUtils.isNotEmpty(statistics) ? statistics.get(0) : null;
    }

    @Override
    public List<LessonCommentStatistic> syncLessonCommentStatistic(Long orgId, Collection<Long> lessonIds, boolean immediate) {
        lessonIds = Sets.newHashSet(lessonIds);
        List lessons = this.orgClassLessonDao.getByIds((Collection)lessonIds, new String[0]);
        Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
        Map lessonStudentScoreMap = this.orgLessonCommentDao.getCommentStatisticGroupByLessonId(orgId, (Collection)lessonIds, Integer.valueOf(UserRole.STUDENT.getRole()));
        Map lessonTeacherScoreMap = this.orgLessonCommentDao.getCommentStatisticGroupByLessonId(orgId, (Collection)lessonIds, Integer.valueOf(UserRole.TEACHER.getRole()));
        Map teacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
        ArrayList result = Lists.newArrayList();
        for (OrgClassLesson lesson : lessons) {
            LessonCommentStatistic statistic = new LessonCommentStatistic();
            Long lessonId = lesson.getId();
            statistic.setLessonId(lessonId);
            statistic.setDelStatus(lesson.getDelStatus());
            statistic.setCourseId(lesson.getCourseId());
            statistic.setOrgId(lesson.getOrgId());
            statistic.setLessonStartTime(lesson.getStartTime().getTime());
            statistic.setLessonEndTime(lesson.getEndTime().getTime());
            statistic.setSyncDate(System.currentTimeMillis());
            statistic.setSyncDateStr(DateUtil.getAllDayStr((Date)new Date(statistic.getSyncDate())));
            Integer studentCount = (Integer)studentCountMap.get(lessonId);
            statistic.setStudentCount(null == studentCount ? 0L : studentCount.longValue());
            TwoTuple stuTuple = lessonStudentScoreMap.getOrDefault(lessonId, new TwoTuple((Object)0L, (Object)0L));
            statistic.setStudentCommentCount((Long)stuTuple.first);
            statistic.setStudentTotalScore((Long)stuTuple.second);
            statistic.setTeacherId((Long)teacherMap.get(lessonId));
            TwoTuple tchTuple = lessonTeacherScoreMap.getOrDefault(lessonId, new TwoTuple((Object)0L, (Object)0L));
            statistic.setTeacherCommentCount((Long)tchTuple.first);
            statistic.setTeacherTotalScore((Long)tchTuple.second);
            result.add(statistic);
        }
        if (immediate) {
            ArrayList futures = Lists.newArrayList();
            for (LessonCommentStatistic statistic : result) {
                futures.add(this.getClient().index(((IndexRequest)new IndexRequest().index(INDEX)).type(TYPE).source(JacksonUtil.obj2Map((Object)statistic)).id(statistic.getLessonId().toString())));
            }
            for (ActionFuture future : futures) {
                future.actionGet();
            }
        } else {
            BulkProcessor processor = this.getDefaultBulkProcessor();
            for (LessonCommentStatistic statistic : result) {
                processor.add(((IndexRequest)new IndexRequest().index(INDEX)).type(TYPE).source(JacksonUtil.obj2Map((Object)statistic)).id(statistic.getLessonId().toString()));
            }
        }
        return result;
    }
}

