/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.sal.elastic.dto.CourseCommentStatistic;
import com.baijia.tianxiao.sal.elastic.service.CourseCommentStatisticEsQueryer;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CourseCommentStatisticEsQueryerImpl
extends AbstractEsBaseServiceImpl
implements CourseCommentStatisticEsQueryer {
    private static final Logger log = LoggerFactory.getLogger(CourseCommentStatisticEsQueryerImpl.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<CourseCommentStatistic> getCourseCommentStatistic(Long orgId, Collection<Long> courseIds, Collection<Long> notInCourseIds, String weekEndStr, Integer order, PageDto pageDto) {
        SearchRequestBuilder search = this.getClient().prepareSearch(new String[]{"comments"}).setTypes(new String[]{"coursecomment"});
        BoolQueryBuilder builder = new BoolQueryBuilder();
        builder.must((QueryBuilder)new TermQueryBuilder("orgId", (Object)orgId));
        builder.must((QueryBuilder)new TermQueryBuilder("isDel", DeleteStatus.NORMAL.getValue()));
        if (CollectionUtils.isNotEmpty((Collection)courseIds)) {
            if (CollectionUtils.isNotEmpty(notInCourseIds)) {
                courseIds = CollectionUtils.removeAll((Collection)courseIds, notInCourseIds);
            }
            if (!CollectionUtils.isNotEmpty((Collection)courseIds)) return Lists.newArrayList();
            builder.must((QueryBuilder)new TermsQueryBuilder("courseId", (Iterable)courseIds));
        } else if (CollectionUtils.isNotEmpty(notInCourseIds)) {
            builder.mustNot((QueryBuilder)new TermsQueryBuilder("courseId", notInCourseIds));
        }
        builder.must((QueryBuilder)new TermQueryBuilder("weekEndStr", weekEndStr));
        search.setQuery((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)builder));
        search.addSort("avgScore", order == 0 ? SortOrder.DESC : SortOrder.ASC);
        search.addSort("courseId", order == 0 ? SortOrder.DESC : SortOrder.ASC);
        search.setSize(pageDto.getPageSize().intValue());
        search.setFrom(pageDto.firstNum());
        SearchResponse response = (SearchResponse)search.execute().actionGet();
        log.info("SearchResponse:{} ", (Object)response);
        SearchHits hits = response.getHits();
        pageDto.setCount(Integer.valueOf(Long.valueOf(hits.getTotalHits()).intValue()));
        ArrayList result = Lists.newArrayList();
        for (SearchHit searchHit : hits.getHits()) {
            CourseCommentStatistic statistic = (CourseCommentStatistic)JacksonUtil.str2Obj((String)JacksonUtil.obj2Str((Object)searchHit.getSource()), CourseCommentStatistic.class);
            result.add(statistic);
        }
        return result;
    }
}

