/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.elastic.dto.CourseCommentStatistic;
import com.baijia.tianxiao.sal.elastic.service.CourseCommentStatisticEsImporter;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CourseCommentStatisticEsImporterImpl
extends AbstractEsBaseServiceImpl
implements CourseCommentStatisticEsImporter {
    private static final Logger log = LoggerFactory.getLogger(CourseCommentStatisticEsImporterImpl.class);
    @Autowired
    private OrgCourseDao orgCourseDao;
    public static final String TYPE = "coursecomment";

    @Override
    public void delDocByOrgIdCourseIds(Long orgId, Collection<Long> courseIds) {
        BoolQueryBuilder builder;
        SearchRequestBuilder search = this.getClient().prepareSearch(new String[]{"comments"}).setTypes(new String[]{TYPE});
        SearchResponse response = (SearchResponse)search.setQuery((QueryBuilder)(builder = new BoolQueryBuilder().must((QueryBuilder)new TermQueryBuilder("orgId", (Object)orgId)).must((QueryBuilder)new TermsQueryBuilder("courseId", courseIds)))).setSize(10000).execute().actionGet();
        if (response.getHits().getTotalHits() > 0L) {
            for (SearchHit hit : response.getHits().getHits()) {
                Map map = hit.getSource();
                map.put("isDel", DeleteStatus.DELETED.getValue());
                this.getDefaultBulkProcessor().add(new IndexRequest("comments", TYPE, hit.getId()).source(map));
            }
        }
    }

    @Override
    public int delExpiredCourseCommentStatisticBySyncDate(Date syncDate) {
        return this.batchDeleteByQuery("comments", TYPE, (QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)new RangeQueryBuilder("syncDate").lt((Object)syncDate.getTime())));
    }

    @Override
    public void syncCourseStatistic(Long orgId, Date weekStart, Date weekEnd, Date syncDate) {
        Preconditions.checkArgument((null != orgId && orgId > 0L ? 1 : 0) != 0, (Object)"orgId invalide!");
        Preconditions.checkArgument((null != weekStart && null != weekEnd && weekStart.before(weekEnd) ? 1 : 0) != 0, (Object)"time invalide!");
        SearchRequestBuilder search = this.getClient().prepareSearch(new String[]{"comments"}).setTypes(new String[]{"lessoncomment"});
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().must((QueryBuilder)new TermQueryBuilder("orgId", (Object)orgId)).must((QueryBuilder)new TermQueryBuilder("delStatus", 0)).must((QueryBuilder)new RangeQueryBuilder("lessonStartTime").gt((Object)weekStart.getTime()).lte((Object)weekEnd.getTime()));
        search.setQuery((QueryBuilder)boolQueryBuilder);
        search.setSize(0);
        TermsAggregationBuilder termsBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"course").field("courseId")).size(50000);
        search.addAggregation((AggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"studentCommentCountSum").field("studentCommentCount"))).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"studentCountSum").field("studentCount"))).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"studentTotalScoreSum").field("studentTotalScore"))).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"teacherCommentCountSum").field("teacherCommentCount")));
        SearchResponse response = (SearchResponse)search.execute().actionGet();
        log.debug("response:{} ", (Object)response);
        ArrayList list = Lists.newArrayList();
        Terms aggregation = (Terms)response.getAggregations().get("course");
        List courseIds = aggregation.getBuckets().stream().map(o -> o.getKeyAsNumber().longValue()).collect(Collectors.toList());
        Map map = this.orgCourseDao.getOrgCourseMap(courseIds, new String[]{"id", "isDel"});
        for (Terms.Bucket bucket : aggregation.getBuckets()) {
            long courseId = bucket.getKeyAsNumber().longValue();
            long lessonCount = bucket.getDocCount();
            Aggregations innerAgg = bucket.getAggregations();
            Sum studentCommentCountSum = (Sum)innerAgg.get("studentCommentCountSum");
            Sum studentCountSum = (Sum)innerAgg.get("studentCountSum");
            Sum studentTotalScoreSum = (Sum)innerAgg.get("studentTotalScoreSum");
            Sum teacherCommentCountSum = (Sum)innerAgg.get("teacherCommentCountSum");
            CourseCommentStatistic courseCommentStatistic = new CourseCommentStatistic();
            courseCommentStatistic.setOrgId(orgId);
            courseCommentStatistic.setCourseId(courseId);
            courseCommentStatistic.setIsDel(((OrgCourse)map.get(courseId)).getIsDel());
            courseCommentStatistic.setWeekStart(weekStart.getTime());
            courseCommentStatistic.setWeekStartStr(DateUtil.getStrByDate((Date)weekStart));
            courseCommentStatistic.setWeekEnd(weekEnd.getTime());
            courseCommentStatistic.setWeekEndStr(DateUtil.getStrByDate((Date)weekEnd));
            courseCommentStatistic.setSyncDate(syncDate.getTime());
            courseCommentStatistic.setSyncDateStr(DateUtil.getAllDayStr((Date)syncDate));
            courseCommentStatistic.setLessonCount(lessonCount);
            courseCommentStatistic.setStudentCommentCountSum(Math.round(studentCommentCountSum.getValue()));
            courseCommentStatistic.setStudentCountSum(Math.round(studentCountSum.getValue()));
            courseCommentStatistic.setStudentTotalScoreSum(Math.round(studentTotalScoreSum.getValue()));
            courseCommentStatistic.setTeacherCommentCountSum(Math.round(teacherCommentCountSum.getValue()));
            courseCommentStatistic.setAvgScore(studentCommentCountSum.getValue() > 0.0 ? Math.round(studentTotalScoreSum.getValue() / studentCommentCountSum.getValue()) : 0L);
            log.debug("courseCommentStatistic:{} ", (Object)courseCommentStatistic);
            list.add(courseCommentStatistic);
        }
        BulkProcessor processor = this.getDefaultBulkProcessor();
        for (CourseCommentStatistic statistic : list) {
            processor.add(new IndexRequest("comments", TYPE).id(statistic.getCourseId().toString() + "_" + statistic.getWeekEndStr()).source(JacksonUtil.obj2Map((Object)statistic)));
        }
    }
}

