/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.roster.UserLastFollowTime;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.sal.elastic.service.ConsultUserDataImportService;
import com.baijia.tianxiao.sal.elastic.service.impl.AbstractEsBaseServiceImpl;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsultUserDataImportServiceImpl
extends AbstractEsBaseServiceImpl
implements ConsultUserDataImportService {
    private static final Logger log = LoggerFactory.getLogger(ConsultUserDataImportServiceImpl.class);
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TxStudentTagDao tagDao;
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private TxStudentCommentDao studentCommentDao;
    final long daytime = 86400000L;

    @Override
    public void importByOrgId(Long orgId) {
        long time = System.currentTimeMillis();
        BulkProcessor bulkProcessor = this.getDefaultBulkProcessor();
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(3000));
        List consultUsers = null;
        consultUsers = orgId == null ? this.consultUserDao.getByPage(page, new String[0]) : this.consultUserDao.getConsultUserByOrgIdAndPage(orgId, page);
        while (consultUsers.size() > 0) {
            List consultUserIds = ListUtil.toKeyList((Collection)consultUsers, (String)"id", TxConsultUser.class);
            Map valueMap = this.customFieldValueDao.batchGetValueMap(null, false, (Collection)consultUserIds, null);
            List tags = this.tagDao.getTags((Collection)consultUserIds, null, Integer.valueOf(StudentType.CONSULT_USER.getCode()), null);
            Map<Long, List<TxStudentTag>> studentTags = this.toMap(tags, StudentType.CONSULT_USER);
            for (TxConsultUser consultUser : consultUsers) {
                Map<String, Object> map = this.consultUserToMap(consultUser, (List)valueMap.get(consultUser.getId()), studentTags.get(consultUser.getId()));
                bulkProcessor.add(((IndexRequest)new IndexRequest().index("consult_users")).type("consult_user").source(map).id(consultUser.getId().toString()));
            }
            page.setPageNum(Integer.valueOf(page.getPageNum() + 1));
            if (orgId == null) {
                consultUsers = this.consultUserDao.getByPage(page, new String[0]);
                continue;
            }
            consultUsers = this.consultUserDao.getConsultUserByOrgIdAndPage(orgId, page);
        }
        log.info("import {} data costs:{}", (Object)page.getCount(), (Object)(System.currentTimeMillis() - time));
    }

    @Override
    public void saveConsultToEs(Long consultUserId) {
        log.info("[ES] update consultUserId={}", (Object)consultUserId);
        TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consultUserId, new String[0]);
        int i = 1;
        while (consultUser == null && i <= 10) {
            try {
                Thread.sleep(i * 5 * 1000);
                consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consultUserId, new String[0]);
                log.warn("[ES] Retry count={},consultUserId={}", (Object)(++i), (Object)consultUserId);
            }
            catch (InterruptedException e) {
                log.error("[ES] InterruptedException error={}", (Throwable)e);
            }
        }
        if (consultUser == null) {
            log.error("[ES] consultUserId={} is not exist", (Object)consultUserId);
            return;
        }
        DeleteResponse deleteresponse = (DeleteResponse)this.getClient().prepareDelete("consult_users", "consult_user", String.valueOf(consultUserId)).execute().actionGet();
        long time = System.currentTimeMillis();
        ArrayList<TxConsultUser> consultUsers = new ArrayList<TxConsultUser>();
        consultUsers.add(consultUser);
        TransportClient client = this.getClient();
        List consultUserIds = ListUtil.toKeyList(consultUsers, (String)"id", TxConsultUser.class);
        List userIds = ListUtil.toKeyList(consultUsers, (String)"userId", TxConsultUser.class);
        Map valueMap = this.customFieldValueDao.batchGetValueMap(null, false, (Collection)consultUserIds, null);
        List tags = this.tagDao.getTags(consultUserId, null, Integer.valueOf(StudentType.CONSULT_USER.getCode()), null);
        Map<Long, List<TxStudentTag>> studentTags = this.toMap(tags, StudentType.CONSULT_USER);
        BulkRequestBuilder bulkRequest = client.prepareBulk();
        bulkRequest.add(((IndexRequest)new IndexRequest().index("consult_users")).type("consult_user").source(this.consultUserToMap(consultUser, (List)valueMap.get(consultUser.getId()), studentTags.get(consultUser.getId()))).id(consultUser.getId().toString()));
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
        if (bulkResponse.hasFailures()) {
            log.error("import fail:{}", (Object)bulkResponse.buildFailureMessage());
        } else {
            log.info("import data costs:{}", (Object)(System.currentTimeMillis() - time));
        }
    }

    @Override
    public void fullImport() {
        this.importByOrgId(null);
    }

    @Override
    public void importLastFollowTime() {
        long time = System.currentTimeMillis();
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(3000));
        List data = this.studentCommentDao.getLastFollowComment(page, Integer.valueOf(StudentType.CONSULT_USER.getCode()));
        while (data.size() > 0) {
            for (UserLastFollowTime user : data) {
                TxConsultUser consultUser = this.consultUserDao.getOrgConsultUser(user.getOrgId(), user.getId());
                if (consultUser == null) continue;
                consultUser.setLastFollowTime(user.getLastFollowTime());
                this.consultUserDao.update((Object)consultUser, new String[]{"lastFollowTime"});
            }
            page.setCount(Integer.valueOf((page.getPageNum() - 1) * page.getPageSize() + data.size()));
            page.setPageNum(Integer.valueOf(page.getPageNum() + 1));
            data = this.studentCommentDao.getLastFollowComment(page, Integer.valueOf(StudentType.CONSULT_USER.getCode()));
        }
        log.info("import {} data costs:{}", (Object)page.getCount(), (Object)(System.currentTimeMillis() - time));
    }

    @Override
    public void importDataLastDay(int hour) {
        long time = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -hour);
        Date lastDay = calendar.getTime();
        List consultUsers = this.consultUserDao.getYesterdayUpdate(lastDay);
        for (TxConsultUser consultUser : consultUsers) {
            this.saveConsultToEs(consultUser.getId());
        }
        log.info("import data costs:{}", (Object)(System.currentTimeMillis() - time));
    }

    public Map<String, Object> consultUserToMap(TxConsultUser consultUser, List<CustomFieldValue> customFieldValues, List<TxStudentTag> tags) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", consultUser.getId());
        map.put("user_id", consultUser.getUserId());
        map.put("org_id", consultUser.getOrgId());
        map.put("name", consultUser.getName());
        map.put("school", consultUser.getSchool());
        map.put("_mobile", consultUser.getMobile());
        map.put("weixin", consultUser.getWeixin());
        map.put("consult_source", consultUser.getConsultSource());
        map.put("_parent_name", consultUser.getParentName());
        map.put("_parent_mobile", consultUser.getParentMobile());
        map.put("intension_level", consultUser.getIntensionLevel());
        map.put("consult_status", consultUser.getConsultStatus());
        map.put("student_id", consultUser.getStudentId());
        String pinyin = HanZiPinYinUtils.getLowerCasePinYin((String)consultUser.getName());
        if (StringUtils.isNotBlank((CharSequence)pinyin)) {
            char init = pinyin.charAt(0);
            if (init < 'a' || init > 'z') {
                pinyin = "~";
            }
        } else {
            pinyin = "~";
        }
        map.put("pinyin", pinyin);
        if (consultUser.getBirthday() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(consultUser.getBirthday());
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (GenericsUtils.notNullAndEmpty((Object)consultUser.getBirthday())) {
                map.put("birthday", consultUser.getBirthday().getTime());
                map.put("birthDayOfMonth", calendar.get(5));
                map.put("birthMonth", calendar.get(2) + 1);
                map.put("birthYear", calendar.get(1));
            } else {
                map.put("birthday", -1);
                map.put("birthDayOfMonth", -1);
                map.put("birthMonth", -1);
                map.put("birthYear", -1);
            }
        }
        if (consultUser.getLastRemindTime() != null) {
            map.put("last_remind_time", consultUser.getLastRemindTime().getTime());
        } else {
            map.put("last_remind_time", -1);
        }
        if (consultUser.getLastFollowTime() != null) {
            map.put("last_follow_time", consultUser.getLastFollowTime().getTime());
        } else {
            map.put("last_follow_time", -1);
        }
        if (consultUser.getFinallyHoldTime() != null) {
            map.put("finally_hold_time", consultUser.getFinallyHoldTime().getTime());
        } else {
            map.put("finally_hold_time", -1);
        }
        map.put("qq", consultUser.getQq());
        map.put("mail", consultUser.getMail());
        map.put("relatives", consultUser.getRelatives());
        map.put("degree_class", consultUser.getDegreeClass());
        map.put("address", consultUser.getAddress());
        map.put("create_time", consultUser.getCreateTime().getTime());
        map.put("update_time", consultUser.getUpdateTime().getTime());
        map.put("del_status", consultUser.getDelStatus());
        map.put("sex", consultUser.getSex());
        map.put("cascade_id", consultUser.getCascadeId());
        map.put("is_invalid", consultUser.getIsInvalid());
        if (consultUser.getLastBrowseTime() != null) {
            map.put("last_browse_time", consultUser.getLastBrowseTime().getTime());
        } else {
            map.put("last_browse_time", -1);
        }
        if (consultUser.getNextRemindTime() != null) {
            map.put("next_remind_time", consultUser.getNextRemindTime().getTime());
        } else {
            map.put("next_remind_time", -1);
        }
        map.put("is_consulter", consultUser.getIsConsulter());
        HashMap<String, Map> customFieldMap = new HashMap<String, Map>();
        if (customFieldValues != null) {
            for (CustomFieldValue value : customFieldValues) {
                try {
                    Map valueMap = (Map)JacksonUtil.str2Obj((String)value.getValue(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                    customFieldMap.put(value.getFieldId().toString(), valueMap);
                }
                catch (IOException e) {
                    log.error("IOException = {}", (Throwable)e);
                }
            }
        }
        map.put("custom_field", customFieldMap);
        String tagStr = "";
        if (tags != null && tags.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (TxStudentTag tag : tags) {
                sb.append(",").append(tag.getContent());
            }
            tagStr = sb.substring(1);
        }
        map.put("tag", tagStr);
        return map;
    }
}

