/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.es.constant.EsClientConfig;
import com.baijia.tianxiao.dal.es.exceptions.EsException;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.sal.elastic.service.EsBaseService;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.ArrayUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractEsBaseServiceImpl
implements EsBaseService {
    private static final Logger log = LoggerFactory.getLogger(AbstractEsBaseServiceImpl.class);
    @Autowired
    protected CustomFieldDao customFieldDao;
    private static volatile TransportClient transportClient;
    private static volatile BulkProcessor bulkProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransportClient getClient() {
        if (null == transportClient) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (null == transportClient) {
                    long time = System.currentTimeMillis();
                    Settings settings = Settings.builder().put("cluster.name", EsClientConfig.clusterNameString).build();
                    PreBuiltTransportClient creatingClient = new PreBuiltTransportClient(settings, new Class[0]);
                    for (Map.Entry entry : EsClientConfig.getAddressList()) {
                        try {
                            creatingClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName((String)entry.getKey()), ((Integer)entry.getValue()).intValue()));
                        }
                        catch (UnknownHostException e) {
                            log.error("[AbstractEsBaseDao] invalide ip or port, and ignored! ip:{}, port:{}", entry.getKey(), entry.getValue());
                        }
                    }
                    log.info("[{}] init transportClient done! costs:{}ms", (Object)this.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - time));
                    transportClient = creatingClient;
                }
            }
        }
        return transportClient;
    }

    @Override
    public void createIndex(String index, int numberOfShards, int numberOfReplicas) {
        try {
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)this.getClient().admin().indices().prepareCreate(index).setSettings(Settings.builder().put("number_of_shards", numberOfShards).put("number_of_replicas", numberOfReplicas).build()).get();
            log.warn("[{}] create es index:{} with {} Shards, {} Replicas result:{}", new Object[]{this.getClass().getSimpleName(), index, numberOfShards, numberOfReplicas, createIndexResponse.isAcknowledged()});
        }
        catch (Exception e) {
            log.error("[{}] create es index:{} with {} Shards, {} Replicas error! e:{}", new Object[]{this.getClass().getSimpleName(), index, numberOfShards, numberOfReplicas, e});
            throw new EsException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, e.getMessage());
        }
    }

    @Override
    public void deleteIndex(String index) {
        try {
            DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)this.getClient().admin().indices().prepareDelete(new String[]{index}).get();
            log.warn("[{}] delete es index:{} result:{}", new Object[]{this.getClass().getSimpleName(), index, deleteIndexResponse.isAcknowledged()});
        }
        catch (Exception e) {
            log.error("[{}] delete es index:{} error! e:{}", new Object[]{this.getClass().getSimpleName(), index, e});
            throw new EsException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, e.getMessage());
        }
    }

    @Override
    public void flushBulkProcessor() {
        if (null != bulkProcessor) {
            bulkProcessor.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkProcessor getDefaultBulkProcessor() {
        if (null == bulkProcessor) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (null == bulkProcessor) {
                    bulkProcessor = BulkProcessor.builder((Client)this.getClient(), (BulkProcessor.Listener)new BulkProcessor.Listener(){

                        public void beforeBulk(long executionId, BulkRequest request) {
                        }

                        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                            log.info("bulk ok, executionId:{}, numOfActions:{}, costs:{}ms, hasFailures:{}", new Object[]{executionId, request.numberOfActions(), response.getTookInMillis(), response.hasFailures()});
                            if (response.hasFailures()) {
                                log.error("bulk failed, executionId:{}, numOfActions:{}, costs:{}ms, hasFailures:{}, failMsg:{} ", new Object[]{executionId, request.numberOfActions(), response.getTookInMillis(), response.hasFailures(), response.buildFailureMessage()});
                            }
                        }

                        public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                            log.error("bulk failed!, error:{} ", failure);
                        }
                    }).setConcurrentRequests(3).setBulkActions(20000).setBulkSize(new ByteSizeValue(5L, ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)2L)).build();
                }
            }
        }
        return bulkProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void preDestory() {
        if (null != bulkProcessor) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (null != bulkProcessor) {
                    bulkProcessor.flush();
                    bulkProcessor.close();
                    bulkProcessor = null;
                }
            }
        }
    }

    protected RangeQueryBuilder getTimestampRangeQueryBuilder(String key, Date from, Date to) {
        long to_time;
        long from_time = null == from ? 0L : from.getTime();
        long l = to_time = null == to ? 0L : to.getTime();
        if (key.equals("finally_hold_time") && 0L == from_time) {
            from_time = -1L;
        }
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)key);
        rangeQueryBuilder.from((Object)from_time);
        rangeQueryBuilder.to((Object)to_time);
        return rangeQueryBuilder;
    }

    protected MatchQueryBuilder getMatchQuery(String key, Object value) {
        return QueryBuilders.matchQuery((String)key, (Object)value);
    }

    protected WildcardQueryBuilder getWildcardQuery(String key, Object value) {
        return QueryBuilders.wildcardQuery((String)key, (String)("*" + value + "*"));
    }

    protected FuzzyQueryBuilder getFuzzyQuery(String key, Object value) {
        return QueryBuilders.fuzzyQuery((String)key, (Object)value);
    }

    protected RangeQueryBuilder getDateRangeQueryBuilder(String key, Date from, Date to) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)key);
        rangeQueryBuilder.from((Object)sdf.format(from));
        rangeQueryBuilder.to((Object)sdf.format(to));
        return rangeQueryBuilder;
    }

    protected String getCustomFieldKey(String key, Long orgId) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append("custom_field.").append(key);
        CustomField field = this.customFieldDao.getCustomFieldById(orgId, Long.valueOf(Long.parseLong(key)));
        if (field == null) {
            log.warn("[ES] Field is not exist.Field={}", (Object)key);
            return "-";
        }
        if (field.getType() == 3) {
            keyBuilder.append(".options");
        }
        return keyBuilder.append(".id").toString();
    }

    protected Map<Long, List<TxStudentTag>> toMap(List<TxStudentTag> tags, StudentType userType) {
        HashMap<Long, List<TxStudentTag>> retMap = new HashMap<Long, List<TxStudentTag>>();
        for (TxStudentTag tag : tags) {
            long key = 0L;
            key = userType == StudentType.CONSULT_USER ? tag.getConsultUserId().longValue() : tag.getUserId().longValue();
            ArrayList<TxStudentTag> list = (ArrayList<TxStudentTag>)retMap.get(key);
            if (list == null) {
                list = new ArrayList<TxStudentTag>();
                retMap.put(key, list);
            }
            list.add(tag);
        }
        return retMap;
    }

    @Override
    public int batchDeleteByQuery(String index, String type, QueryBuilder queryBuilder) {
        long ct = System.currentTimeMillis();
        HashSet ids = Sets.newHashSet();
        SearchResponse response = (SearchResponse)this.getClient().prepareSearch(new String[]{index}).setTypes(new String[]{type}).setQuery((QueryBuilder)new ConstantScoreQueryBuilder(queryBuilder)).setSize(300).setScroll(TimeValue.MINUS_ONE).setFetchSource(false).execute().actionGet();
        log.debug("response:{} ", (Object)response);
        ids.addAll(Arrays.stream(response.getHits().getHits()).map(searchHitFields -> searchHitFields.getId()).collect(Collectors.toList()));
        while (ArrayUtils.isNotEmpty((Object[])response.getHits().getHits())) {
            response = (SearchResponse)this.getClient().prepareSearchScroll(response.getScrollId()).setScroll(TimeValue.MINUS_ONE).execute().actionGet();
            log.debug("response:{} ", (Object)response);
            ids.addAll(Arrays.stream(response.getHits().getHits()).map(searchHitFields -> searchHitFields.getId()).collect(Collectors.toList()));
        }
        this.getClient().prepareClearScroll().addScrollId(response.getScrollId()).execute().actionGet();
        for (String id : ids) {
            this.getDefaultBulkProcessor().add(new DeleteRequest(index, type, id));
        }
        log.info("delete doc. index:{}, type:{}, ids size:{}, costs:{}ms, query:{} ", new Object[]{index, type, ids.size(), System.currentTimeMillis() - ct, queryBuilder});
        log.debug("delete ids:{} ", (Object)ids);
        return ids.size();
    }
}

