/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.elastic.service.impl;

import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.sal.elastic.service.StudentDataImportService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StudentDataImportServiceImpl
implements StudentDataImportService {
    private static final Logger log = LoggerFactory.getLogger(StudentDataImportServiceImpl.class);
    @Autowired
    private OrgStudentDao studentDao;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void dataImportByOrgId(long orgId) {
        PageDto page = new PageDto();
        page.setPageSize(Integer.valueOf(100000));
        List students = this.studentDao.getByPage(page, new String[0]);
        try {
            Settings settings = Settings.builder().put("cluster.name", "tx_es_cluster").build();
            TransportClient client = new PreBuiltTransportClient(settings, new Class[0]).addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName("172.21.139.12"), 9300));
            BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
            for (OrgStudent student : students) {
                bulkRequestBuilder.add(((IndexRequest)new IndexRequest().index("students")).type("student").source(this.objectMapper.writeValueAsBytes((Object)student)).id(student.getId().toString()));
            }
            BulkResponse resp = (BulkResponse)bulkRequestBuilder.execute().actionGet();
            log.info("resp costs:{}ms", (Object)resp.getTookInMillis());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> studentToMap(OrgStudent student) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", student.getId());
        map.put("user_id", student.getUserId());
        map.put("org_id", student.getOrgId());
        map.put("name", student.getName());
        map.put("mobile", student.getMobile());
        map.put("weixin", student.getWeixin());
        map.put("lesson_status", student.getLessonStatus());
        map.put("add_cascade_id", student.getAddCascadeId());
        map.put("parent_name", student.getParentName());
        map.put("parent_mobile", student.getParentMobile());
        String pinyin = HanZiPinYinUtils.getLowerCasePinYin((String)student.getName());
        if (StringUtils.isNotBlank((CharSequence)pinyin)) {
            char init = pinyin.charAt(0);
            if (init < 'a' || init > 'z') {
                pinyin = "~";
            }
        } else {
            pinyin = "~";
        }
        map.put("pinyin", pinyin);
        map.put("gender", student.getGender());
        map.put("del_status", student.getDelStatus());
        map.put("avatar", student.getAvatar());
        map.put("create_time", student.getCreateTime().getTime());
        map.put("update_time", student.getUpdateTime().getTime());
        return map;
    }
}

