/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.es.constant;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.dal.es.exceptions.EsException;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsClientConfig {
    private static final Logger log = LoggerFactory.getLogger(EsClientConfig.class);
    public static final String addressString;
    public static final String clusterNameString;

    private EsClientConfig() {
    }

    public static List<Map.Entry<String, Integer>> getAddressList() {
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)addressString) && StringUtils.isNotEmpty((CharSequence)clusterNameString) ? 1 : 0) != 0, (Object)"properties read failed!");
        ArrayList<Map.Entry<String, Integer>> result = new ArrayList<Map.Entry<String, Integer>>();
        try {
            String[] ipAndPorts;
            for (String ipAndPort : ipAndPorts = addressString.split(",")) {
                String[] split = ipAndPort.split(":");
                result.add(new AbstractMap.SimpleEntry<String, Integer>(split[0], Integer.parseInt(split[1])));
            }
        }
        catch (RuntimeException e) {
            log.error("[EsClientConfig] read properties failed! maybe config style error:{}", (Throwable)e);
            throw new EsException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "es\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef");
        }
        return result;
    }

    static {
        String address = null;
        String clusterName = null;
        try {
            address = PropertiesReader.getValue((String)"elasticsearch", (String)"address");
            clusterName = PropertiesReader.getValue((String)"elasticsearch", (String)"clusterName");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)address), (Object)"address empty!");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)clusterName), (Object)"clusterName empty!");
            log.info("[EsClientConfig] read properties success! address:{}, clusterName:{}", (Object)address, (Object)clusterName);
        }
        catch (Exception e) {
            log.warn("[EsClientConfig] read properties failed! error:{}", (Throwable)e);
        }
        finally {
            addressString = address;
            clusterNameString = clusterName;
        }
    }
}

